
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.io.*;


/**
 * An interface for objects on a figure.
 */

public interface SGIGraphElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public boolean setAxisElement( SGIAxisElement aElement );


	/**
	 * 
	 */
	public String getDataName( SGData data );


	/**
	 * 
	 */
	public ArrayList getDrawingElementList( SGData data );


	/**
	 * 
	 */
	public boolean isDataVisible( SGData data );


	/**
	 * 
	 * @param data
	 * @return
	 */
	public boolean isCommited( SGData data );


	/**
	 * 
	 */
	public boolean writePropertyOfData( Writer writer ) throws IOException;


	/**
	 * 
	 * @return
	 */
	public int getVisibleDataNumber();


	/**
	 * 
	 */
	public int getSelectedDataNumber();


	/**
	 * 
	 */
	public boolean removeSelectedData();


	/**
	 * 
	 */
	public boolean hideSelectedData();


	/**
	 * 
	 */
	public boolean moveSelectedDataToFront();


	/**
	 * 
	 */
	public boolean moveSelectedDataToBack();


	/**
	 * 
	 */
	public boolean getTimingElementList(
		ArrayList axisList, ArrayList elementListListList, ArrayList valueListList );


	/**
	 * 
	 */
	public boolean changeXAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeYAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeZAxis( SGData data );


	/**
	 * 
	 */
	public ArrayList getVisibleFlagList( SGData data );


	/**
	 * 
	 */
	public boolean addSignificantDifferenceSymbol( final int x, final int y );


	/**
	 * 
	 * @return
	 */
	public ArrayList getPropertySettingListerListOfDataElements();


	/**
	 * 
	 * @return
	 */
	public SGPropertyDialog getPropertyDialogForDataElements();




	public static final String PF_GRAPH_TITLE = "[Graph]";

	public static final String PF_DATA_TITLE = "[Data]";
//	public static final String PF_DATA_END = "Data End";
//	public static final String PF_ALL_DATA_END = "All Datas End";

	public static final String PF_SAMPLING_RATE = "Sampling Rate";


	public static final String PF_LOCATION_X_AXIS = "Location of the X-Axis";
	public static final String PF_LOCATION_Y_AXIS = "Location of the Y-Axis";
	public static final String PF_LOCATION_Z_AXIS = "Location of the Z-Axis";


	public static final String PF_SIGDIFF_ELEMENT_TITLE
		= "<Significant Difference Symbol>";
	public static final String PF_SIGDIFF_X = "X";
	public static final String PF_SIGDIFF_Y = "Y";
	public static final String PF_SIGDIFF_WIDTH = "Width";
	public static final String PF_SIGDIFF_LEFT_HEIGHT = "Left Height";
	public static final String PF_SIGDIFF_RIGHT_HEIGHT = "Right Height";
	public static final String PF_SIGDIFF_LINE_WIDTH = "Line Width";

}

