
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;


/**
 * An interface for objects on a figure.
 */

public interface SGIFigureElement extends ActionListener, SGIUndoable, SGIConstants
{

	/**
	 * Add a new data.
	 * @param data a new data.
	 * @return true:secceeded, false:failed
	 */
	public boolean addData( SGData data );



	/**
	 * 
	 */
	public boolean removeData( SGData data );


	/**
	 * 
	 */
	public ArrayList getDataList();



	/**
	 * Zoom in/out this component.<BR>
	 */
	public boolean zoom( float mag );


	/**
	 * Synchronize this component to the other component. <BR>
	 * @param element the SGFigureElement object whose property has chenged.
	 * @return true:succeeded, false:failed
	 */
	public boolean synchronize( SGIFigureElement element );


	/**
	 * 
	 */
	public boolean synchronizeArgument( SGIFigureElement element );



	/**
	 * 
	 * @param rect
	 * @return
	 */
	public void notifyChange();


	/**
	 * 
	 */
	public boolean setViewBounds( Rectangle2D rect );



	/**
	 * 
	 * @param topAndBottom
	 * @param leftAndRight
	 * @return
	 */
	public boolean getMarginAroundGraphAreaRect(
		final SGTuple2f topAndBottom,
		final SGTuple2f leftAndRight );


	/**
	 * 
	 * @return
	 */
	public float getGraphAreaX();


	/**
	 * 
	 * @return
	 */
	public float getGraphAreaY();


	/**
	 * 
	 * @return
	 */
	public float getGraphAreaWidth();


	/**
	 * 
	 * @return
	 */
	public float getGraphAreaHeight();


	/**]
	 * 
	 */
	public Rectangle2D getGraphAreaRect();



	/**
	 * 
	 * @return
	 */
	public boolean setGraphAreaRect( float x, float y, float width, float height );


	/**
	 * 
	 */
	public boolean setGraphAreaLocation( float x, float y );


	/**
	 * 
	 */
	public boolean setGraphAreaSize( float width, float height );



	/**
	 * 
	 */
	public SGTuple2f getISize();


	/**
	 * 
	 */
	public SGTuple2f getILocation();


	/**
	 * 
	 */
	public boolean setISize( SGTuple2f size );


	/**
	 * 
	 */
	public boolean setILocation( SGTuple2f pos );



	/**
	 * 
	 */
	public boolean setDialogOwner( Frame frame );



	/**
	 * 
	 */
	public Cursor getFigureElementCursor();



	/**
	 * 
	 * @param e
	 */
	public boolean onMouseClicked( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMousePressed( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseDragged( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseReleased( MouseEvent e );


	/**
	 * 
	 */
	public boolean onKeyPressed( KeyEvent e );


	/**
	 * 
	 */
	public boolean onKeyReleased( KeyEvent e );


	/**
	 * 
	 */
	public boolean onKeyTyped( KeyEvent e );



	/**
	 * 
	 * @param e
	 */
	public boolean onDrawingElement( int x, int y );



	/**
	 * 
	 */
	public void addActionListener( ActionListener listener );


	/**
	 * 
	 */
	public void removeActionListener( ActionListener listener );


	/**
	 * 
	 */
	public boolean writeProperty( Writer writer ) throws IOException;


	/**
	 * 
	 */
	public boolean readProperty( BufferedReader br ) throws IOException;


	/**
	 * 
	 */
	public boolean createDataObject( BufferedReader reader, SGData data ) throws IOException;


	/**
	 * 
	 */
	public boolean isResizable( double w, double h );


	/**
	 * 
	 */
	public boolean chkBoundsVisible();



	/**
	 * 
	 * @return
	 */
	public boolean clearSelectedElements();



	public static final String PF_CLASS_NAME = "Class Name";
	public static final String PF_FONT_SIZE = "Font Size";
	public static final String PF_FONT_FAMILY_NAME = "Font Family Name";
	public static final String PF_FONT_STYLE = "Font Style";
	public static final String PF_STRING_COLOR = "String Color";
	public static final String PF_DATA_NAME = "Name";

	public static final String PF_STRING_TEXT = "Text";
	public static final String PF_STRING_ANGLE = "Angle";
	public static final String PF_STRING_COLOR_LIST = "Color List";


}
