/*
 * SGDataAdditionWizardFrame.java
 *
 * Created on 2004/06/18, 14:44
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGXYDataTypeSelectionWizardDialog extends SGWizardDialog
{
	
	/**
	 * 
	 */
	public static final String TITLE = "Select the data type.";
    

	/**
	 * 
	 */
	public SGXYDataTypeSelectionWizardDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}

    
	/**
	 * 
	 * @param title
	 */
	public SGXYDataTypeSelectionWizardDialog( final Frame owner, final boolean modal )
	{
		super(owner,modal);
		this.initComponents();
		this.initProperty();
	}

   
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mScalarXYRadioButton = new javax.swing.JRadioButton();
        mMultipleXYRadioButton = new javax.swing.JRadioButton();
        mSamplingXYRadioButton = new javax.swing.JRadioButton();
        mSamplingRateField = new javax.swing.JTextField();
        mVectorXYRadioButton = new javax.swing.JRadioButton();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.EtchedBorder());
        mScalarXYRadioButton.setText("Scalar-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mScalarXYRadioButton, gridBagConstraints);

        mMultipleXYRadioButton.setText("Multiple-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mMultipleXYRadioButton, gridBagConstraints);

        mSamplingXYRadioButton.setText("Sampling-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mSamplingXYRadioButton, gridBagConstraints);

        mSamplingRateField.setColumns(3);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        mPanel.add(mSamplingRateField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mPanel, gridBagConstraints);

        mVectorXYRadioButton.setText("Vector-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(mVectorXYRadioButton, gridBagConstraints);

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mPreviousButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    protected javax.swing.JButton mCancelButton;
    private javax.swing.JRadioButton mMultipleXYRadioButton;
    protected javax.swing.JButton mNextButton;
    protected javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    protected javax.swing.JButton mPreviousButton;
    private javax.swing.JTextField mSamplingRateField;
    private javax.swing.JRadioButton mSamplingXYRadioButton;
    private javax.swing.JRadioButton mScalarXYRadioButton;
    private javax.swing.JRadioButton mVectorXYRadioButton;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	private TreeMap mDataTypeMap = new TreeMap();



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGXYDataTypeSelectionWizardDialog.TITLE );

		// create a button-group
		ButtonGroup group = new ButtonGroup();
		group.add( this.mScalarXYRadioButton );
		group.add( this.mVectorXYRadioButton );
		group.add( this.mMultipleXYRadioButton );
		group.add( this.mSamplingXYRadioButton );


		// initialize components
		this.mScalarXYRadioButton.setSelected(true);
		this.mSamplingRateField.setEnabled(false);
		this.mSamplingRateField.setText( new Double(1.0).toString() );


		// add itself as an action lister
		this.mScalarXYRadioButton.addActionListener(this);
		this.mVectorXYRadioButton.addActionListener(this);
		this.mMultipleXYRadioButton.addActionListener(this);
		this.mSamplingXYRadioButton.addActionListener(this);


		// initialize the map
		this.mDataTypeMap.put( SGDataTypeConstants.SXY_DATA, this.mScalarXYRadioButton );
		this.mDataTypeMap.put( SGDataTypeConstants.VXY_DATA, this.mVectorXYRadioButton );
		this.mDataTypeMap.put( SGDataTypeConstants.SXY_MULTIPLE_DATA, this.mMultipleXYRadioButton );
		this.mDataTypeMap.put( SGDataTypeConstants.SXY_SAMPLING_DATA, this.mSamplingXYRadioButton );


//
this.mVectorXYRadioButton.setVisible(false);
this.pack();

this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);


		return true;

	}



	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
//System.out.println("add:"+listener);

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);

		return true;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
		}

		return true;
	}



	/**
	 * 
	 */
	public String getSelectedDataType()
	{
		String str = null;

		Iterator itr = this.mDataTypeMap.keySet().iterator();
		while( itr.hasNext() )
		{
			Object key = itr.next();
			JRadioButton btn = (JRadioButton)this.mDataTypeMap.get(key);
			if( btn.isSelected() )
			{
				str = (String)key;
				break;
			}
		}

		return str;

	}



	/**
	 * 
	 */
	public boolean setEffectiveDataType( final ArrayList list )
	{
		if( list==null )
		{
			return false;
		}

		if( list.size()==0 )
		{
			return false;
		}

		boolean b = false;
		Iterator itr = this.mDataTypeMap.keySet().iterator();
		while( itr.hasNext() )
		{
			Object key = itr.next();
			JRadioButton btn = (JRadioButton)this.mDataTypeMap.get(key);
			boolean flag = list.contains( key );
			if( btn.isSelected() )
			{
				if( !flag )
				{
					b = true;
				}
			}
			btn.setEnabled(flag);
		}

		// gps\ȃf[^^̃{^IĂԂ鏈
		if( b )
		{
			itr = this.mDataTypeMap.keySet().iterator();
			while( itr.hasNext() )
			{
				Object key = itr.next();
				JRadioButton btn = (JRadioButton)this.mDataTypeMap.get(key);
				boolean flag = list.contains( key );
				btn.setSelected(flag);
				break;
			}
			
		}
	
		return true;

	}


	/**
	 * 
	 */
	public Double getSamplingRate()
	{
		String str = this.mSamplingRateField.getText();
		Double rate = null;
		try
		{
			rate = Double.valueOf(str);
		}
		catch( NumberFormatException ex )
		{
			ex.printStackTrace();
		}
		return rate;
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
        
		if( source.equals( this.mSamplingXYRadioButton ) )
		{
			this.mSamplingRateField.setEnabled(true);
		}
		else
		{
			if( source instanceof JRadioButton )
			{
				this.mSamplingRateField.setEnabled(false);
			}
		}

	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


}
