/*
 * SGStartupUsePropertyDialog.java
 *
 * Created on 2004/10/15, 13:48
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGStartupUsePropertyDialog extends SGWizardDialog
{

	/**
	 * 
	 */
    public static final String TITLE = "Use Property File?";


	/**
	 * 
	 *
	 */
	public SGStartupUsePropertyDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}


    /** Creates new form SGStartupUsePropertyDialog */
    public SGStartupUsePropertyDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mRadioButtonPanel = new javax.swing.JPanel();
        mYesRadioButton = new javax.swing.JRadioButton();
        mNoRadioButton = new javax.swing.JRadioButton();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setModal(true);
        setResizable(false);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.EtchedBorder());
        mRadioButtonPanel.setLayout(new java.awt.GridBagLayout());

        mYesRadioButton.setText("Yes, I do.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mRadioButtonPanel.add(mYesRadioButton, gridBagConstraints);

        mNoRadioButton.setText("No, I don't.");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mRadioButtonPanel.add(mNoRadioButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mPanel.add(mRadioButtonPanel, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mPreviousButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mNextButton;
    private javax.swing.JRadioButton mNoRadioButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JPanel mRadioButtonPanel;
    private javax.swing.JRadioButton mYesRadioButton;
    // ϐ錾̏I//GEN-END:variables



	public static final String USE_PROPERTY_FILE = "Yes, I do.";
	public static final String NOT_USE_PROPERTY_FILE = "No, I don't.";



	/**
	 * 
	 */
	private boolean initProperty()
	{
		this.setTitle(TITLE);

		// create a button group
		ButtonGroup bGroup = new ButtonGroup();
		bGroup.add(this.mYesRadioButton);
		bGroup.add(this.mNoRadioButton);

		// add action listener
		this.mYesRadioButton.addActionListener(this);
		this.mNoRadioButton.addActionListener(this);

this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;

	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);
		Object source = e.getSource();
		if( source instanceof JRadioButton )
		{
			JRadioButton btn = (JRadioButton)source;
			String text = btn.getText();
			this.notifyToListener( text );
		}

	}



	/**
	 * 
	 * @param b
	 */
	public void setUsePropertyFile( final boolean b )
	{
		if( b )
		{
			this.mYesRadioButton.setSelected(true);
		}
		else
		{
			this.mNoRadioButton.setSelected(true);
		}
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}

    
}
