/*
 * SGDataFileChooseWizardDialog.java
 *
 * Created on 2004/06/25, 13:49
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.table.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;



/**
 *
 * @author  kuromaru
 */
public class SGMultiDataFileChooserWizardDialog extends SGFileChooserWizardDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Choose data files.";


	/**
	 * 
	 */
	public SGMultiDataFileChooserWizardDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /** Creates new form SGDataFileChooseWizardDialog */
    public SGMultiDataFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mScrollPane = new javax.swing.JScrollPane();
        mTable = new javax.swing.JTable();
        mFileChooserButton = new javax.swing.JButton();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.EtchedBorder());
        mScrollPane.setPreferredSize(new java.awt.Dimension(454, 200));
        mTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null}
            },
            new String [] {
                "File Name"
            }
        ));
        mScrollPane.setViewportView(mTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        mPanel.add(mScrollPane, gridBagConstraints);

        mFileChooserButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mFileChooserButton.setText("Choose");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        mPanel.add(mFileChooserButton, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mPreviousButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    protected javax.swing.JButton mFileChooserButton;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JScrollPane mScrollPane;
    protected javax.swing.JTable mTable;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	private int mFileNumber;



	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGMultiDataFileChooserWizardDialog.TITLE );


		//
		this.mOKButton.setEnabled(false);


		// button
		this.mFileChooserButton.addActionListener(this);


		// file-chooser
		this.mFileChooser.setMultiSelectionEnabled(true);


this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();

		if( source.equals(this.mFileChooserButton) )
		{
			if( this.showFileChooser() == false )
			{
				throw new Error();
			}

			if( this.getSelectedFiles().length==this.mFileNumber )
			{
				this.mOKButton.setEnabled(true);
			}
		}

	}



	/**
	 * 
	 */
	public JTable getTable()
	{
		return this.mTable;
	}


	/**
	 * 
	 */
	public boolean setTable( final JTable table )
	{
		this.mTable = table;
		return true;
	}


	/**
	 * 
	 */
	public TableModel getTableModel()
	{
		return this.mTable.getModel();
	}



	/**
	 * 
	 */
	public boolean setTableModel( final TableModel model )
	{
		this.mTable.setModel( model );
		return true;
	}


	/**
	 * 
	 */
	private boolean showFileChooser()
	{
		ArrayList list = this.openFileChooser();
		if( list==null )
		{
			return false;
		}
		if( list.size()==0 )
		{
			return true;
		}

		File[] files = new File[list.size()];
		for( int ii=0; ii<files.length; ii++ )
		{
			files[ii] = (File)list.get(ii);
		}

		boolean flag = this.setSelectedFiles(files);

		return flag;
	}



	/**
	 * 
	 */
	public File[] getSelectedFiles()
	{

		ArrayList list = new ArrayList();
		for( int ii=0; ii<this.mTable.getRowCount(); ii++ )
		{
			Object obj = this.mTable.getValueAt(ii,1);
			if( obj!=null )
			{
				list.add(obj);
			}
		}


		File[] files = new File[list.size()];
		for( int ii=0; ii<files.length; ii++ )
		{
			String pathName = (String)list.get(ii);
			files[ii] = new File( pathName );
		}
		

		return files;
	}



	/**
	 * 
	 */
	public boolean setSelectedFiles( final File[] files )
	{

		// t@CXV
		for( int ii=0; ii<this.mTable.getRowCount(); ii++ )
		{
			this.mTable.setValueAt(null,ii,1);
		}

		for( int ii=0; ii<files.length; ii++ )
		{
			String path = files[ii].getPath();
			this.mTable.setValueAt(path,ii,1);
		}

		return true;
	}


	/**
	 * 
	 * @return
	 */
	public int getFileNumber()
	{
		return this.mFileNumber;
	}


	/**
	 * 
	 * @param num
	 */
	public void setFileNumber( final int num )
	{
		if( num<0 )
		{
			new IllegalArgumentException("num<0");
		}
		this.mFileNumber = num;
	}


	/**
	 * 
	 */
	public void setVisible( final boolean b )
	{
		if(b)
		{
			// if the property file does not have data information, do as follows
			final boolean flag = ( this.mFileNumber==0 );
			this.mFileChooserButton.setEnabled(!flag);
		}

		super.setVisible(b);
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


}
