#!/bin/sh
PACKAGE=samurai-graph
VERSION=0.2.0
APPNAME="Samurai Graph"

BASEDIR=`dirname $0`
cd "$BASEDIR"
DISTDIR=../../dist
TOPDIR=../..

UNAME=`uname`
# error check
if [ $UNAME != "Darwin" ]; then
  echo "Error: running host is not MacOS X";
  exit 65;
fi
if [ ! -d $DISTDIR ]; then
  echo "Error: $DISTDIR not found"
  exit 65;
fi
if [ ! -f $DISTDIR/samurai-graph.jar ]; then
  echo "Error: $DISTDIR/samurai-graph.jar not found"
  exit 65;
fi

# build Java bundler
echo -n "[Samurai Graph] build java bundler application...  "
APPLICATION="$APPNAME.app"
APP_CONTENTS="$APPLICATION/Contents"
APP_MACOS="$APP_CONTENTS/MacOS"
APP_RESOURCES="$APP_CONTENTS/Resources"
APP_JAVA="$APP_RESOURCES/Java"
APP_JAVALIB="$APP_RESOURCES/Java/lib"
APP_JAVALIBVG="$APP_JAVALIB/vectorgraphics"
APP_DOC="$APP_RESOURCES/Documents"
APP_DOCVG="$APP_DOC/vectorgraphics"
BUNDLER="resources/bundler"
rm -rf "$APPLICATION"
mkdir "$APPLICATION"
mkdir "$APP_CONTENTS"
mkdir "$APP_MACOS"
mkdir "$APP_RESOURCES"
mkdir "$APP_JAVA"
mkdir "$APP_JAVALIB"
mkdir "$APP_JAVALIBVG"
mkdir "$APP_DOC"
mkdir "$APP_DOCVG"
cp "$BUNDLER/Info.plist"         "$APP_CONTENTS"
cp "$BUNDLER/PkgInfo"            "$APP_CONTENTS"
cp "$BUNDLER/version.plist"      "$APP_CONTENTS"
cp "$BUNDLER/Samurai Graph"      "$APP_MACOS"
cp "$BUNDLER/samurai-graph.icns" "$APP_RESOURCES"
cp "$DISTDIR/samurai-graph.jar"  "$APP_JAVA"
cp "$DISTDIR/LICENSE.txt"        "$APP_DOC"
cp "$DISTDIR/COPYING.txt"        "$APP_DOC"
cp "$DISTDIR/lib/vectorgraphics/freehep-base.jar"            "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphics2d.jar"      "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio.jar"      "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-cgm.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-emf.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-gif.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-java.jar" "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-pdf.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ppm.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ps.jar"   "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-svg.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-swf.jar"  "$APP_JAVALIBVG"
cp "$DISTDIR/doc/vectorgraphics/LGPL.txt"                    "$APP_DOCVG"
cp "$DISTDIR/doc/vectorgraphics/LICENSE.txt"                 "$APP_DOCVG"
cp "$DISTDIR/doc/vectorgraphics/ReleaseNotes-1.2.2.html"     "$APP_DOCVG"
cp "$DISTDIR/doc/vectorgraphics/SAMURAIGRAPH-ChangeLog.txt"  "$APP_DOCVG"
echo 'done'

# build disk image file
echo -n "[Samurai Graph] build disk image file...  "
IMGFILE="$PACKAGE-mac-$VERSION.dmg"
IMGDIST="diskimage"
rm -f "$IMGFILE"
rm -f "$IMGFILE.gz"
rm -rf "$IMGDIST"
mkdir "$IMGDIST"
# put the resource forks back together
#/System/Library/CoreServices/FixupResourceForks -nodelete diskimage
cp -R  "$APPLICATION" "$IMGDIST"
cp     "$DISTDIR/COPYING.txt" "$IMGDIST"
cp     "$DISTDIR/LICENSE.txt" "$IMGDIST"
cp -R  "$TOPDIR/examples/data" "$IMGDIST/Example Data"
rm -rf "$IMGDIST/Example Data/CVS"
rm -f  "$IMGDIST/Example Data/.DS_Store"
cp     "resources/diskimage/_DS_Store" "$IMGDIST/.DS_Store"
cp     "resources/diskimage/_DS_Store2" "$IMGDIST/Example Data/.DS_Store"
hdiutil create -srcfolder "$IMGDIST" -volname "$APPNAME" "$IMGFILE" >/dev/null
gzip "$IMGFILE"
echo 'done'
