/* Generated By:JavaCC: Do not edit this line. CPPParser3rd.java */
package org.freehep.jaco.rtti.cpp;

import java.io.*;
import java.util.*;

import org.freehep.jaco.*;
import org.freehep.jaco.rtti.*;
import org.freehep.jaco.generator.*;

public final class CPPParser3rd implements CPPParser3rdConstants {

    // added to build RTTI
    private String visibility;

    private static String vers = "Stroustrup Special/3rd Edition";
    private static String id = "C++ Parser";

    // per file
    private static Vector comments;
    private static Vector classComments;
    private static Vector methodComments;

    public static void storeComment(Token token) {
        comments = new Vector();

        // if no special tokens
        if (token.specialToken == null) {
            if (token.image != null) comments.addElement(token.image);
            return;
        }

        // walk back to the start, just after the last regular token
        Token t = token.specialToken;
        while (t.specialToken != null) {
            t = t.specialToken;
        }

        // walk forwards and fill vector of comments
        while (t != null) {
            comments.addElement(t.image);
            t = t.next;
        }
    }

    private static void msg(String s) {
        System.out.println(id + " Version " + vers +": " + s);
    }

    public static void main(String args[]) {

        if (args.length < 1) {
            msg("Usage: java " + id + " inputfiles");
            return;
        }

        for (int i=0; i<args.length; i++) {

            try {
                msg("Reading from file " + args[i] + " . . .");

                Parser parser = new CPlusPlusParser(args[i]);
                parser.parse();
            } catch (FileNotFoundException e) {
                msg("File " + args[i] + " not found.");
            } catch (org.freehep.jaco.rtti.ParseException e) {
                msg(e.getMessage());
            }
        }

        addGlobalClasses();
    }

    // keeps global methods in a Vector, hashed by dotted namespace name in a Hashtable
    // keeps being available across new Parsers
    private static Hashtable staticMethods = new Hashtable();
    private static final String defaultNamespace = "";      // should be empty

    /**
     * adds a global method in the default namespace
     */
    static void addGlobalMethod(IMethod method) {
        addGlobalMethod(method, defaultNamespace);
    }

    /**
     * adds a global method in a namespace
     */
    static void addGlobalMethod(IMethod method, String name) {
        Vector m;
        if ((m = (Vector)staticMethods.get(name)) == null) {
            m = new Vector();
            staticMethods.put(name, m);
        }

        // FIXME: what if it is already defined!
        m.addElement(method);
    }

    /**
     * adds all the Global classes to the RTTI
     */
    static void addGlobalClasses() {
        for (Enumeration e=staticMethods.keys(); e.hasMoreElements(); ) {
            String ns = (String)e.nextElement();

            Vector methods = (Vector)staticMethods.get(ns);

            // create global class
            Jaco.getRTTI().createClass("Globals", true,
                                       ns, null,
                                       null, null,
                                       null, null, null, methods, null);
        }
    }

    // keeps the namespace names
    private Stack namespace = new Stack();

    /**
     * return the current namespace in dotted format.
     */
    String getCurrentNamespace() {
        StringBuffer s = new StringBuffer(defaultNamespace);

        for (Enumeration e=namespace.elements(); e.hasMoreElements(); ) {
            if (s.length() != 0) s.append(".");
            s.append((String)e.nextElement());
        }

        return s.toString();
    }

    /**
     * special method to create an aliased, class or primitive type.
     * It keeps a table of currently defined typeDefs.
     * Declarator may be null;
     * The IType returned may possibly refer to another IType.
     */
    private static Hashtable currentTypeDefs = new Hashtable();     // of Type

    static void addTypeDef(Type type, Declarator declarator) {
//        System.out.println("addTypeDef: "+type+", "+declarator);
        type.pointer = (declarator == null) ? 0 : declarator.pointer;
        currentTypeDefs.put(declarator.name, type);
    }

    static IType getType(Type type, Declarator declarator) {
//        System.out.println("getType: "+type+", "+declarator);

        // construct stack of types
        Stack types = new Stack();
        type.pointer = (declarator == null) ? 0 : declarator.pointer;
        types.push(type);

        Type typedef = (Type)currentTypeDefs.get(type.name);
        while (typedef != null) {
            types.push(typedef);
            typedef = (Type)currentTypeDefs.get(typedef.name);
        }

        // create chain of ITypes
        Type t = (Type)types.pop();
        IType iType = Jaco.getRTTI().createType(t.name, false, t.isPrimitive, t.isReference, t.pointer, t.dimension, null);
        while (!types.empty()) {
            t = (Type)types.pop();
            iType = Jaco.getRTTI().createType(t.name, iType, t.isReference, t.pointer, t.dimension);
        }
        return iType;
    }

  /**
   * A symbol table manager object. Currently only types are recorded for
   * doing semantic predicates for parsing.
   */
  SymtabManager sym = new SymtabManager();

/* Some include files contain concatenated literals (without a concatenation sign) */
  final public void literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OCTAL:
      jj_consume_token(OCTAL);
      break;
    case DECIMAL:
      jj_consume_token(DECIMAL);
      break;
    case HEXADECIMAL:
      jj_consume_token(HEXADECIMAL);
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
      break;
    case FLOATONE:
      jj_consume_token(FLOATONE);
      break;
    case FLOATTWO:
      jj_consume_token(FLOATTWO);
      break;
    case STRING_LITERAL:
      label_1:
      while (true) {
        jj_consume_token(STRING_LITERAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
      }
      break;
    case TRUETOK:
      jj_consume_token(TRUETOK);
      break;
    case FALSETOK:
      jj_consume_token(FALSETOK);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String identifier() throws ParseException {
    Token t;
    t = jj_consume_token(IDENTIFIER);
                      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

/******************/
/* Programs (A.4) */
/******************/
  final public void translation_unit() throws ParseException {
  visibility = "global";
                          sym.openScope(null, false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case SEMICOLON:
    case AMPERSAND:
    case STAR:
    case TILDE:
    case ASM:
    case AUTO:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case EXPLICIT:
    case EXPORT:
    case EXTERN:
    case FLOAT:
    case FRIEND:
    case INLINE:
    case INT:
    case LONG:
    case MUTABLE:
    case NAMESPACE:
    case OPERATOR:
    case REGISTER:
    case SHORT:
    case SIGNED:
    case STATIC:
    case STRUCT:
    case TEMPLATE:
    case TYPEDEF:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case USING:
    case VIRTUAL:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      declaration_seq();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
                          sym.closeScope();
    jj_consume_token(0);
  }

/*********************/
/* Expressions (A.5) */
/*********************/
  final public void primary_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSETOK:
    case TRUETOK:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      literal();
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    default:
      jj_la1[3] = jj_gen;
      if (jj_2_1(2147483647)) {
        jj_consume_token(SCOPE);
        operator_function_id();
      } else if (jj_2_2(3)) {
        jj_consume_token(SCOPE);
        qualified_id();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          identifier();
          break;
        case LPARENTHESIS:
          jj_consume_token(LPARENTHESIS);
          expression();
          jj_consume_token(RPARENTHESIS);
          break;
        case TILDE:
        case OPERATOR:
        case IDENTIFIER:
          id_expression();
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public String id_expression() throws ParseException {
    String name = null;
    if (jj_2_3(2147483647)) {
      name = qualified_id();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        name = unqualified_id();
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                  {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// FIXME: conversion function id not implemented
// changed order, op, co, te, ti, id -> te, op, co, ti, id
  final public String unqualified_id() throws ParseException {
    String name = null;
    if (jj_2_4(2147483647)) {
      name = template_id();
    } else if (jj_2_5(2147483647)) {
      name = operator_function_id();
    } else if (jj_2_6(2147483647)) {
      conversion_function_id();
                      name = "conversion_function_id n.i.";
    } else if (jj_2_7(2147483647)) {
      jj_consume_token(TILDE);
      name = class_name();
                      name = "~" + name;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        name = identifier();
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// FIXME: NNS ignored
// FIXME: TEMPLATE ignored
  final public String qualified_id() throws ParseException {
    String name = null;
    nested_name_specifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPLATE:
      jj_consume_token(TEMPLATE);
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    name = unqualified_id();
                  {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

/* (MOD 6) Too open: nns after template is now optional */
  final public String nested_name_specifier() throws ParseException {
    StringBuffer name = new StringBuffer();
    String segment;
    segment = class_or_namespace_name();
    jj_consume_token(SCOPE);
                      name.append(segment);
                      name.append("::");
    if (jj_2_8(2)) {
      jj_consume_token(TEMPLATE);
                      name.append("<TEMPLATE>");
    } else {
      ;
    }
    label_2:
    while (true) {
      if (jj_2_9(2147483647)) {
        ;
      } else {
        break label_2;
      }
      segment = class_or_namespace_name();
      jj_consume_token(SCOPE);
                      name.append(segment);
                      name.append("::");
      if (jj_2_10(2)) {
        jj_consume_token(TEMPLATE);
                      name.append("<TEMPLATE>");
      } else {
        ;
      }
    }
                      {if (true) return name.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String class_or_namespace_name() throws ParseException {
    String name;
    if (jj_2_11(2147483647)) {
      name = class_name();
                      {if (true) return name;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        name = namespace_name();
                      {if (true) return name;}
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void postfix_expression() throws ParseException {
    if (jj_2_12(2147483647)) {
      simple_type_specifier();
      jj_consume_token(LPARENTHESIS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case PLUS:
      case MINUS:
      case STAR:
      case PLUSPLUS:
      case MINUSMINUS:
      case TILDE:
      case LOGICALNOT:
      case BOOL:
      case CHAR:
      case CONST_CAST:
      case DELETE:
      case DOUBLE:
      case DYNAMIC_CAST:
      case FALSETOK:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case OPERATOR:
      case REINTERPRET_CAST:
      case SHORT:
      case SIGNED:
      case SIZEOF:
      case STATIC_CAST:
      case THIS:
      case THROW:
      case TRUETOK:
      case TYPEID:
      case TYPENAME:
      case UNSIGNED:
      case VOID:
      case WCHAR_T:
      case OCTAL:
      case DECIMAL:
      case HEXADECIMAL:
      case FLOATONE:
      case FLOATTWO:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
        expression_list();
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      jj_consume_token(RPARENTHESIS);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case TILDE:
      case FALSETOK:
      case OPERATOR:
      case THIS:
      case TRUETOK:
      case OCTAL:
      case DECIMAL:
      case HEXADECIMAL:
      case FLOATONE:
      case FLOATTWO:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
        primary_expression();
        break;
      default:
        jj_la1[15] = jj_gen;
        if (jj_2_13(3)) {
          jj_consume_token(TYPENAME);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
            jj_consume_token(SCOPE);
            break;
          default:
            jj_la1[10] = jj_gen;
            ;
          }
          nested_name_specifier();
          identifier();
          jj_consume_token(LPARENTHESIS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPARENTHESIS:
          case SCOPE:
          case AMPERSAND:
          case PLUS:
          case MINUS:
          case STAR:
          case PLUSPLUS:
          case MINUSMINUS:
          case TILDE:
          case LOGICALNOT:
          case BOOL:
          case CHAR:
          case CONST_CAST:
          case DELETE:
          case DOUBLE:
          case DYNAMIC_CAST:
          case FALSETOK:
          case FLOAT:
          case INT:
          case LONG:
          case NEW:
          case OPERATOR:
          case REINTERPRET_CAST:
          case SHORT:
          case SIGNED:
          case SIZEOF:
          case STATIC_CAST:
          case THIS:
          case THROW:
          case TRUETOK:
          case TYPEID:
          case TYPENAME:
          case UNSIGNED:
          case VOID:
          case WCHAR_T:
          case OCTAL:
          case DECIMAL:
          case HEXADECIMAL:
          case FLOATONE:
          case FLOATTWO:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
          case IDENTIFIER:
            expression_list();
            break;
          default:
            jj_la1[11] = jj_gen;
            ;
          }
          jj_consume_token(RPARENTHESIS);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TYPENAME:
            jj_consume_token(TYPENAME);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SCOPE:
              jj_consume_token(SCOPE);
              break;
            default:
              jj_la1[12] = jj_gen;
              ;
            }
            nested_name_specifier();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TEMPLATE:
              jj_consume_token(TEMPLATE);
              break;
            default:
              jj_la1[13] = jj_gen;
              ;
            }
            template_id();
            jj_consume_token(LPARENTHESIS);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPARENTHESIS:
            case SCOPE:
            case AMPERSAND:
            case PLUS:
            case MINUS:
            case STAR:
            case PLUSPLUS:
            case MINUSMINUS:
            case TILDE:
            case LOGICALNOT:
            case BOOL:
            case CHAR:
            case CONST_CAST:
            case DELETE:
            case DOUBLE:
            case DYNAMIC_CAST:
            case FALSETOK:
            case FLOAT:
            case INT:
            case LONG:
            case NEW:
            case OPERATOR:
            case REINTERPRET_CAST:
            case SHORT:
            case SIGNED:
            case SIZEOF:
            case STATIC_CAST:
            case THIS:
            case THROW:
            case TRUETOK:
            case TYPEID:
            case TYPENAME:
            case UNSIGNED:
            case VOID:
            case WCHAR_T:
            case OCTAL:
            case DECIMAL:
            case HEXADECIMAL:
            case FLOATONE:
            case FLOATTWO:
            case CHARACTER_LITERAL:
            case STRING_LITERAL:
            case IDENTIFIER:
              expression_list();
              break;
            default:
              jj_la1[14] = jj_gen;
              ;
            }
            jj_consume_token(RPARENTHESIS);
            break;
          case DYNAMIC_CAST:
            jj_consume_token(DYNAMIC_CAST);
            jj_consume_token(LESSTHAN);
            type_id();
            jj_consume_token(GREATERTHAN);
            jj_consume_token(LPARENTHESIS);
            expression();
            jj_consume_token(RPARENTHESIS);
            break;
          case STATIC_CAST:
            jj_consume_token(STATIC_CAST);
            jj_consume_token(LESSTHAN);
            type_id();
            jj_consume_token(GREATERTHAN);
            jj_consume_token(LPARENTHESIS);
            expression();
            jj_consume_token(RPARENTHESIS);
            break;
          case REINTERPRET_CAST:
            jj_consume_token(REINTERPRET_CAST);
            jj_consume_token(LESSTHAN);
            type_id();
            jj_consume_token(GREATERTHAN);
            jj_consume_token(LPARENTHESIS);
            expression();
            jj_consume_token(RPARENTHESIS);
            break;
          case CONST_CAST:
            jj_consume_token(CONST_CAST);
            jj_consume_token(LESSTHAN);
            type_id();
            jj_consume_token(GREATERTHAN);
            jj_consume_token(LPARENTHESIS);
            expression();
            jj_consume_token(RPARENTHESIS);
            break;
          default:
            jj_la1[16] = jj_gen;
            if (jj_2_14(3)) {
              jj_consume_token(TYPEID);
              jj_consume_token(LPARENTHESIS);
              expression();
              jj_consume_token(RPARENTHESIS);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case TYPEID:
                jj_consume_token(TYPEID);
                jj_consume_token(LPARENTHESIS);
                type_id();
                jj_consume_token(RPARENTHESIS);
                break;
              default:
                jj_la1[17] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUAREBRACKET:
      case LPARENTHESIS:
      case PLUSPLUS:
      case MINUSMINUS:
      case DOT:
      case POINTERTO:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUAREBRACKET:
        jj_consume_token(LSQUAREBRACKET);
        expression();
        jj_consume_token(RSQUAREBRACKET);
        break;
      case LPARENTHESIS:
        jj_consume_token(LPARENTHESIS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPARENTHESIS:
        case SCOPE:
        case AMPERSAND:
        case PLUS:
        case MINUS:
        case STAR:
        case PLUSPLUS:
        case MINUSMINUS:
        case TILDE:
        case LOGICALNOT:
        case BOOL:
        case CHAR:
        case CONST_CAST:
        case DELETE:
        case DOUBLE:
        case DYNAMIC_CAST:
        case FALSETOK:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case OPERATOR:
        case REINTERPRET_CAST:
        case SHORT:
        case SIGNED:
        case SIZEOF:
        case STATIC_CAST:
        case THIS:
        case THROW:
        case TRUETOK:
        case TYPEID:
        case TYPENAME:
        case UNSIGNED:
        case VOID:
        case WCHAR_T:
        case OCTAL:
        case DECIMAL:
        case HEXADECIMAL:
        case FLOATONE:
        case FLOATTWO:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
          expression_list();
          break;
        default:
          jj_la1[19] = jj_gen;
          ;
        }
        jj_consume_token(RPARENTHESIS);
        break;
      default:
        jj_la1[24] = jj_gen;
        if (jj_2_15(3)) {
          jj_consume_token(DOT);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TEMPLATE:
            jj_consume_token(TEMPLATE);
            break;
          default:
            jj_la1[20] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
            jj_consume_token(SCOPE);
            break;
          default:
            jj_la1[21] = jj_gen;
            ;
          }
          id_expression();
        } else if (jj_2_16(3)) {
          jj_consume_token(POINTERTO);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TEMPLATE:
            jj_consume_token(TEMPLATE);
            break;
          default:
            jj_la1[22] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
            jj_consume_token(SCOPE);
            break;
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          id_expression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DOT:
            jj_consume_token(DOT);
            pseudo_destructor_name();
            break;
          case POINTERTO:
            jj_consume_token(POINTERTO);
            pseudo_destructor_name();
            break;
          case PLUSPLUS:
            jj_consume_token(PLUSPLUS);
            break;
          case MINUSMINUS:
            jj_consume_token(MINUSMINUS);
            break;
          default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

  final public void expression_list() throws ParseException {
    assignment_expression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      assignment_expression();
    }
  }

  final public void pseudo_destructor_name() throws ParseException {
    if (jj_2_18(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      if (jj_2_17(2)) {
        nested_name_specifier();
      } else {
        ;
      }
      type_name();
      jj_consume_token(SCOPE);
      jj_consume_token(TILDE);
      type_name();
    } else if (jj_2_19(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      nested_name_specifier();
      jj_consume_token(TEMPLATE);
      template_id();
      jj_consume_token(SCOPE);
      jj_consume_token(TILDE);
      type_name();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[29] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPERATOR:
        case IDENTIFIER:
          nested_name_specifier();
          break;
        default:
          jj_la1[30] = jj_gen;
          ;
        }
        jj_consume_token(TILDE);
        type_name();
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void unary_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUSPLUS:
      jj_consume_token(PLUSPLUS);
      cast_expression();
      break;
    case MINUSMINUS:
      jj_consume_token(MINUSMINUS);
      cast_expression();
      break;
    default:
      jj_la1[32] = jj_gen;
      if (jj_2_20(2147483647)) {
        postfix_expression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AMPERSAND:
        case PLUS:
        case MINUS:
        case STAR:
        case TILDE:
        case LOGICALNOT:
          unary_operator();
          cast_expression();
          break;
        default:
          jj_la1[33] = jj_gen;
          if (jj_2_21(2147483647)) {
            jj_consume_token(SIZEOF);
            jj_consume_token(LPARENTHESIS);
            type_id();
            jj_consume_token(RPARENTHESIS);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SIZEOF:
              jj_consume_token(SIZEOF);
              unary_expression();
              break;
            default:
              jj_la1[34] = jj_gen;
              if (jj_2_22(2147483647)) {
                new_expression();
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case SCOPE:
                case DELETE:
                  delete_expression();
                  break;
                default:
                  jj_la1[35] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
  }

  final public void unary_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
      break;
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case LOGICALNOT:
      jj_consume_token(LOGICALNOT);
      break;
    case TILDE:
      jj_consume_token(TILDE);
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void new_expression() throws ParseException {
    if (jj_2_25(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      jj_consume_token(NEW);
      if (jj_2_23(2)) {
        new_placement();
      } else {
        ;
      }
      new_type_id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
        new_initializer();
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case NEW:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[39] = jj_gen;
          ;
        }
        jj_consume_token(NEW);
        if (jj_2_24(2)) {
          new_placement();
        } else {
          ;
        }
        jj_consume_token(LPARENTHESIS);
        type_id();
        jj_consume_token(RPARENTHESIS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPARENTHESIS:
          new_initializer();
          break;
        default:
          jj_la1[40] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void new_placement() throws ParseException {
    jj_consume_token(LPARENTHESIS);
    expression_list();
    jj_consume_token(RPARENTHESIS);
  }

  final public void new_type_id() throws ParseException {
    type_specifier_seq();
    if (jj_2_26(2)) {
      new_declarator();
    } else {
      ;
    }
  }

  final public void new_declarator() throws ParseException {
  Declaration dummy = new Declaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
    case AMPERSAND:
    case STAR:
    case OPERATOR:
    case IDENTIFIER:
      ptr_operator(dummy);
      cv_qualifier_seq();
      if (jj_2_27(2)) {
        new_declarator();
      } else {
        ;
      }
      break;
    case LSQUAREBRACKET:
      direct_new_declarator();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void direct_new_declarator() throws ParseException {
    jj_consume_token(LSQUAREBRACKET);
    expression();
    jj_consume_token(RSQUAREBRACKET);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUAREBRACKET:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_5;
      }
      jj_consume_token(LSQUAREBRACKET);
      constant_expression();
      jj_consume_token(RSQUAREBRACKET);
    }
  }

  final public void new_initializer() throws ParseException {
    jj_consume_token(LPARENTHESIS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case AMPERSAND:
    case PLUS:
    case MINUS:
    case STAR:
    case PLUSPLUS:
    case MINUSMINUS:
    case TILDE:
    case LOGICALNOT:
    case BOOL:
    case CHAR:
    case CONST_CAST:
    case DELETE:
    case DOUBLE:
    case DYNAMIC_CAST:
    case FALSETOK:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case OPERATOR:
    case REINTERPRET_CAST:
    case SHORT:
    case SIGNED:
    case SIZEOF:
    case STATIC_CAST:
    case THIS:
    case THROW:
    case TRUETOK:
    case TYPEID:
    case TYPENAME:
    case UNSIGNED:
    case VOID:
    case WCHAR_T:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      expression_list();
      break;
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public void delete_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    jj_consume_token(DELETE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
      jj_consume_token(LSQUAREBRACKET);
      jj_consume_token(RSQUAREBRACKET);
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    cast_expression();
  }

  final public void cast_expression() throws ParseException {
    if (jj_2_28(2147483647)) {
      jj_consume_token(LPARENTHESIS);
      type_id();
      jj_consume_token(RPARENTHESIS);
      cast_expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case PLUS:
      case MINUS:
      case STAR:
      case PLUSPLUS:
      case MINUSMINUS:
      case TILDE:
      case LOGICALNOT:
      case BOOL:
      case CHAR:
      case CONST_CAST:
      case DELETE:
      case DOUBLE:
      case DYNAMIC_CAST:
      case FALSETOK:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case OPERATOR:
      case REINTERPRET_CAST:
      case SHORT:
      case SIGNED:
      case SIZEOF:
      case STATIC_CAST:
      case THIS:
      case TRUETOK:
      case TYPEID:
      case TYPENAME:
      case UNSIGNED:
      case VOID:
      case WCHAR_T:
      case OCTAL:
      case DECIMAL:
      case HEXADECIMAL:
      case FLOATONE:
      case FLOATTWO:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
        unary_expression();
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void pm_expression() throws ParseException {
    cast_expression();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOTSTAR:
      case ARROWSTAR:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOTSTAR:
        jj_consume_token(DOTSTAR);
        break;
      case ARROWSTAR:
        jj_consume_token(ARROWSTAR);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      cast_expression();
    }
  }

  final public void multiplicative_expression() throws ParseException {
    pm_expression();
    label_7:
    while (true) {
      if (jj_2_29(2)) {
        ;
      } else {
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case DIVIDE:
        jj_consume_token(DIVIDE);
        break;
      case MOD:
        jj_consume_token(MOD);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      pm_expression();
    }
  }

  final public void additive_expression() throws ParseException {
    multiplicative_expression();
    label_8:
    while (true) {
      if (jj_2_30(2)) {
        ;
      } else {
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      multiplicative_expression();
    }
  }

  final public void shift_expression() throws ParseException {
    additive_expression();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHIFTLEFT:
      case SHIFTRIGHT:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHIFTLEFT:
        jj_consume_token(SHIFTLEFT);
        break;
      case SHIFTRIGHT:
        jj_consume_token(SHIFTRIGHT);
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      additive_expression();
    }
  }

  final public void relational_expression() throws ParseException {
    shift_expression();
    label_10:
    while (true) {
      if (jj_2_31(2)) {
        ;
      } else {
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESSTHAN:
        jj_consume_token(LESSTHAN);
        shift_expression();
        break;
      case GREATERTHAN:
        jj_consume_token(GREATERTHAN);
        shift_expression();
        break;
      case LESSTHANOREQUALTO:
        jj_consume_token(LESSTHANOREQUALTO);
        shift_expression();
        break;
      case GREATERTHANOREQUALTO:
        jj_consume_token(GREATERTHANOREQUALTO);
        shift_expression();
        break;
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void equality_expression() throws ParseException {
    relational_expression();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case NOTEQUAL:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOTEQUAL:
        jj_consume_token(NOTEQUAL);
        break;
      case EQUAL:
        jj_consume_token(EQUAL);
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      relational_expression();
    }
  }

  final public void and_expression() throws ParseException {
    equality_expression();
    label_12:
    while (true) {
      if (jj_2_32(2)) {
        ;
      } else {
        break label_12;
      }
      jj_consume_token(AMPERSAND);
      equality_expression();
    }
  }

  final public void exclusive_or_expression() throws ParseException {
    and_expression();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BITWISEXOR:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_13;
      }
      jj_consume_token(BITWISEXOR);
      and_expression();
    }
  }

  final public void inclusive_or_expression() throws ParseException {
    exclusive_or_expression();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BITWISEOR:
        ;
        break;
      default:
        jj_la1[58] = jj_gen;
        break label_14;
      }
      jj_consume_token(BITWISEOR);
      exclusive_or_expression();
    }
  }

  final public void logical_and_expression() throws ParseException {
    inclusive_or_expression();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICALAND:
        ;
        break;
      default:
        jj_la1[59] = jj_gen;
        break label_15;
      }
      jj_consume_token(LOGICALAND);
      inclusive_or_expression();
    }
  }

  final public void logical_or_expression() throws ParseException {
    logical_and_expression();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOGICALOR:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_16;
      }
      jj_consume_token(LOGICALOR);
      logical_and_expression();
    }
  }

  final public void conditional_expression() throws ParseException {
    logical_or_expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUESTIONMARK:
      jj_consume_token(QUESTIONMARK);
      expression();
      jj_consume_token(COLON);
      assignment_expression();
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
  }

  final public void assignment_expression() throws ParseException {
    if (jj_2_33(2147483647)) {
      logical_or_expression();
      assignment_operator();
      assignment_expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case PLUS:
      case MINUS:
      case STAR:
      case PLUSPLUS:
      case MINUSMINUS:
      case TILDE:
      case LOGICALNOT:
      case BOOL:
      case CHAR:
      case CONST_CAST:
      case DELETE:
      case DOUBLE:
      case DYNAMIC_CAST:
      case FALSETOK:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case OPERATOR:
      case REINTERPRET_CAST:
      case SHORT:
      case SIGNED:
      case SIZEOF:
      case STATIC_CAST:
      case THIS:
      case TRUETOK:
      case TYPEID:
      case TYPENAME:
      case UNSIGNED:
      case VOID:
      case WCHAR_T:
      case OCTAL:
      case DECIMAL:
      case HEXADECIMAL:
      case FLOATONE:
      case FLOATTWO:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
        conditional_expression();
        break;
      case THROW:
        throw_expression();
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void assignment_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      break;
    case TIMESEQUAL:
      jj_consume_token(TIMESEQUAL);
      break;
    case DIVIDEEQUAL:
      jj_consume_token(DIVIDEEQUAL);
      break;
    case MODEQUAL:
      jj_consume_token(MODEQUAL);
      break;
    case PLUSEQUAL:
      jj_consume_token(PLUSEQUAL);
      break;
    case MINUSEQUAL:
      jj_consume_token(MINUSEQUAL);
      break;
    case SHIFTLEFTEQUAL:
      jj_consume_token(SHIFTLEFTEQUAL);
      break;
    case SHIFTRIGHTEQUAL:
      jj_consume_token(SHIFTRIGHTEQUAL);
      break;
    case BITWISEANDEQUAL:
      jj_consume_token(BITWISEANDEQUAL);
      break;
    case BITWISEXOREQUAL:
      jj_consume_token(BITWISEXOREQUAL);
      break;
    case BITWISEOREQUAL:
      jj_consume_token(BITWISEOREQUAL);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void expression() throws ParseException {
    assignment_expression();
    label_17:
    while (true) {
      if (jj_2_34(2)) {
        ;
      } else {
        break label_17;
      }
      jj_consume_token(COMMA);
      assignment_expression();
    }
  }

  final public void constant_expression() throws ParseException {
    conditional_expression();
  }

/********************/
/* Statements (A.6) */
/********************/
/*
void statement() :
{}
{
    LOOKAHEAD( identifier() <COLON> | <CASE> | <_DEFAULT> )
    labeled_statement()
   |
    compound_statement()
   |
    selection_statement()
   |
    iteration_statement()
   |
    jump_statement()
   |
    try_block()
   |
    LOOKAHEAD( declaration_statement() )
    declaration_statement()
   |
    expression_statement()
}

void labeled_statement() :
{}
{
    identifier() <COLON> statement()
   |
    <CASE> constant_expression() <COLON> statement()
   |
    <_DEFAULT> <COLON> statement()
}

void expression_statement() :
{}
{
    ( expression() )? <SEMICOLON>
}
*/

// (MOD 16) ignore compound statements
  final public void compound_statement() throws ParseException {
    jj_consume_token(LCURLYBRACE);
    skip_to_matching_brace();
    jj_consume_token(RCURLYBRACE);
  }

  void skip_to_matching_brace() throws ParseException {
//    System.err.println("Skip to matching brace");
    Token token;
    int nesting = 1;
    while(true) {
        token = getToken(1);
        if (token.kind == LCURLYBRACE) {
            nesting++;
        } else if (token.kind == RCURLYBRACE) {
            nesting--;
            if (nesting == 0) break;
        }
        token = getNextToken();
    }
  }

/*
void compound_statement() :
{}
{
   <LCURLYBRACE>

   { sym.openScope(null, false); }

   ( statement_seq() )?

   { sym.closeScope(); }

   <RCURLYBRACE>
}
*/

/*
void statement_seq() :
{}
{
   ( statement() )+
}

void selection_statement() :
{}
{
    <IF> <LPARENTHESIS> condition() <RPARENTHESIS> statement()
     (LOOKAHEAD(2) <ELSE> statement())?
   |
    <SWITCH> <LPARENTHESIS> condition() <RPARENTHESIS> statement()
}

void condition() :
{}
{
    LOOKAHEAD(3)
    expression()
   |
    type_specifier_seq() declarator() <ASSIGNEQUAL> assignment_expression()
}

void iteration_statement() :
{}
{
    <WHILE> <LPARENTHESIS> condition() <RPARENTHESIS> statement()
   |
    <DO> statement() <WHILE> <LPARENTHESIS> condition() <RPARENTHESIS> <SEMICOLON>
   |
    <FOR> <LPARENTHESIS> for_init_statement() (condition())? <SEMICOLON> (expression())? <RPARENTHESIS> statement()
}

void for_init_statement() :
{}
{
    LOOKAHEAD(simple_declaration())
    simple_declaration()
   |
    expression_statement()
}

void jump_statement() :
{}
{
    <BREAK> <SEMICOLON>
   |
    <CONTINUE> <SEMICOLON>
   |
    <RETURN> (expression())? <SEMICOLON>
   |
    <GOTO> identifier() <SEMICOLON>
}

void declaration_statement() :
{}
{
    block_declaration()
}
*/

/**********************/
/* Declarations (A.7) */
/**********************/
  final public void declaration_seq() throws ParseException {
    declaration();
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case SEMICOLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case ASM:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXPORT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case NAMESPACE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TEMPLATE:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case USING:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_18;
      }
      declaration();
    }
  }

/* (MOD 4) reshuffled the entries and made the Look Aheads very specific, to increase performance */
// (MOD 11) added optional semicolons to namespace_definition() and function_definition()
// FIXME handle global functions here
  final public void declaration() throws ParseException {
    Vector constructors = new Vector();
    Vector destructors = new Vector();
    Vector methods = new Vector();
    if (jj_2_37(2147483647)) {
      explicit_specialization();
    } else if (jj_2_38(2147483647)) {
      template_declaration();
    } else if (jj_2_39(2147483647)) {
      explicit_instantiation();
    } else if (jj_2_40(2147483647)) {
      linkage_specification();
    } else if (jj_2_41(2147483647)) {
      namespace_definition();
      if (jj_2_35(2)) {
        jj_consume_token(SEMICOLON);
      } else {
        ;
      }
    } else if (jj_2_42(2147483647)) {
      block_declaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        function_definition(null, constructors, destructors, methods, true);
        if (jj_2_36(2)) {
          jj_consume_token(SEMICOLON);
        } else {
          ;
        }
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void block_declaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case SEMICOLON:
    case AMPERSAND:
    case STAR:
    case TILDE:
    case AUTO:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case EXPLICIT:
    case EXTERN:
    case FLOAT:
    case FRIEND:
    case INLINE:
    case INT:
    case LONG:
    case MUTABLE:
    case OPERATOR:
    case REGISTER:
    case SHORT:
    case SIGNED:
    case STATIC:
    case STRUCT:
    case TYPEDEF:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case VIRTUAL:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      simple_declaration();
      break;
    case ASM:
      asm_definition();
      break;
    case NAMESPACE:
      namespace_alias_definition();
      break;
    default:
      jj_la1[66] = jj_gen;
      if (jj_2_43(2)) {
        using_declaration();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case USING:
          using_directive();
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/* (MOD 1) added type specifier */
// FIXME: ignores namespace
  final public void simple_declaration() throws ParseException {
    Type type = new Type();
    Modifiers modifiers = new Modifiers();
    Declarator declarator = null;
    methodComments = comments;
    comments = null;
    if (jj_2_44(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      type = type_specifier();
      modifiers = decl_specifier_seq(modifiers);
      declarator = init_declarator_list();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_45(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      type = type_specifier();
      modifiers = decl_specifier_seq(modifiers);
      jj_consume_token(SEMICOLON);
    } else if (jj_2_46(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      type = type_specifier();
      declarator = init_declarator_list();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_47(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      type = type_specifier();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_48(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      declarator = init_declarator_list();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO:
      case CONST:
      case EXPLICIT:
      case EXTERN:
      case FRIEND:
      case INLINE:
      case MUTABLE:
      case REGISTER:
      case STATIC:
      case TYPEDEF:
      case VIRTUAL:
      case VOLATILE:
        modifiers = decl_specifier_seq(modifiers);
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[68] = jj_gen;
        if (jj_2_49(2147483647)) {
          type = type_specifier();
          jj_consume_token(SEMICOLON);
        } else if (jj_2_50(2147483647)) {
          type = type_specifier();
          declarator = init_declarator_list();
          jj_consume_token(SEMICOLON);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPARENTHESIS:
          case SCOPE:
          case AMPERSAND:
          case STAR:
          case TILDE:
          case OPERATOR:
          case IDENTIFIER:
            declarator = init_declarator_list();
            jj_consume_token(SEMICOLON);
            break;
          case SEMICOLON:
            jj_consume_token(SEMICOLON);
            break;
          default:
            jj_la1[69] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
                    if (modifiers.isTypedef) {
                        addTypeDef(type, declarator);
                    } else if ((declarator != null) && (declarator.isFunction)) {
                        IType iType = getType(type, declarator);
                        addGlobalMethod(Jaco.getRTTI().createMethod(declarator.name, methodComments, true, iType, false, declarator.parameters, null));
                    }
                    comments = null;
                    methodComments = null;
  }

/* (MOD 1) removed type specifier */
/* (MOD 3) added cv_qualifier */
  final public void decl_specifier(Modifiers modifiers) throws ParseException {
  boolean isStatic;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
    case EXTERN:
    case MUTABLE:
    case REGISTER:
    case STATIC:
      isStatic = storage_class_specifier();
              modifiers.isStatic = isStatic;
      break;
    case CONST:
    case VOLATILE:
      cv_qualifier();
      break;
    case EXPLICIT:
    case INLINE:
    case VIRTUAL:
      function_specifier();
      break;
    case FRIEND:
      jj_consume_token(FRIEND);
      break;
    case TYPEDEF:
      jj_consume_token(TYPEDEF);
              modifiers.isTypedef = true;
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Modifiers decl_specifier_seq(Modifiers modifiers) throws ParseException {
    decl_specifier(modifiers);
    label_19:
    while (true) {
      if (jj_2_51(2)) {
        ;
      } else {
        break label_19;
      }
      decl_specifier(modifiers);
    }
              {if (true) return modifiers;}
    throw new Error("Missing return statement in function");
  }

// FIXME: static is ignored
  final public boolean storage_class_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
      jj_consume_token(AUTO);
      break;
    case REGISTER:
      jj_consume_token(REGISTER);
      break;
    case STATIC:
      jj_consume_token(STATIC);
                  {if (true) return true;}
      break;
    case EXTERN:
      jj_consume_token(EXTERN);
      break;
    case MUTABLE:
      jj_consume_token(MUTABLE);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final public void function_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INLINE:
      jj_consume_token(INLINE);
      break;
    case VIRTUAL:
      jj_consume_token(VIRTUAL);
      break;
    case EXPLICIT:
      jj_consume_token(EXPLICIT);
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void typedef_name() throws ParseException {
    identifier();
  }

/* (MOD 3) removed cv_qualifier */
// FIXME returns null in some cases
  final public Type type_specifier() throws ParseException {
  Type type = null;
    if (jj_2_52(2147483647)) {
      class_specifier();
    } else if (jj_2_53(2147483647)) {
      enum_specifier();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASS:
      case ENUM:
      case STRUCT:
      case TYPENAME:
      case UNION:
        elaborated_type_specifier();
        break;
      case SCOPE:
      case BOOL:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case OPERATOR:
      case SHORT:
      case SIGNED:
      case UNSIGNED:
      case VOID:
      case WCHAR_T:
      case IDENTIFIER:
        type = simple_type_specifier();
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

// FIXME: return too little for some types
// FIXME: NNS ignored
// A little too open, concerning that the prefixes SHORT and LONG can only precede INT and DOUBLE// (MOD 2) added unsigned/signed prefix
// FIXME: it looks like only "unsigned typename identifier" should be allowed in the second case, for now
//        we fix it by specifying the other cases...
// FIXME: there is in fact an abiguity here: "unsigned typedefname" or "unsigned varname" show as the same,
//        but is in fact different. No way for us to make out the difference!
  final public Type simple_type_specifier() throws ParseException {
  Type type; String name;
    if (jj_2_59(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SIGNED:
      case UNSIGNED:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SIGNED:
          jj_consume_token(SIGNED);
          break;
        case UNSIGNED:
          jj_consume_token(UNSIGNED);
          break;
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
        jj_consume_token(CHAR);
        break;
      case WCHAR_T:
        jj_consume_token(WCHAR_T);
        break;
      case BOOL:
        jj_consume_token(BOOL);
        break;
      default:
        jj_la1[76] = jj_gen;
        if (jj_2_54(2)) {
          jj_consume_token(SHORT);
          jj_consume_token(INT);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SHORT:
            jj_consume_token(SHORT);
            break;
          case INT:
            jj_consume_token(INT);
            break;
          default:
            jj_la1[77] = jj_gen;
            if (jj_2_55(2)) {
              jj_consume_token(LONG);
              jj_consume_token(DOUBLE);
            } else if (jj_2_56(2)) {
              jj_consume_token(LONG);
              jj_consume_token(INT);
            } else if (jj_2_57(2)) {
              jj_consume_token(LONG);
              jj_consume_token(LONG);
              jj_consume_token(INT);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LONG:
                jj_consume_token(LONG);
                break;
              case FLOAT:
                jj_consume_token(FLOAT);
                break;
              case DOUBLE:
                jj_consume_token(DOUBLE);
                break;
              case VOID:
                jj_consume_token(VOID);
                break;
              default:
                jj_la1[78] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
                        type = new Type(getToken(0).image);
                        type.isPrimitive = true;
    } else if (jj_2_60(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SIGNED:
        jj_consume_token(SIGNED);
        break;
      case UNSIGNED:
        jj_consume_token(UNSIGNED);
        break;
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        type = new Type(getToken(0).image);
                        type.isPrimitive = true;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SIGNED:
      case UNSIGNED:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SIGNED:
          jj_consume_token(SIGNED);
          break;
        case UNSIGNED:
          jj_consume_token(UNSIGNED);
          break;
        default:
          jj_la1[80] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                        type = new Type(getToken(0).image);
                        type.isPrimitive = true;
        break;
      default:
        jj_la1[84] = jj_gen;
        if (jj_2_61(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
            jj_consume_token(SCOPE);
            break;
          default:
            jj_la1[81] = jj_gen;
            ;
          }
          if (jj_2_58(2147483647)) {
            nested_name_specifier();
          } else {
            ;
          }
          name = type_name();
                      type = new Type(name);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
          case OPERATOR:
          case IDENTIFIER:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SCOPE:
              jj_consume_token(SCOPE);
              break;
            default:
              jj_la1[82] = jj_gen;
              ;
            }
            nested_name_specifier();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TEMPLATE:
              jj_consume_token(TEMPLATE);
              break;
            default:
              jj_la1[83] = jj_gen;
              ;
            }
            template_id();
                      type = new Type("TemplateUnsupported");
            break;
          default:
            jj_la1[85] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
              {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

/* (MOD 10) taken out similar constructs (all identifiers) */
  final public String type_name() throws ParseException {
    String name;
    name = class_name();
                  {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// (MOD 13) enlarged spec to allow class_name() after class_key()
  final public void elaborated_type_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
    case STRUCT:
    case UNION:
      class_key();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      if (jj_2_62(2147483647)) {
        nested_name_specifier();
      } else {
        ;
      }
      class_name();
      break;
    case ENUM:
      jj_consume_token(ENUM);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[87] = jj_gen;
        ;
      }
      if (jj_2_63(2147483647)) {
        nested_name_specifier();
      } else {
        ;
      }
      identifier();
      break;
    default:
      jj_la1[91] = jj_gen;
      if (jj_2_64(3)) {
        jj_consume_token(TYPENAME);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[88] = jj_gen;
          ;
        }
        nested_name_specifier();
        identifier();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TYPENAME:
          jj_consume_token(TYPENAME);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
            jj_consume_token(SCOPE);
            break;
          default:
            jj_la1[89] = jj_gen;
            ;
          }
          nested_name_specifier();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TEMPLATE:
            jj_consume_token(TEMPLATE);
            break;
          default:
            jj_la1[90] = jj_gen;
            ;
          }
          template_id();
          break;
        default:
          jj_la1[92] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void enum_name() throws ParseException {
    identifier();
  }

// FIXME: what if t is not defined
  final public void enum_specifier() throws ParseException {
  String s = null;
    jj_consume_token(ENUM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      s = identifier();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    jj_consume_token(LCURLYBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      enumerator_list();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    jj_consume_token(RCURLYBRACE);
              if (s != null) sym.putTypeName(s);
  }

  final public void enumerator_list() throws ParseException {
    enumerator_definition();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[95] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
      enumerator_definition();
    }
  }

// (MOD 12) added optional semicolon
  final public void enumerator_definition() throws ParseException {
    enumerator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      constant_expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[96] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
  }

  final public void enumerator() throws ParseException {
    identifier();
  }

  final public String namespace_name() throws ParseException {
    String name;
    name = identifier();
                      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  final public void namespace_definition() throws ParseException {
    String name = defaultNamespace;
    Token t;
    if (jj_2_65(2)) {
      named_namespace_definition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NAMESPACE:
        unnamed_namespace_definition();
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void named_namespace_definition() throws ParseException {
    jj_consume_token(NAMESPACE);
    namespace_name();
    jj_consume_token(LCURLYBRACE);
    namespace_body();
    jj_consume_token(RCURLYBRACE);
  }

/*
    "namespace"
    (t = identifier()
                        { name = t.image; }
    )?
                        { sym.openScope(name, false);
                          namespace.push(name); }
    "{" declaration_list() "}"
                        { namespace.pop();
                          sym.closeScope(); }
}
*/
  final public void unnamed_namespace_definition() throws ParseException {
    jj_consume_token(NAMESPACE);
    jj_consume_token(LCURLYBRACE);
    namespace_body();
    jj_consume_token(RCURLYBRACE);
  }

  final public void namespace_body() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case SEMICOLON:
    case AMPERSAND:
    case STAR:
    case TILDE:
    case ASM:
    case AUTO:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case EXPLICIT:
    case EXPORT:
    case EXTERN:
    case FLOAT:
    case FRIEND:
    case INLINE:
    case INT:
    case LONG:
    case MUTABLE:
    case NAMESPACE:
    case OPERATOR:
    case REGISTER:
    case SHORT:
    case SIGNED:
    case STATIC:
    case STRUCT:
    case TEMPLATE:
    case TYPEDEF:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case USING:
    case VIRTUAL:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      declaration_seq();
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
  }

  final public void namespace_alias_definition() throws ParseException {
  Token t;
    t = jj_consume_token(NAMESPACE);
    identifier();
    jj_consume_token(ASSIGNEQUAL);
    qualified_namespace_specifier();
    jj_consume_token(SEMICOLON);
                          {if (true) throw new UnsupportedException("namespace alias definition NOT ALLOWED", t.beginLine);}
  }

  final public void qualified_namespace_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
      break;
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    if (jj_2_66(2)) {
      nested_name_specifier();
    } else {
      ;
    }
    namespace_name();
  }

/* FIXME
                        { sym.putUsingName(namespace); }
*/
  final public void using_declaration() throws ParseException {
 String namespace;
    if (jj_2_67(2147483647)) {
      jj_consume_token(USING);
      jj_consume_token(SCOPE);
      unqualified_id();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TYPENAME:
          jj_consume_token(TYPENAME);
          break;
        default:
          jj_la1[101] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[102] = jj_gen;
          ;
        }
        nested_name_specifier();
        unqualified_id();
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void using_directive() throws ParseException {
 String namespace; Token t;
    t = jj_consume_token(USING);
    jj_consume_token(NAMESPACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
      break;
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    if (jj_2_68(2)) {
      nested_name_specifier();
    } else {
      ;
    }
    namespace = namespace_name();
    jj_consume_token(SEMICOLON);
                          {if (true) throw new UnsupportedException("using directive NOT ALLOWED", t.beginLine);}
  }

  final public void asm_definition() throws ParseException {
    jj_consume_token(ASM);
    jj_consume_token(LPARENTHESIS);
    jj_consume_token(STRING_LITERAL);
    jj_consume_token(RPARENTHESIS);
    jj_consume_token(SEMICOLON);
  }

  final public void linkage_specification() throws ParseException {
    if (jj_2_69(3)) {
      jj_consume_token(EXTERN);
      jj_consume_token(STRING_LITERAL);
      jj_consume_token(LCURLYBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case SEMICOLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case ASM:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXPORT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case NAMESPACE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TEMPLATE:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case USING:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        declaration_seq();
        break;
      default:
        jj_la1[105] = jj_gen;
        ;
      }
      jj_consume_token(RCURLYBRACE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTERN:
        jj_consume_token(EXTERN);
        jj_consume_token(STRING_LITERAL);
        declaration();
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/***********************/
/* Declarators (A.7.1) */
/***********************/
// FIXME: took out isTypeDef parameter
// Warning, returns only first declarator
  final public Declarator init_declarator_list() throws ParseException {
  Declarator declarator;
    declarator = init_declarator(false);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      init_declarator(false);
    }
              {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public Declarator init_declarator(boolean isTypedef) throws ParseException {
  Declarator declarator;
    declarator = declarator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case ASSIGNEQUAL:
      initializer();
      break;
    default:
      jj_la1[108] = jj_gen;
      ;
    }
              {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public Declarator declarator() throws ParseException {
    Declaration dec = new Declaration();
    Declaration dummy = new Declaration();
    Declarator declarator = null;
    label_22:
    while (true) {
      if (jj_2_70(2147483647)) {
        ;
      } else {
        break label_22;
      }
      ptr_operator(dec);
    }
    declarator = direct_declarator();
                        declarator.isReference = dec.isReference;
                        declarator.pointer = dec.pointer;
                        {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

/*
Declarator direct_declarator() :
{
   String name;
   Token t;
   Declarator declarator = new Declarator();
}
{
   LOOKAHEAD(2)
    "~" t = identifier() (LOOKAHEAD(2) declarator_suffixes())?
        { declarator.name = "~" + t.image;
          return declarator; }
   |
    "(" declarator = declarator() ")" (LOOKAHEAD(2) declarator_suffixes())?
        { return declarator; }
   |
    name = qualified_id() (LOOKAHEAD(2) declarator_suffixes())?
    { declarator.name = name;
      return declarator; }
}
*/

/* Made parameter_declaration_clause() optional, to avoid empty production */
// FIXME: returns null
  final public Declarator direct_declarator() throws ParseException {
    String name = null;
    Declarator declarator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
    case TILDE:
    case OPERATOR:
    case IDENTIFIER:
      name = declarator_id();
              declarator = new Declarator(name);
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      declarator = declarator();
      jj_consume_token(RPARENTHESIS);
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_23:
    while (true) {
      if (jj_2_71(2147483647)) {
        ;
      } else {
        break label_23;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
        jj_consume_token(LPARENTHESIS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
        case ELLIPSIS:
        case AUTO:
        case BOOL:
        case CHAR:
        case CLASS:
        case CONST:
        case DOUBLE:
        case ENUM:
        case EXPLICIT:
        case EXTERN:
        case FLOAT:
        case FRIEND:
        case INLINE:
        case INT:
        case LONG:
        case MUTABLE:
        case OPERATOR:
        case REGISTER:
        case SHORT:
        case SIGNED:
        case STATIC:
        case STRUCT:
        case TYPEDEF:
        case TYPENAME:
        case UNION:
        case UNSIGNED:
        case VIRTUAL:
        case VOID:
        case VOLATILE:
        case WCHAR_T:
        case IDENTIFIER:
          parameter_declaration_clause(declarator);
          break;
        default:
          jj_la1[110] = jj_gen;
          ;
        }
        jj_consume_token(RPARENTHESIS);
        if (jj_2_72(2)) {
          cv_qualifier_seq();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case THROW:
          exception_specification();
          break;
        default:
          jj_la1[111] = jj_gen;
          ;
        }
                      declarator.isFunction = true;
        break;
      case LSQUAREBRACKET:
        jj_consume_token(LSQUAREBRACKET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPARENTHESIS:
        case SCOPE:
        case AMPERSAND:
        case PLUS:
        case MINUS:
        case STAR:
        case PLUSPLUS:
        case MINUSMINUS:
        case TILDE:
        case LOGICALNOT:
        case BOOL:
        case CHAR:
        case CONST_CAST:
        case DELETE:
        case DOUBLE:
        case DYNAMIC_CAST:
        case FALSETOK:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case OPERATOR:
        case REINTERPRET_CAST:
        case SHORT:
        case SIGNED:
        case SIZEOF:
        case STATIC_CAST:
        case THIS:
        case TRUETOK:
        case TYPEID:
        case TYPENAME:
        case UNSIGNED:
        case VOID:
        case WCHAR_T:
        case OCTAL:
        case DECIMAL:
        case HEXADECIMAL:
        case FLOATONE:
        case FLOATTWO:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
          constant_expression();
          break;
        default:
          jj_la1[112] = jj_gen;
          ;
        }
        jj_consume_token(RSQUAREBRACKET);
        break;
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
              {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public void ptr_operator(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
                  dec.isReference = true;
      break;
    case STAR:
      jj_consume_token(STAR);
      if (jj_2_73(2)) {
        cv_qualifier_seq();
      } else {
        ;
      }
                  dec.pointer++;
      break;
    case SCOPE:
    case OPERATOR:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[114] = jj_gen;
        ;
      }
      nested_name_specifier();
      jj_consume_token(STAR);
      if (jj_2_74(2)) {
        cv_qualifier_seq();
      } else {
        ;
      }

      break;
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void cv_qualifier_seq() throws ParseException {
    cv_qualifier();
    label_24:
    while (true) {
      if (jj_2_75(2)) {
        ;
      } else {
        break label_24;
      }
      cv_qualifier();
    }
  }

  final public void cv_qualifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      jj_consume_token(CONST);
      break;
    case VOLATILE:
      jj_consume_token(VOLATILE);
      break;
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// FIXME: SCOPE ignored
// FIXME: NNS ignored
  final public String declarator_id() throws ParseException {
  String name = null;
    if (jj_2_76(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      nested_name_specifier();
      name = type_name();
    } else if (jj_2_77(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[118] = jj_gen;
        ;
      }
      name = id_expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case OPERATOR:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[119] = jj_gen;
          ;
        }
        name = type_name();
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  final public void type_id() throws ParseException {
    type_specifier_seq();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
    case LPARENTHESIS:
    case SCOPE:
    case AMPERSAND:
    case STAR:
    case OPERATOR:
    case IDENTIFIER:
      abstract_declarator();
      break;
    default:
      jj_la1[121] = jj_gen;
      ;
    }
  }

/* (MOD 3) added cv_qualifier */
  final public void type_specifier_seq() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
    case VOLATILE:
      cv_qualifier();
      break;
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    type_specifier();
    label_25:
    while (true) {
      if (jj_2_78(2147483647)) {
        ;
      } else {
        break label_25;
      }
      type_specifier();
    }
  }

  final public Declarator abstract_declarator() throws ParseException {
    Declaration dec = new Declaration();
    Declarator declarator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
    case AMPERSAND:
    case STAR:
    case OPERATOR:
    case IDENTIFIER:
      ptr_operator(dec);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUAREBRACKET:
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case OPERATOR:
      case IDENTIFIER:
        declarator = abstract_declarator();
        break;
      default:
        jj_la1[123] = jj_gen;
        ;
      }
                        if (declarator == null) {
                            declarator = new Declarator("Undefined");
                            declarator.isReference = dec.isReference;
                            declarator.pointer = dec.pointer;
                        }
      break;
    case LSQUAREBRACKET:
    case LPARENTHESIS:
      declarator = direct_abstract_declarator();
      break;
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

/* Made parameter_declaration_clause() optional, to avoid empty production */
// CHECK THIS CAREFULLY
  final public Declarator direct_abstract_declarator() throws ParseException {
  Declarator declarator = new Declarator("Abstract");
    if (jj_2_80(2147483647)) {
      if (jj_2_79(2)) {
        declarator = direct_abstract_declarator_prefix();
      } else {
        ;
      }
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPARENTHESIS:
          jj_consume_token(LPARENTHESIS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
          case ELLIPSIS:
          case AUTO:
          case BOOL:
          case CHAR:
          case CLASS:
          case CONST:
          case DOUBLE:
          case ENUM:
          case EXPLICIT:
          case EXTERN:
          case FLOAT:
          case FRIEND:
          case INLINE:
          case INT:
          case LONG:
          case MUTABLE:
          case OPERATOR:
          case REGISTER:
          case SHORT:
          case SIGNED:
          case STATIC:
          case STRUCT:
          case TYPEDEF:
          case TYPENAME:
          case UNION:
          case UNSIGNED:
          case VIRTUAL:
          case VOID:
          case VOLATILE:
          case WCHAR_T:
          case IDENTIFIER:
            parameter_declaration_clause(declarator);
            break;
          default:
            jj_la1[125] = jj_gen;
            ;
          }
          jj_consume_token(RPARENTHESIS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CONST:
          case VOLATILE:
            cv_qualifier_seq();
            break;
          default:
            jj_la1[126] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case THROW:
            exception_specification();
            break;
          default:
            jj_la1[127] = jj_gen;
            ;
          }
                              declarator.isFunction = true;
          break;
        case LSQUAREBRACKET:
          jj_consume_token(LSQUAREBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPARENTHESIS:
          case SCOPE:
          case AMPERSAND:
          case PLUS:
          case MINUS:
          case STAR:
          case PLUSPLUS:
          case MINUSMINUS:
          case TILDE:
          case LOGICALNOT:
          case BOOL:
          case CHAR:
          case CONST_CAST:
          case DELETE:
          case DOUBLE:
          case DYNAMIC_CAST:
          case FALSETOK:
          case FLOAT:
          case INT:
          case LONG:
          case NEW:
          case OPERATOR:
          case REINTERPRET_CAST:
          case SHORT:
          case SIGNED:
          case SIZEOF:
          case STATIC_CAST:
          case THIS:
          case TRUETOK:
          case TYPEID:
          case TYPENAME:
          case UNSIGNED:
          case VOID:
          case WCHAR_T:
          case OCTAL:
          case DECIMAL:
          case HEXADECIMAL:
          case FLOATONE:
          case FLOATTWO:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
          case IDENTIFIER:
            constant_expression();
            break;
          default:
            jj_la1[128] = jj_gen;
            ;
          }
          jj_consume_token(RSQUAREBRACKET);
          break;
        default:
          jj_la1[129] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUAREBRACKET:
        case LPARENTHESIS:
          ;
          break;
        default:
          jj_la1[130] = jj_gen;
          break label_26;
        }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
        declarator = direct_abstract_declarator_prefix();
        break;
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                  {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public Declarator direct_abstract_declarator_prefix() throws ParseException {
  Declarator declarator = null;
    jj_consume_token(LPARENTHESIS);
    declarator = abstract_declarator();
    jj_consume_token(RPARENTHESIS);
                  {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

/* Made parameter_declaration_clause() always non-empty */
  final public void parameter_declaration_clause(Declarator declarator) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
                  System.err.println("Error, variable number of arguments not allowed!");
      break;
    case SCOPE:
    case AUTO:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case EXPLICIT:
    case EXTERN:
    case FLOAT:
    case FRIEND:
    case INLINE:
    case INT:
    case LONG:
    case MUTABLE:
    case OPERATOR:
    case REGISTER:
    case SHORT:
    case SIGNED:
    case STATIC:
    case STRUCT:
    case TYPEDEF:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case VIRTUAL:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      parameter_declaration_list(declarator);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case ELLIPSIS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[132] = jj_gen;
          ;
        }
        jj_consume_token(ELLIPSIS);
                  System.err.println("Error, variable number of arguments not allowed!");
        break;
      default:
        jj_la1[133] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parameter_declaration_list(Declarator declarator) throws ParseException {
  INamedType namedType;
    namedType = parameter_declaration();
                  declarator.parameters.addElement(namedType);
    label_27:
    while (true) {
      if (jj_2_81(2)) {
        ;
      } else {
        break label_27;
      }
      jj_consume_token(COMMA);
      namedType = parameter_declaration();
                  declarator.parameters.addElement(namedType);
    }
  }

/* It is questionable if the assignment expression is valid, if the abstract_declarator() has been left out */
/* (MOD 1) inserted type_specifier() */
// FIXME: what do we do if we only find a type?
  final public INamedType parameter_declaration() throws ParseException {
    Type type = new Type();
    Declarator declarator = null;
    INamedType namedType;
    Modifiers modifiers = new Modifiers();
    if (jj_2_84(2147483647)) {
      modifiers = decl_specifier_seq(modifiers);
      if (jj_2_82(2147483647)) {
        type = type_specifier();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO:
      case CONST:
      case EXPLICIT:
      case EXTERN:
      case FRIEND:
      case INLINE:
      case MUTABLE:
      case REGISTER:
      case STATIC:
      case TYPEDEF:
      case VIRTUAL:
      case VOLATILE:
        modifiers = decl_specifier_seq(modifiers);
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      declarator = declarator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        assignment_expression();
        break;
      default:
        jj_la1[136] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO:
      case CONST:
      case EXPLICIT:
      case EXTERN:
      case FRIEND:
      case INLINE:
      case MUTABLE:
      case REGISTER:
      case STATIC:
      case TYPEDEF:
      case VIRTUAL:
      case VOLATILE:
        modifiers = decl_specifier_seq(modifiers);
        if (jj_2_83(2147483647)) {
          type = type_specifier();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AUTO:
        case CONST:
        case EXPLICIT:
        case EXTERN:
        case FRIEND:
        case INLINE:
        case MUTABLE:
        case REGISTER:
        case STATIC:
        case TYPEDEF:
        case VIRTUAL:
        case VOLATILE:
          modifiers = decl_specifier_seq(modifiers);
          break;
        default:
          jj_la1[137] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUAREBRACKET:
        case LPARENTHESIS:
        case SCOPE:
        case AMPERSAND:
        case STAR:
        case OPERATOR:
        case IDENTIFIER:
          declarator = abstract_declarator();
          break;
        default:
          jj_la1[138] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSIGNEQUAL:
          jj_consume_token(ASSIGNEQUAL);
          assignment_expression();
          break;
        default:
          jj_la1[139] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[145] = jj_gen;
        if (jj_2_85(2147483647)) {
          type = type_specifier();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case AUTO:
          case CONST:
          case EXPLICIT:
          case EXTERN:
          case FRIEND:
          case INLINE:
          case MUTABLE:
          case REGISTER:
          case STATIC:
          case TYPEDEF:
          case VIRTUAL:
          case VOLATILE:
            modifiers = decl_specifier_seq(modifiers);
            break;
          default:
            jj_la1[140] = jj_gen;
            ;
          }
          declarator = declarator();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ASSIGNEQUAL:
            jj_consume_token(ASSIGNEQUAL);
            assignment_expression();
            break;
          default:
            jj_la1[141] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SCOPE:
          case BOOL:
          case CHAR:
          case CLASS:
          case DOUBLE:
          case ENUM:
          case FLOAT:
          case INT:
          case LONG:
          case OPERATOR:
          case SHORT:
          case SIGNED:
          case STRUCT:
          case TYPENAME:
          case UNION:
          case UNSIGNED:
          case VOID:
          case WCHAR_T:
          case IDENTIFIER:
            type = type_specifier();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case AUTO:
            case CONST:
            case EXPLICIT:
            case EXTERN:
            case FRIEND:
            case INLINE:
            case MUTABLE:
            case REGISTER:
            case STATIC:
            case TYPEDEF:
            case VIRTUAL:
            case VOLATILE:
              modifiers = decl_specifier_seq(modifiers);
              break;
            default:
              jj_la1[142] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LSQUAREBRACKET:
            case LPARENTHESIS:
            case SCOPE:
            case AMPERSAND:
            case STAR:
            case OPERATOR:
            case IDENTIFIER:
              declarator = abstract_declarator();
              break;
            default:
              jj_la1[143] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASSIGNEQUAL:
              jj_consume_token(ASSIGNEQUAL);
              assignment_expression();
              break;
            default:
              jj_la1[144] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[146] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
                    if (declarator != null) {
                        IType iType = getType(type, declarator);
                        namedType = Jaco.getRTTI().createNamedType(declarator.name, iType, null);
                    } else {
                        IType iType = getType(type, null);
                        namedType = Jaco.getRTTI().createNamedType("dummy", iType, null);
                    }
                    {if (true) return namedType;}
    throw new Error("Missing return statement in function");
  }

/* (MOD 1) added type_specifier */
  final public void function_definition(String name, Vector constructors, Vector destructors, Vector methods, boolean isPublic) throws ParseException {
    Type type = new Type();
    Modifiers modifiers = new Modifiers();
    Declarator declarator = null;
    methodComments = comments;
    comments = null;
    if (jj_2_90(2147483647)) {
      if (jj_2_86(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      type = type_specifier();
      declarator = declarator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        ctor_initializer();
        break;
      default:
        jj_la1[147] = jj_gen;
        ;
      }
      function_body();
    } else if (jj_2_91(2147483647)) {
      if (jj_2_87(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      declarator = declarator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        ctor_initializer();
        break;
      default:
        jj_la1[148] = jj_gen;
        ;
      }
      function_body();
    } else if (jj_2_92(2147483647)) {
      if (jj_2_88(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      type = type_specifier();
      declarator = declarator();
      function_try_block();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case AUTO:
      case CONST:
      case EXPLICIT:
      case EXTERN:
      case FRIEND:
      case INLINE:
      case MUTABLE:
      case OPERATOR:
      case REGISTER:
      case STATIC:
      case TYPEDEF:
      case VIRTUAL:
      case VOLATILE:
      case IDENTIFIER:
        if (jj_2_89(2)) {
          modifiers = decl_specifier_seq(modifiers);
        } else {
          ;
        }
        declarator = declarator();
        function_try_block();
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                if ((isPublic) && (declarator != null) && (declarator.isFunction)) {
                    if ((name != null) && (declarator.name.equals(name))) {
                        constructors.addElement(Jaco.getRTTI().createConstructor(declarator.name, methodComments, declarator.parameters, null));
                    } else if ((name != null) && (declarator.name.equals("~"+name))) {
                        destructors.addElement(Jaco.getRTTI().createDestructor(declarator.name, methodComments, null));
                    } else {
                        IType iType = getType(type, declarator);
                        methods.addElement(Jaco.getRTTI().createMethod(declarator.name, methodComments, modifiers.isStatic, iType, false, declarator.parameters, null));
                    }
                    methodComments = null;
                    comments = null;
                }
  }

  final public void function_body() throws ParseException {
    compound_statement();
  }

  final public void initializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      initializer_clause();
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      expression_list();
      jj_consume_token(RPARENTHESIS);
      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void initializer_clause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case AMPERSAND:
    case PLUS:
    case MINUS:
    case STAR:
    case PLUSPLUS:
    case MINUSMINUS:
    case TILDE:
    case LOGICALNOT:
    case BOOL:
    case CHAR:
    case CONST_CAST:
    case DELETE:
    case DOUBLE:
    case DYNAMIC_CAST:
    case FALSETOK:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case OPERATOR:
    case REINTERPRET_CAST:
    case SHORT:
    case SIGNED:
    case SIZEOF:
    case STATIC_CAST:
    case THIS:
    case THROW:
    case TRUETOK:
    case TYPEID:
    case TYPENAME:
    case UNSIGNED:
    case VOID:
    case WCHAR_T:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      assignment_expression();
      break;
    case LCURLYBRACE:
      jj_consume_token(LCURLYBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LCURLYBRACE:
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case PLUS:
      case MINUS:
      case STAR:
      case PLUSPLUS:
      case MINUSMINUS:
      case TILDE:
      case LOGICALNOT:
      case BOOL:
      case CHAR:
      case CONST_CAST:
      case DELETE:
      case DOUBLE:
      case DYNAMIC_CAST:
      case FALSETOK:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case OPERATOR:
      case REINTERPRET_CAST:
      case SHORT:
      case SIGNED:
      case SIZEOF:
      case STATIC_CAST:
      case THIS:
      case THROW:
      case TRUETOK:
      case TYPEID:
      case TYPENAME:
      case UNSIGNED:
      case VOID:
      case WCHAR_T:
      case OCTAL:
      case DECIMAL:
      case HEXADECIMAL:
      case FLOATONE:
      case FLOATTWO:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
        initializer_list();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[151] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[152] = jj_gen;
        ;
      }
      jj_consume_token(RCURLYBRACE);
      break;
    default:
      jj_la1[153] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void initializer_list() throws ParseException {
    initializer_clause();
    label_28:
    while (true) {
      if (jj_2_93(2)) {
        ;
      } else {
        break label_28;
      }
      jj_consume_token(COMMA);
      initializer_clause();
    }
  }

/*****************/
/* Classes (A.8) */
/*****************/
  final public String class_name() throws ParseException {
    String name;
    if (jj_2_94(2147483647)) {
      name = template_id();
                      {if (true) return name;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        name = identifier();
                      {if (true) return name;}
        break;
      default:
        jj_la1[154] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void class_specifier() throws ParseException {
   Vector superclasses = new Vector();
   Vector constructors = new Vector();
   Vector destructors = new Vector();
   Vector methods = new Vector();
//   ClassScope sc = null;
   String name;
                      classComments = comments; comments = null;
    name = class_head(superclasses);
    jj_consume_token(LCURLYBRACE);
                      sym.openScope(null, false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case COLON:
    case SEMICOLON:
    case AMPERSAND:
    case STAR:
    case TILDE:
    case AUTO:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case EXPLICIT:
    case EXPORT:
    case EXTERN:
    case FLOAT:
    case FRIEND:
    case INLINE:
    case INT:
    case LONG:
    case MUTABLE:
    case OPERATOR:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case REGISTER:
    case SHORT:
    case SIGNED:
    case STATIC:
    case STRUCT:
    case TEMPLATE:
    case TYPEDEF:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case USING:
    case VIRTUAL:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      member_specification(name, constructors, destructors, methods);
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    jj_consume_token(RCURLYBRACE);
                      sym.closeScope();
                      if (name != null) Jaco.getRTTI().createClass(name, true,
                                                                   getCurrentNamespace(), null,
                                                                   classComments, null,
                                                                   superclasses, constructors, (IDestructor)destructors.get(0),
                                                                   methods, null);
                      comments = null;
                      methodComments = null;
                      classComments = null;
  }

/* (MOD 8) changed identifier into class_name */
  final public String class_head(Vector superclasses) throws ParseException {
    String nns = "";
    String name = null;
    if (jj_2_95(2147483647)) {
      class_key();
      nns = nested_name_specifier();
      jj_consume_token(TEMPLATE);
      name = template_id();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        base_clause(superclasses);
        break;
      default:
        jj_la1[156] = jj_gen;
        ;
      }
                      {if (true) return nns + "<TEMPLATE>" + name;}
    } else if (jj_2_96(2147483647)) {
      class_key();
      nns = nested_name_specifier();
      name = identifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        base_clause(superclasses);
        break;
      default:
        jj_la1[157] = jj_gen;
        ;
      }
                      {if (true) return nns + name;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASS:
      case STRUCT:
      case UNION:
        class_key();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPERATOR:
        case IDENTIFIER:
          name = class_name();
          break;
        default:
          jj_la1[158] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          base_clause(superclasses);
          break;
        default:
          jj_la1[159] = jj_gen;
          ;
        }
                      {if (true) return name;}
        break;
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void class_key() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      break;
    case STRUCT:
      jj_consume_token(STRUCT);
      break;
    case UNION:
      jj_consume_token(UNION);
      break;
    default:
      jj_la1[161] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                classComments = comments;
                comments = null;
  }

  final public void member_specification(String name, Vector constructors, Vector destructors, Vector methods) throws ParseException {
  String access; boolean isPublic = false;
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case COLON:
      case SEMICOLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXPORT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TEMPLATE:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case USING:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        member_declaration(name, constructors, destructors, methods, isPublic);
        break;
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
        access = access_specifier();
        jj_consume_token(COLON);
                      isPublic = (access.equals("public")) ? true : false;
        break;
      default:
        jj_la1[162] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case COLON:
      case SEMICOLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXPORT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case OPERATOR:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TEMPLATE:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case USING:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_29;
      }
    }
  }

/* (MOD 1) added type_specifier */
  final public void member_declaration(String name, Vector constructors, Vector destructors, Vector methods, boolean isPublic) throws ParseException {
    Type type =new Type();
    Modifiers modifiers = new Modifiers();
    Declarator declarator = null;
    methodComments = comments;
    comments = null;
    if (jj_2_101(2147483647)) {
      using_declaration();
    } else if (jj_2_102(2147483647)) {
      template_declaration();
    } else if (jj_2_103(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      nested_name_specifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEMPLATE:
        jj_consume_token(TEMPLATE);
        break;
      default:
        jj_la1[165] = jj_gen;
        ;
      }
      unqualified_id();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_104(2147483647)) {
      if (jj_2_97(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      type = type_specifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case COLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        declarator = member_declarator_list();
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_105(2147483647)) {
      type = type_specifier();
      if (jj_2_98(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case COLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        declarator = member_declarator_list();
        break;
      default:
        jj_la1[167] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_106(2147483647)) {
      if (jj_2_99(2)) {
        modifiers = decl_specifier_seq(modifiers);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case COLON:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        declarator = member_declarator_list();
        break;
      default:
        jj_la1[168] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        function_definition(name, constructors, destructors, methods, isPublic);
        if (jj_2_100(2)) {
          jj_consume_token(SEMICOLON);
        } else {
          ;
        }
        break;
      default:
        jj_la1[169] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                if ((isPublic) && (declarator != null) && (declarator.isFunction)) {
                    if (declarator.name.equals(name)) {
                        constructors.addElement(Jaco.getRTTI().createConstructor(declarator.name, methodComments, declarator.parameters, null));
                    } else if (declarator.name.equals("~"+name)) {
                        destructors.addElement(Jaco.getRTTI().createDestructor(declarator.name, methodComments, null));
                    } else {
                        IType iType = getType(type, declarator);
                        methods.addElement(Jaco.getRTTI().createMethod(declarator.name, methodComments, modifiers.isStatic, iType, false, declarator.parameters, null));
                    }
                }
                methodComments = null;
                comments = null;
  }

// Warning Returns only first declarator, not a problem for us.
  final public Declarator member_declarator_list() throws ParseException {
  Declarator declarator;
    declarator = member_declarator();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[170] = jj_gen;
        break label_30;
      }
      jj_consume_token(COMMA);
      member_declarator();
    }
                  {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public Declarator member_declarator() throws ParseException {
  Declarator declarator = null;
    if (jj_2_107(2147483647)) {
      declarator = declarator();
      pure_specifier();
    } else if (jj_2_108(2147483647)) {
      declarator = declarator();
      constant_initializer();
    } else if (jj_2_109(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        identifier();
        break;
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
      constant_expression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case IDENTIFIER:
        declarator = declarator();
        break;
      default:
        jj_la1[172] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                  {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

/* Too open, cannot define zero_digit and octal */
  final public void pure_specifier() throws ParseException {
    jj_consume_token(ASSIGNEQUAL);
    jj_consume_token(OCTAL);
  }

  final public void constant_initializer() throws ParseException {
    jj_consume_token(ASSIGNEQUAL);
    constant_expression();
  }

/***************************/
/* Derived Classes (A.8.1) */
/***************************/
  final public void base_clause(Vector superclasses) throws ParseException {
    jj_consume_token(COLON);
    base_specifier_list(superclasses);
  }

  final public void base_specifier_list(Vector superclasses) throws ParseException {
    String name;
    name = base_specifier();
                      superclasses.addElement(name);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[173] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      name = base_specifier();
                      superclasses.addElement(name);
    }
  }

// FIXME access specifiers and virtual are ignored
  final public String base_specifier() throws ParseException {
    Token scope = null;
    String nns = "";
    String name = "";
    if (jj_2_113(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        scope = jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[174] = jj_gen;
        ;
      }
      name = class_name();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case OPERATOR:
      case IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          scope = jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[175] = jj_gen;
          ;
        }
        if (jj_2_110(2147483647)) {
          nns = nested_name_specifier();
        } else {
          ;
        }
        name = class_name();
        break;
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
          access_specifier();
          break;
        default:
          jj_la1[176] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          scope = jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[177] = jj_gen;
          ;
        }
        if (jj_2_111(2147483647)) {
          nns = nested_name_specifier();
        } else {
          ;
        }
        name = class_name();
        break;
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
        access_specifier();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VIRTUAL:
          jj_consume_token(VIRTUAL);
          break;
        default:
          jj_la1[178] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          scope = jj_consume_token(SCOPE);
          break;
        default:
          jj_la1[179] = jj_gen;
          ;
        }
        if (jj_2_112(2147483647)) {
          nns = nested_name_specifier();
        } else {
          ;
        }
        name = class_name();
        break;
      default:
        jj_la1[180] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                      {if (true) return ( (scope != null) ? scope.image : "" ) + nns + name;}
    throw new Error("Missing return statement in function");
  }

  final public String access_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIVATE:
      jj_consume_token(PRIVATE);
                      {if (true) return "private";}
      break;
    case PROTECTED:
      jj_consume_token(PROTECTED);
                      {if (true) return "protected";}
      break;
    case PUBLIC:
      jj_consume_token(PUBLIC);
                      {if (true) return "public";}
      break;
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/************************************/
/* Special Member Functions (A.8.2) */
/************************************/
  final public void conversion_function_id() throws ParseException {
    jj_consume_token(OPERATOR);
    conversion_type_id();
  }

  final public void conversion_type_id() throws ParseException {
    type_specifier_seq();
    if (jj_2_114(2)) {
      conversion_declarator();
    } else {
      ;
    }
  }

  final public void conversion_declarator() throws ParseException {
  Declaration dummy = new Declaration();
    ptr_operator(dummy);
    label_32:
    while (true) {
      if (jj_2_115(2)) {
        ;
      } else {
        break label_32;
      }
      ptr_operator(dummy);
    }
  }

  final public void ctor_initializer() throws ParseException {
    jj_consume_token(COLON);
    mem_initializer_list();
  }

  final public void mem_initializer_list() throws ParseException {
    mem_initializer();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[182] = jj_gen;
        break label_33;
      }
      jj_consume_token(COMMA);
      mem_initializer();
    }
  }

  final public void mem_initializer() throws ParseException {
    mem_initializer_id();
    jj_consume_token(LPARENTHESIS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case AMPERSAND:
    case PLUS:
    case MINUS:
    case STAR:
    case PLUSPLUS:
    case MINUSMINUS:
    case TILDE:
    case LOGICALNOT:
    case BOOL:
    case CHAR:
    case CONST_CAST:
    case DELETE:
    case DOUBLE:
    case DYNAMIC_CAST:
    case FALSETOK:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case OPERATOR:
    case REINTERPRET_CAST:
    case SHORT:
    case SIGNED:
    case SIZEOF:
    case STATIC_CAST:
    case THIS:
    case THROW:
    case TRUETOK:
    case TYPEID:
    case TYPENAME:
    case UNSIGNED:
    case VOID:
    case WCHAR_T:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      expression_list();
      break;
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public void mem_initializer_id() throws ParseException {
    if (jj_2_117(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
        jj_consume_token(SCOPE);
        break;
      default:
        jj_la1[184] = jj_gen;
        ;
      }
      if (jj_2_116(2147483647)) {
        nested_name_specifier();
      } else {
        ;
      }
      class_name();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        identifier();
        break;
      default:
        jj_la1[185] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/***********************/
/* Overloading (A.8.3) */
/***********************/
  final public String operator_function_id() throws ParseException {
    String name;
    jj_consume_token(OPERATOR);
    name = operator();
                      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// FIXME look at the list what to implement here
  final public String operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEW:
      jj_consume_token(NEW);
      if (jj_2_118(2)) {
        jj_consume_token(LSQUAREBRACKET);
        jj_consume_token(RSQUAREBRACKET);
      } else {
        ;
      }
      break;
    case DELETE:
      jj_consume_token(DELETE);
      if (jj_2_119(2)) {
        jj_consume_token(LSQUAREBRACKET);
        jj_consume_token(RSQUAREBRACKET);
      } else {
        ;
      }
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case STAR:
      jj_consume_token(STAR);
      break;
    case DIVIDE:
      jj_consume_token(DIVIDE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case BITWISEXOR:
      jj_consume_token(BITWISEXOR);
      break;
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      break;
    case BITWISEOR:
      jj_consume_token(BITWISEOR);
      break;
    case TILDE:
      jj_consume_token(TILDE);
      break;
    case LOGICALNOT:
      jj_consume_token(LOGICALNOT);
      break;
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      break;
    case LESSTHAN:
      jj_consume_token(LESSTHAN);
      break;
    case GREATERTHAN:
      jj_consume_token(GREATERTHAN);
      break;
    case PLUSEQUAL:
      jj_consume_token(PLUSEQUAL);
      break;
    case MINUSEQUAL:
      jj_consume_token(MINUSEQUAL);
      break;
    case TIMESEQUAL:
      jj_consume_token(TIMESEQUAL);
      break;
    case DIVIDEEQUAL:
      jj_consume_token(DIVIDEEQUAL);
      break;
    case MODEQUAL:
      jj_consume_token(MODEQUAL);
      break;
    case BITWISEXOREQUAL:
      jj_consume_token(BITWISEXOREQUAL);
      break;
    case BITWISEANDEQUAL:
      jj_consume_token(BITWISEANDEQUAL);
      break;
    case BITWISEOREQUAL:
      jj_consume_token(BITWISEOREQUAL);
      break;
    case SHIFTLEFT:
      jj_consume_token(SHIFTLEFT);
      break;
    case SHIFTRIGHT:
      jj_consume_token(SHIFTRIGHT);
      break;
    case SHIFTLEFTEQUAL:
      jj_consume_token(SHIFTLEFTEQUAL);
      break;
    case SHIFTRIGHTEQUAL:
      jj_consume_token(SHIFTRIGHTEQUAL);
      break;
    case EQUAL:
      jj_consume_token(EQUAL);
      break;
    case NOTEQUAL:
      jj_consume_token(NOTEQUAL);
      break;
    case LESSTHANOREQUALTO:
      jj_consume_token(LESSTHANOREQUALTO);
      break;
    case GREATERTHANOREQUALTO:
      jj_consume_token(GREATERTHANOREQUALTO);
      break;
    case LOGICALAND:
      jj_consume_token(LOGICALAND);
      break;
    case LOGICALOR:
      jj_consume_token(LOGICALOR);
      break;
    case PLUSPLUS:
      jj_consume_token(PLUSPLUS);
      break;
    case MINUSMINUS:
      jj_consume_token(MINUSMINUS);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      break;
    case ARROWSTAR:
      jj_consume_token(ARROWSTAR);
      break;
    case POINTERTO:
      jj_consume_token(POINTERTO);
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      jj_consume_token(RPARENTHESIS);
      break;
    case LSQUAREBRACKET:
      jj_consume_token(LSQUAREBRACKET);
      jj_consume_token(RSQUAREBRACKET);
      break;
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                      {if (true) return "notImplemented";}
    throw new Error("Missing return statement in function");
  }

/*******************/
/* Templates (A.9) */
/*******************/
  final public void template_declaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXPORT:
      jj_consume_token(EXPORT);
      break;
    default:
      jj_la1[187] = jj_gen;
      ;
    }
    jj_consume_token(TEMPLATE);
    jj_consume_token(LESSTHAN);
    template_parameter_list();
    jj_consume_token(GREATERTHAN);
    declaration();
  }

  final public void template_parameter_list() throws ParseException {
    template_parameter();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[188] = jj_gen;
        break label_34;
      }
      jj_consume_token(COMMA);
      template_parameter();
    }
  }

  final public void template_parameter() throws ParseException {
    if (jj_2_120(3)) {
      type_parameter();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case AUTO:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case EXPLICIT:
      case EXTERN:
      case FLOAT:
      case FRIEND:
      case INLINE:
      case INT:
      case LONG:
      case MUTABLE:
      case OPERATOR:
      case REGISTER:
      case SHORT:
      case SIGNED:
      case STATIC:
      case STRUCT:
      case TYPEDEF:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case VIRTUAL:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        parameter_declaration();
        break;
      default:
        jj_la1[189] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* It is questionable if the template_name() is valid when the identifier() has been left out */
// FIXME: what is s equals null
  final public void type_parameter() throws ParseException {
  String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      jj_consume_token(CLASS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        s = identifier();
        break;
      default:
        jj_la1[190] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        type_id();
        break;
      default:
        jj_la1[191] = jj_gen;
        ;
      }
              if (s != null) sym.putTypeName(s);
      break;
    case TYPENAME:
      jj_consume_token(TYPENAME);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        s = identifier();
        break;
      default:
        jj_la1[192] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        type_id();
        break;
      default:
        jj_la1[193] = jj_gen;
        ;
      }
      break;
    case TEMPLATE:
      jj_consume_token(TEMPLATE);
      jj_consume_token(LESSTHAN);
      template_parameter_list();
      jj_consume_token(GREATERTHAN);
      jj_consume_token(CLASS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        s = identifier();
        break;
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        template_name();
        break;
      default:
        jj_la1[195] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// SP: Switch to SP Option to speed up the generation of the Parser.
// FIXME: ( template_argument_list() )?
// the returned string has to be more complicated here...
  final public String template_id() throws ParseException {
    String name;
    name = template_name();
    jj_consume_token(LESSTHAN);
    template_arguments();
                      {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// MOD 17 template names can also be operator definitions (not in the spec)
  final public String template_name() throws ParseException {
    String name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      name = identifier();
                      {if (true) return name;}
      break;
    case OPERATOR:
      name = operator_function_id();
                      {if (true) return name;}
      break;
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// (MOD 14) removed template_name() since it is included in type_id()
// (MOD 17) rules for template arguments were changed:
//      - one needs to look ahead for the <GREATERTHAN> sign
//      - one cannot look ahead and not consume itself, or its sub-production
//      -> therefore the productions were rewritten to be able to consume the <GREATERTHAN> sign.
// (MOD 18) only a simplyfied template_argument is allowed.
  final public void template_arguments() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GREATERTHAN:
      jj_consume_token(GREATERTHAN);
      break;
    default:
      jj_la1[198] = jj_gen;
      if (jj_2_121(2147483647)) {
        type_id();
        jj_consume_token(COMMA);
        template_arguments();
      } else if (jj_2_122(2147483647)) {
        type_id();
        jj_consume_token(GREATERTHAN);
      } else if (jj_2_123(2147483647)) {
        ta_expression();
        jj_consume_token(COMMA);
        template_arguments();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPARENTHESIS:
        case SCOPE:
        case TILDE:
        case FALSETOK:
        case OPERATOR:
        case THIS:
        case TRUETOK:
        case OCTAL:
        case DECIMAL:
        case HEXADECIMAL:
        case FLOATONE:
        case FLOATTWO:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
          ta_expression();
          jj_consume_token(GREATERTHAN);
          break;
        default:
          jj_la1[199] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void ta_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      ta_expression();
      jj_consume_token(RPARENTHESIS);
      break;
    case SCOPE:
    case TILDE:
    case FALSETOK:
    case OPERATOR:
    case THIS:
    case TRUETOK:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      ta_term();
      label_35:
      while (true) {
        if (jj_2_124(2)) {
          ;
        } else {
          break label_35;
        }
        ta_operator();
        ta_expression();
      }
      break;
    default:
      jj_la1[200] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ta_term() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSETOK:
    case TRUETOK:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      literal();
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    default:
      jj_la1[201] = jj_gen;
      if (jj_2_125(3)) {
        jj_consume_token(SCOPE);
        identifier();
      } else if (jj_2_126(2)) {
        jj_consume_token(SCOPE);
        operator_function_id();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
          jj_consume_token(SCOPE);
          qualified_id();
          break;
        case TILDE:
        case OPERATOR:
        case IDENTIFIER:
          id_expression();
          break;
        default:
          jj_la1[202] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void ta_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case STAR:
      jj_consume_token(STAR);
      break;
    case DIVIDE:
      jj_consume_token(DIVIDE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    default:
      jj_la1[203] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void explicit_instantiation() throws ParseException {
    jj_consume_token(TEMPLATE);
    declaration();
  }

  final public void explicit_specialization() throws ParseException {
    jj_consume_token(TEMPLATE);
    jj_consume_token(LESSTHAN);
    jj_consume_token(GREATERTHAN);
    declaration();
  }

/*****************************/
/* Exception Handling (A.10) */
/*****************************/
  final public void try_block() throws ParseException {
    jj_consume_token(TRY);
    compound_statement();
    handler_seq();
  }

  final public void function_try_block() throws ParseException {
    jj_consume_token(TRY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      ctor_initializer();
      break;
    default:
      jj_la1[204] = jj_gen;
      ;
    }
    function_body();
    handler_seq();
  }

  final public void handler_seq() throws ParseException {
    handler();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
        ;
        break;
      default:
        jj_la1[205] = jj_gen;
        break label_36;
      }
      handler();
    }
  }

/*
 |
   "finally" compound_statement()
*/
  final public void handler() throws ParseException {
    jj_consume_token(CATCH);
    jj_consume_token(LPARENTHESIS);
    exception_declaration();
    jj_consume_token(RPARENTHESIS);
    compound_statement();
  }

  final public void exception_declaration() throws ParseException {
    if (jj_2_127(3)) {
      type_specifier_seq();
      declarator();
    } else if (jj_2_128(3)) {
      type_specifier_seq();
      abstract_declarator();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case BOOL:
      case CHAR:
      case CLASS:
      case CONST:
      case DOUBLE:
      case ENUM:
      case FLOAT:
      case INT:
      case LONG:
      case OPERATOR:
      case SHORT:
      case SIGNED:
      case STRUCT:
      case TYPENAME:
      case UNION:
      case UNSIGNED:
      case VOID:
      case VOLATILE:
      case WCHAR_T:
      case IDENTIFIER:
        type_specifier_seq();
        break;
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
        break;
      default:
        jj_la1[206] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void throw_expression() throws ParseException {
    jj_consume_token(THROW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case SCOPE:
    case AMPERSAND:
    case PLUS:
    case MINUS:
    case STAR:
    case PLUSPLUS:
    case MINUSMINUS:
    case TILDE:
    case LOGICALNOT:
    case BOOL:
    case CHAR:
    case CONST_CAST:
    case DELETE:
    case DOUBLE:
    case DYNAMIC_CAST:
    case FALSETOK:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case OPERATOR:
    case REINTERPRET_CAST:
    case SHORT:
    case SIGNED:
    case SIZEOF:
    case STATIC_CAST:
    case THIS:
    case THROW:
    case TRUETOK:
    case TYPEID:
    case TYPENAME:
    case UNSIGNED:
    case VOID:
    case WCHAR_T:
    case OCTAL:
    case DECIMAL:
    case HEXADECIMAL:
    case FLOATONE:
    case FLOATTWO:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
      assignment_expression();
      break;
    default:
      jj_la1[207] = jj_gen;
      ;
    }
  }

  final public void exception_specification() throws ParseException {
    jj_consume_token(THROW);
    jj_consume_token(LPARENTHESIS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
    case BOOL:
    case CHAR:
    case CLASS:
    case CONST:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case OPERATOR:
    case SHORT:
    case SIGNED:
    case STRUCT:
    case TYPENAME:
    case UNION:
    case UNSIGNED:
    case VOID:
    case VOLATILE:
    case WCHAR_T:
    case IDENTIFIER:
      type_id_list();
      break;
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public void type_id_list() throws ParseException {
    type_id();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[209] = jj_gen;
        break label_37;
      }
      jj_consume_token(COMMA);
      type_id();
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_18();
    jj_save(17, xla);
    return retval;
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_19();
    jj_save(18, xla);
    return retval;
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_20();
    jj_save(19, xla);
    return retval;
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_21();
    jj_save(20, xla);
    return retval;
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_22();
    jj_save(21, xla);
    return retval;
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_23();
    jj_save(22, xla);
    return retval;
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_24();
    jj_save(23, xla);
    return retval;
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_25();
    jj_save(24, xla);
    return retval;
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_26();
    jj_save(25, xla);
    return retval;
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_27();
    jj_save(26, xla);
    return retval;
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_28();
    jj_save(27, xla);
    return retval;
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_29();
    jj_save(28, xla);
    return retval;
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_30();
    jj_save(29, xla);
    return retval;
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_31();
    jj_save(30, xla);
    return retval;
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_32();
    jj_save(31, xla);
    return retval;
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_33();
    jj_save(32, xla);
    return retval;
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_34();
    jj_save(33, xla);
    return retval;
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_35();
    jj_save(34, xla);
    return retval;
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_36();
    jj_save(35, xla);
    return retval;
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_37();
    jj_save(36, xla);
    return retval;
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_38();
    jj_save(37, xla);
    return retval;
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_39();
    jj_save(38, xla);
    return retval;
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_40();
    jj_save(39, xla);
    return retval;
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_41();
    jj_save(40, xla);
    return retval;
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_42();
    jj_save(41, xla);
    return retval;
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_43();
    jj_save(42, xla);
    return retval;
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_44();
    jj_save(43, xla);
    return retval;
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_45();
    jj_save(44, xla);
    return retval;
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_46();
    jj_save(45, xla);
    return retval;
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_47();
    jj_save(46, xla);
    return retval;
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_48();
    jj_save(47, xla);
    return retval;
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_49();
    jj_save(48, xla);
    return retval;
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_50();
    jj_save(49, xla);
    return retval;
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_51();
    jj_save(50, xla);
    return retval;
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_52();
    jj_save(51, xla);
    return retval;
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_53();
    jj_save(52, xla);
    return retval;
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_54();
    jj_save(53, xla);
    return retval;
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_55();
    jj_save(54, xla);
    return retval;
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_56();
    jj_save(55, xla);
    return retval;
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_57();
    jj_save(56, xla);
    return retval;
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_58();
    jj_save(57, xla);
    return retval;
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_59();
    jj_save(58, xla);
    return retval;
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_60();
    jj_save(59, xla);
    return retval;
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_61();
    jj_save(60, xla);
    return retval;
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_62();
    jj_save(61, xla);
    return retval;
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_63();
    jj_save(62, xla);
    return retval;
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_64();
    jj_save(63, xla);
    return retval;
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_65();
    jj_save(64, xla);
    return retval;
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_66();
    jj_save(65, xla);
    return retval;
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_67();
    jj_save(66, xla);
    return retval;
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_68();
    jj_save(67, xla);
    return retval;
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_69();
    jj_save(68, xla);
    return retval;
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_70();
    jj_save(69, xla);
    return retval;
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_71();
    jj_save(70, xla);
    return retval;
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_72();
    jj_save(71, xla);
    return retval;
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_73();
    jj_save(72, xla);
    return retval;
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_74();
    jj_save(73, xla);
    return retval;
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_75();
    jj_save(74, xla);
    return retval;
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_76();
    jj_save(75, xla);
    return retval;
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_77();
    jj_save(76, xla);
    return retval;
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_78();
    jj_save(77, xla);
    return retval;
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_79();
    jj_save(78, xla);
    return retval;
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_80();
    jj_save(79, xla);
    return retval;
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_81();
    jj_save(80, xla);
    return retval;
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_82();
    jj_save(81, xla);
    return retval;
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_83();
    jj_save(82, xla);
    return retval;
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_84();
    jj_save(83, xla);
    return retval;
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_85();
    jj_save(84, xla);
    return retval;
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_86();
    jj_save(85, xla);
    return retval;
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_87();
    jj_save(86, xla);
    return retval;
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_88();
    jj_save(87, xla);
    return retval;
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_89();
    jj_save(88, xla);
    return retval;
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_90();
    jj_save(89, xla);
    return retval;
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_91();
    jj_save(90, xla);
    return retval;
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_92();
    jj_save(91, xla);
    return retval;
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_93();
    jj_save(92, xla);
    return retval;
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_94();
    jj_save(93, xla);
    return retval;
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_95();
    jj_save(94, xla);
    return retval;
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_96();
    jj_save(95, xla);
    return retval;
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_97();
    jj_save(96, xla);
    return retval;
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_98();
    jj_save(97, xla);
    return retval;
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_99();
    jj_save(98, xla);
    return retval;
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_100();
    jj_save(99, xla);
    return retval;
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_101();
    jj_save(100, xla);
    return retval;
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_102();
    jj_save(101, xla);
    return retval;
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_103();
    jj_save(102, xla);
    return retval;
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_104();
    jj_save(103, xla);
    return retval;
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_105();
    jj_save(104, xla);
    return retval;
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_106();
    jj_save(105, xla);
    return retval;
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_107();
    jj_save(106, xla);
    return retval;
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_108();
    jj_save(107, xla);
    return retval;
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_109();
    jj_save(108, xla);
    return retval;
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_110();
    jj_save(109, xla);
    return retval;
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_111();
    jj_save(110, xla);
    return retval;
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_112();
    jj_save(111, xla);
    return retval;
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_113();
    jj_save(112, xla);
    return retval;
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_114();
    jj_save(113, xla);
    return retval;
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_115();
    jj_save(114, xla);
    return retval;
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_116();
    jj_save(115, xla);
    return retval;
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_117();
    jj_save(116, xla);
    return retval;
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_118();
    jj_save(117, xla);
    return retval;
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_119();
    jj_save(118, xla);
    return retval;
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_120();
    jj_save(119, xla);
    return retval;
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_121();
    jj_save(120, xla);
    return retval;
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_122();
    jj_save(121, xla);
    return retval;
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_123();
    jj_save(122, xla);
    return retval;
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_124();
    jj_save(123, xla);
    return retval;
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_125();
    jj_save(124, xla);
    return retval;
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_126();
    jj_save(125, xla);
    return retval;
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_127();
    jj_save(126, xla);
    return retval;
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_128();
    jj_save(127, xla);
    return retval;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_261()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_622()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_413() {
    if (jj_3R_458()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_616() {
    if (jj_3R_618()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_612() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3R_616()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_3R_104()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_464() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_503() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_502()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_523() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_537()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_522() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_502() {
    if (jj_3R_522()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_412() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_460() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_458() {
    if (jj_3R_502()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_503()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_462() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_463() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_353() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_412()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_413()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_326() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_459() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(VOID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_461() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_416() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_463()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_464()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(DOUBLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_415() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_461()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_462()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_354() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_414() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_459()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_460()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(FLOAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_324() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_102()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_322() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_202() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_326()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_323() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_320() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_201() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_324()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(SHORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_321() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_200() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(BOOL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_319() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_199() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_318() {
    if (jj_scan_token(VOID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_317() {
    if (jj_scan_token(DOUBLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(WCHAR_T)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_316() {
    if (jj_scan_token(FLOAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_315() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_380() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOUBLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_314() {
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_313() {
    if (jj_scan_token(SHORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(SHORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_312() {
    if (jj_scan_token(BOOL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_311() {
    if (jj_scan_token(WCHAR_T)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_310() {
    if (jj_scan_token(CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_309() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) {
    jj_scanpos = xsp;
    if (jj_3R_380()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_379() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_198() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_3R_44()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_247() {
    if (jj_3R_354()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_3R_353()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_3R_352()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_425() {
    if (jj_scan_token(EXPLICIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_85()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_424() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_357() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_3R_425()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_423() {
    if (jj_scan_token(INLINE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_422() {
    if (jj_scan_token(MUTABLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_421() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_420() {
    if (jj_scan_token(STATIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_419() {
    if (jj_scan_token(REGISTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_418() {
    if (jj_scan_token(AUTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_356() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) {
    jj_scanpos = xsp;
    if (jj_3R_419()) {
    jj_scanpos = xsp;
    if (jj_3R_420()) {
    jj_scanpos = xsp;
    if (jj_3R_421()) {
    jj_scanpos = xsp;
    if (jj_3R_422()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_85()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_255() {
    if (jj_scan_token(TYPEDEF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_scan_token(FRIEND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_253() {
    if (jj_3R_357()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_252() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_251() {
    if (jj_3R_356()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_408() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_407() {
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_406() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_405() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_404() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_403() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_402() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_401() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_400() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_399() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_346() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) {
    jj_scanpos = xsp;
    if (jj_3R_400()) {
    jj_scanpos = xsp;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) {
    jj_scanpos = xsp;
    if (jj_3R_408()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_3R_349()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_241() {
    if (jj_3R_348()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_240() {
    if (jj_3R_347()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_239() {
    if (jj_3R_346()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_602() {
    if (jj_3R_586()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(EXPORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_601() {
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_600() {
    if (jj_3R_612()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_599() {
    if (jj_3R_611()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_598() {
    if (jj_3R_610()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_623() {
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_597() {
    if (jj_3R_580()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_596() {
    if (jj_3R_609()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_588() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_596()) {
    jj_scanpos = xsp;
    if (jj_3R_597()) {
    jj_scanpos = xsp;
    if (jj_3R_598()) {
    jj_scanpos = xsp;
    if (jj_3R_599()) {
    jj_scanpos = xsp;
    if (jj_3R_600()) {
    jj_scanpos = xsp;
    if (jj_3R_601()) {
    jj_scanpos = xsp;
    if (jj_3R_602()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_621() {
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_623()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_613() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_287() {
    if (jj_3R_344()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_235() {
    if (jj_scan_token(BITWISEOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_234() {
    if (jj_scan_token(BITWISEXOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_233() {
    if (jj_scan_token(BITWISEANDEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_232() {
    if (jj_scan_token(SHIFTRIGHTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_440() {
    if (jj_scan_token(QUESTIONMARK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_231() {
    if (jj_scan_token(SHIFTLEFTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_230() {
    if (jj_scan_token(MINUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_229() {
    if (jj_scan_token(PLUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_224() {
    if (jj_scan_token(LOGICALOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_223()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_228() {
    if (jj_scan_token(MODEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_227() {
    if (jj_scan_token(DIVIDEEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_226() {
    if (jj_scan_token(TIMESEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_225() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_76()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_77()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_343() {
    if (jj_scan_token(LOGICALAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_342()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_238() {
    if (jj_3R_345()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_398() {
    if (jj_scan_token(BITWISEOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_397()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_237() {
    if (jj_3R_344()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_236() {
    if (jj_3R_76()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_77()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_534() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_3R_76()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_440()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_223()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_224()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_455() {
    if (jj_scan_token(BITWISEXOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_454()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_75()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_533() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_519() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_533()) {
    jj_scanpos = xsp;
    if (jj_3R_534()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_222()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_3R_342()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_343()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_579() {
    if (jj_scan_token(SHIFTRIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_3R_397()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_398()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_397() {
    if (jj_3R_454()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_455()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_578() {
    if (jj_scan_token(SHIFTLEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_454() {
    if (jj_3R_75()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_564() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_578()) {
    jj_scanpos = xsp;
    if (jj_3R_579()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_341()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(MOD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_518() {
    if (jj_3R_216()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_222()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_519()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(GREATERTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(LESSTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_608() {
    if (jj_scan_token(ARROWSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_222() {
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_31()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_607() {
    if (jj_scan_token(DOTSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_593() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_528() {
    if (jj_3R_560()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_221() {
    if (jj_3R_341()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_564()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_594() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_607()) {
    jj_scanpos = xsp;
    if (jj_3R_608()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_70()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_577() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_216()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_341() {
    if (jj_3R_70()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_30()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_500() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_29()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_560() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_577()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_516() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_594()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_563() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_510() {
    if (jj_scan_token(THROW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_220() {
    if (jj_3R_340()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_219() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_345() {
    if (jj_scan_token(THROW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_516()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_499() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_453() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_216() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_563()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_128() {
    if (jj_3R_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_127() {
    if (jj_3R_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_593()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_218() {
    if (jj_3R_339()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_217()) {
    jj_scanpos = xsp;
    if (jj_3R_218()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_217() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_297() {
    if (jj_scan_token(MOD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_614() {
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_296() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_606() {
    if (jj_scan_token(TRY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_614()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_604()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_332() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_517() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_498() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_517()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_24()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_518()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_295() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_61()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_452() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3R_498()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_609() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_497() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_496() {
    if (jj_scan_token(LOGICALNOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_495() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_494() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_294() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_493() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_492() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_451() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_492()) {
    jj_scanpos = xsp;
    if (jj_3R_493()) {
    jj_scanpos = xsp;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) {
    jj_scanpos = xsp;
    if (jj_3R_496()) {
    jj_scanpos = xsp;
    if (jj_3R_497()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_610() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(SIZEOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_329() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_620() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_396() {
    if (jj_3R_453()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_147() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_293() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_395() {
    if (jj_3R_452()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_394() {
    if (jj_scan_token(SIZEOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_340()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_445() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_393() {
    if (jj_scan_token(SIZEOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_491() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_392() {
    if (jj_3R_451()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_448() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_444() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_391() {
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_126() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_148()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_124() {
    if (jj_3R_147()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_390() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_125() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_340() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) {
    jj_scanpos = xsp;
    if (jj_3R_393()) {
    jj_scanpos = xsp;
    if (jj_3R_394()) {
    jj_scanpos = xsp;
    if (jj_3R_395()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_389() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_443() {
    if (jj_scan_token(THIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_619() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_376() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) {
    jj_scanpos = xsp;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3_125()) {
    jj_scanpos = xsp;
    if (jj_3_126()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_442() {
    if (jj_3R_449()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_490() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_331() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_450() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_490()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_491()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_123() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_292() {
    if (jj_3R_376()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_124()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_291() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_388() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_450()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_122() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_121() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_308() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_215() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_448()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_387() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_327() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_307() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_153()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_338() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_306() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_scan_token(POINTERTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_388()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_305() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_153()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_335() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_388()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(POINTERTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_51()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_153() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_304() {
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_387()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_212() {
    if (jj_scan_token(TYPEID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_330() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(TYPEID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_374() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_211() {
    if (jj_scan_token(CONST_CAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_303() {
    if (jj_3R_148()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_210() {
    if (jj_scan_token(REINTERPRET_CAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_209() {
    if (jj_scan_token(STATIC_CAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_152() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_302() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_372() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_44()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_208() {
    if (jj_scan_token(DYNAMIC_CAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_207() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_331()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_332()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_206() {
    if (jj_3R_328()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_205() {
    if (jj_3R_44()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_327()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_153()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_373() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_371() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_195() {
    if (jj_3R_261()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_290() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_375()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_619()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_620()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_595() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_441()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_289() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_374()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_194() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_288() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_371()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_372()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_430() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_479() {
    if (jj_3R_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_120() {
    if (jj_3R_145()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_441() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_375() {
    if (jj_3R_441()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_595()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_587() {
    if (jj_scan_token(EXPORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_151()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_580() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_587()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_375()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_192() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_191() {
    if (jj_scan_token(POINTERTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_190() {
    if (jj_scan_token(ARROWSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_189() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_scan_token(LOGICALOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_scan_token(LOGICALAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_scan_token(GREATERTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_scan_token(LESSTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(SHIFTRIGHTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_3R_362()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(SHIFTLEFTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(SHIFTRIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(SHIFTLEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_148()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(BITWISEOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(BITWISEANDEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_scan_token(BITWISEXOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_scan_token(MODEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_scan_token(DIVIDEEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_scan_token(TIMESEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_scan_token(MINUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(PLUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_119() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_scan_token(LOGICALNOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_scan_token(BITWISEOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_118() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_477() {
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_scan_token(BITWISEXOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(MOD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_116() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) {
    jj_scanpos = xsp;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_530() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_386() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_385() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_144()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_384() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_112() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_435() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_434()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_111() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_383() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_148()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_529() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_512() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_382() {
    if (jj_scan_token(THIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_511() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_529()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_530()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_384()) {
    jj_scanpos = xsp;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_381() {
    if (jj_3R_449()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_476() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_511()) {
    jj_scanpos = xsp;
    if (jj_3R_512()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_547() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_544() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_434() {
    if (jj_3R_476()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_3R_142()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_368() {
    if (jj_3R_434()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_435()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_280() {
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_368()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_546() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_543() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_115()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_515() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_489() {
    if (jj_scan_token(FALSETOK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_488() {
    if (jj_scan_token(TRUETOK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_427() {
    if (jj_3R_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_487() {
    Token xsp;
    if (jj_3R_515()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_515()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_486() {
    if (jj_scan_token(FLOATTWO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_485() {
    if (jj_scan_token(FLOATONE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_484() {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_483() {
    if (jj_scan_token(HEXADECIMAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_482() {
    if (jj_scan_token(DECIMAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_362() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_427()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_545() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_449() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_481()) {
    jj_scanpos = xsp;
    if (jj_3R_482()) {
    jj_scanpos = xsp;
    if (jj_3R_483()) {
    jj_scanpos = xsp;
    if (jj_3R_484()) {
    jj_scanpos = xsp;
    if (jj_3R_485()) {
    jj_scanpos = xsp;
    if (jj_3R_486()) {
    jj_scanpos = xsp;
    if (jj_3R_487()) {
    jj_scanpos = xsp;
    if (jj_3R_488()) {
    jj_scanpos = xsp;
    if (jj_3R_489()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_481() {
    if (jj_scan_token(OCTAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_541() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_574() {
    if (jj_scan_token(PUBLIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_573() {
    if (jj_scan_token(PROTECTED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_542() {
    if (jj_3R_536()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_572() {
    if (jj_scan_token(PRIVATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_536() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_572()) {
    jj_scanpos = xsp;
    if (jj_3R_573()) {
    jj_scanpos = xsp;
    if (jj_3R_574()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_527() {
    if (jj_3R_536()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_545()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_546()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_547()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_540() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_526() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_542()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_543()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_544()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_539() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_525() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_540()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_541()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_524() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_539()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_584() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_504() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_524()) {
    jj_scanpos = xsp;
    if (jj_3R_525()) {
    jj_scanpos = xsp;
    if (jj_3R_526()) {
    jj_scanpos = xsp;
    if (jj_3R_527()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_583() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_505() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_504()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_467() {
    if (jj_3R_504()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_505()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_585() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_426() {
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_467()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_370() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_369()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_3R_286()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OCTAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_139()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_138()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_439() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_478() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_438() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_437() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_139()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_436() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_138()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_582() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_369() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) {
    jj_scanpos = xsp;
    if (jj_3R_437()) {
    jj_scanpos = xsp;
    if (jj_3R_438()) {
    jj_scanpos = xsp;
    if (jj_3R_439()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_286() {
    if (jj_3R_369()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_370()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_137()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_135()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_358() {
    if (jj_3R_426()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_104() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_133()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_571() {
    if (jj_3R_586()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_103() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_130()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_131()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(EXPORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_570() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_585()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_359() {
    if (jj_3R_426()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_102() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_129()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_569() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_584()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_581() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_568() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_583()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_567() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_581()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_582()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_566() {
    if (jj_3R_580()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_565() {
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_535() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_565()) {
    jj_scanpos = xsp;
    if (jj_3R_566()) {
    jj_scanpos = xsp;
    if (jj_3R_567()) {
    jj_scanpos = xsp;
    if (jj_3R_568()) {
    jj_scanpos = xsp;
    if (jj_3R_569()) {
    jj_scanpos = xsp;
    if (jj_3R_570()) {
    jj_scanpos = xsp;
    if (jj_3R_571()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_361() {
    if (jj_3R_426()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_521() {
    if (jj_3R_536()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_520() {
    if (jj_3R_535()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_501() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_520()) {
    jj_scanpos = xsp;
    if (jj_3R_521()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_457() {
    Token xsp;
    if (jj_3R_501()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_501()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(UNION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_284() {
    if (jj_scan_token(STRUCT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_360() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_283() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_603() {
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_258() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_360()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_257() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_256() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_358()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_352() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_411()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_605() {
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_411() {
    if (jj_3R_457()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_576() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_552() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_549() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_3R_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_538() {
    if (jj_3R_575()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_576()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_575() {
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_93()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_282() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_538()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_466() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_417() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) {
    jj_scanpos = xsp;
    if (jj_3R_466()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_465() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_604() {
    if (jj_3R_613()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_562() {
    if (jj_3R_510()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_559() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_126()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TRY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_125()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_551() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_123()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_554() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_592() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_606()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_548() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_591() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_606()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_590() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_605()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_604()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_589() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_603()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_604()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_557() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_556() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_555() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_586() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_589()) {
    jj_scanpos = xsp;
    if (jj_3R_590()) {
    jj_scanpos = xsp;
    if (jj_3R_591()) {
    jj_scanpos = xsp;
    if (jj_3R_592()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_561() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_550() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_558() {
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_506() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_119()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_277() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_557()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_558()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_559()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_469() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_506()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_553() {
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_276() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_555()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_556()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_275() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_551()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_552()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_553()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_554()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_274() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_548()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_549()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_550()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_468() {
    if (jj_3R_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_81()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_532() {
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_531() {
    if (jj_3R_364()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_429() {
    if (jj_3R_468()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_364() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_428()) {
    jj_scanpos = xsp;
    if (jj_3R_429()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_428() {
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_474() {
    if (jj_3R_510()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_514() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_532()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_447() {
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_513() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_531()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_561()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_562()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_480() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) {
    jj_scanpos = xsp;
    if (jj_3R_514()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_299() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_377() {
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_446() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_480()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_480()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_378() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_301() {
    if (jj_3R_378()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_214() {
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_300() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_377()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_150() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_298() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_149() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_299()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_112()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_149()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_214()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_509() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_472() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_509()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_508() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_507() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_471() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_508()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_470() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_431() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) {
    jj_scanpos = xsp;
    if (jj_3R_471()) {
    jj_scanpos = xsp;
    if (jj_3R_472()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_273() {
    if (jj_scan_token(VOLATILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_272() {
    if (jj_scan_token(CONST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_271() {
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_270() {
    if (jj_3R_364()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_75()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_475() {
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_473() {
    if (jj_3R_364()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_363() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_269() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_363()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_268() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_73()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_267() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_270()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_433() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_432() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_367() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_432()) {
    jj_scanpos = xsp;
    if (jj_3R_433()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_366() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_365() {
    if (jj_3R_431()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_279() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_250() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_249()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_617() {
    if (jj_3R_621()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_278() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_120() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_278()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_3R_279()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_355() {
    if (jj_3R_417()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_3R_249()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_250()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_410() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_351() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_615() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_588()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_611() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3R_615()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_617()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_347() {
    if (jj_scan_token(ASM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_350() {
    if (jj_scan_token(TYPENAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_349() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_261()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_244() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_351()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_456() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_409() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_456()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_66()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_261()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_348() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_409()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_624() {
    if (jj_3R_621()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_622() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_624()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_618() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_622()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_537() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public CPPParser3rdTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[210];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x50000000,0x0,0x50000000,0x0,0x0,0x0,0x0,0x50000000,0x40000000,0x50000000,0x40000000,0x0,0x50000000,0x50000000,0x0,0x0,0x14000000,0x50000000,0x0,0x40000000,0x0,0x40000000,0x14000000,0x0,0x0,0x40000000,0x40000000,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x40000000,0x0,0x40000000,0x10000000,0x40000000,0x10000000,0x40000000,0x44000000,0x4000000,0x50000000,0x40000000,0x4000000,0x50000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50000000,0x0,0x50000000,0x50000000,0x50000000,0x0,0x0,0x50000000,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x0,0x40000000,0x40000000,0x40000000,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50000000,0x40000000,0x0,0x40000000,0x0,0x40000000,0x50000000,0x0,0x0,0x10000000,0x50000000,0x40000000,0x0,0x50000000,0x14000000,0x40000000,0x40000000,0x0,0x40000000,0x40000000,0x40000000,0x40000000,0x54000000,0x0,0x54000000,0x54000000,0x40000000,0x0,0x0,0x50000000,0x14000000,0x14000000,0x10000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x54000000,0x0,0x0,0x0,0x0,0x54000000,0x0,0x0,0x40000000,0x80000000,0x80000000,0x50000000,0x10000000,0x0,0x51000000,0x51000000,0x0,0xd0000000,0x80000000,0x80000000,0x0,0x80000000,0x0,0x0,0xd0000000,0xd0000000,0x40000000,0x0,0xd0000000,0xd0000000,0xd0000000,0x50000000,0x0,0x0,0x50000000,0x0,0x40000000,0x40000000,0x0,0x40000000,0x0,0x40000000,0x40000000,0x0,0x0,0x50000000,0x40000000,0x0,0x14000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50000000,0x50000000,0x0,0x40000000,0x0,0x80000000,0x0,0x40000000,0x50000000,0x40000000,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x40080001,0x0,0x0,0x0,0x0,0x0,0x0,0x70080000,0x0,0x70080000,0x0,0x0,0x70080000,0x0,0x0,0x0,0x0,0x70080000,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x70080000,0x0,0x0,0x70080000,0x0,0x0,0x0,0x0,0x0,0x40080000,0x0,0x70080000,0x0,0x0,0x70080000,0x0,0x0,0xc0000000,0x30000000,0xc000000,0xc000000,0x3c00000,0x300000,0x300000,0x40000,0x20000,0x10000,0x8000,0x4,0x70080000,0x7ff0,0x40080001,0x40080000,0x40080001,0x0,0x0,0x40080001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x1,0x10,0x0,0x40080001,0x0,0x0,0x0,0x0,0x0,0x40080001,0x0,0x2,0x10,0x0,0x8,0x0,0x70080000,0x0,0x0,0x40080000,0x0,0x0,0x0,0x0,0x0,0x40080000,0x0,0x40080000,0x40080000,0x8,0x0,0x0,0x70080000,0x0,0x0,0x0,0x2,0xa,0x8,0x0,0x10,0x0,0x40080000,0x10,0x0,0x10,0x0,0x40080000,0x10,0x0,0x0,0x0,0x0,0x40080000,0x10,0x2,0x70080000,0x70080000,0x0,0x40080001,0x0,0x0,0x0,0x0,0x0,0x0,0x40080001,0x40080001,0x0,0x0,0x40080000,0x40080000,0x40080000,0x40080000,0x2,0x0,0x40080000,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x70080000,0x0,0x0,0xfffffff2,0x0,0x2,0x0,0x0,0x10,0x0,0x10,0x0,0x10,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0xf0000000,0x0,0x0,0x8,0x70080000,0x0,0x2,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x90589808,0x0,0x8,0x8,0x0,0x0,0x0,0x3488801e,0x0,0x3488801e,0x0,0x0,0x3488801e,0x8,0x20800000,0x0,0x66,0x3488801e,0x0,0x0,0x0,0x0,0x0,0x66,0x0,0x0,0x0,0x0,0x0,0x8,0x6,0x18,0x0,0x4000000,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3488801e,0x0,0x0,0x3488801e,0x180,0x180,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3488801e,0x0,0x90589808,0x90589008,0x90589808,0x0,0x401000,0x8,0x401000,0x1000,0x0,0x90188000,0x0,0x0,0x88000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x90589808,0x0,0x0,0x0,0x0,0x0,0x90589808,0x0,0x0,0x0,0x8,0x90589000,0x0,0x3488801e,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x90589000,0x400000,0x0,0x3488801e,0x0,0x0,0x0,0x0,0x0,0x90589000,0x401000,0x0,0x401000,0x0,0x0,0x401000,0x0,0x401000,0x0,0x0,0x401000,0x90188000,0x0,0x0,0x401008,0x0,0x0,0x3488801e,0x3488801e,0x0,0x90589008,0x0,0x0,0x0,0x0,0x100000,0x100000,0x90589008,0x90589008,0x0,0x0,0x8,0x8,0x8,0x90589008,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3488801e,0x0,0x0,0x400015f,0x0,0x0,0x90589000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x8,0x8,0x0,0x8,0x1,0x0,0x40000,0x90588000,0x3488801e,0x90588000,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x8,0xac823e57,0x8,0x20000,0x20000,0x0,0x0,0x0,0x5d024c18,0x0,0x5d024c18,0x0,0x0,0x5d024c18,0x20008,0x41000000,0x0,0x0,0x5d024c18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x20000,0x0,0x5d024c18,0x0,0x0,0x5d024c18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5d024c18,0x0,0xac823e57,0xac821e55,0xac823e55,0x0,0x20801245,0x20000,0x20801245,0x20801004,0x201,0x8c020c10,0x8000000,0x8000000,0x0,0x4000400,0x810,0x8000000,0x8000000,0x0,0x0,0x0,0x8000000,0x20000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0xac823e57,0x0,0x0,0x0,0x0,0x0,0xac823e57,0x4,0x0,0x0,0x20000,0xac821e55,0x0,0x5d024c18,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x20000,0x20000,0xac821e55,0x0,0x0,0x5d024c18,0x0,0x0,0x0,0x0,0x0,0xac821e55,0x20801245,0x0,0x20801245,0x20000,0x0,0x20801245,0x0,0x20801245,0x20000,0x0,0x20801245,0x8c020c10,0x0,0x0,0x20821245,0x0,0x0,0x5d024c18,0x5d024c18,0x0,0xacf21e57,0x0,0x0,0x20000,0x0,0x80000000,0x80000000,0xacf21e57,0xacf21e57,0x0,0x0,0x20000,0x20000,0x20000,0xac821e55,0x0,0x0,0x20000,0x0,0x0,0x0,0x700000,0x0,0x0,0x0,0x720000,0x700000,0x0,0x5d024c18,0x0,0x0,0x4000,0x2,0x0,0xac821e55,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20008,0x20008,0x8,0x20000,0x0,0x0,0x0,0x8c020c10,0x5d024c18,0x8c020c10,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x2000000,0x3f80010,0x400ff42,0x3f80014,0x4000000,0x4000000,0x4000000,0x2,0x4000000,0x7f8a59c,0x0,0x7f8a59c,0x0,0x2,0x7f8a59c,0x7f80014,0x100,0x80,0x0,0x7f8a59c,0x2,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x7f8a59c,0x0,0x0,0x7f8a594,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8a59c,0x0,0x400ff42,0x400f740,0x400f740,0x800,0x5040,0x4000000,0x5040,0x0,0x1000,0x400a700,0x400,0x400,0x8000,0x0,0x2000,0x400,0x400,0x0,0x0,0x2,0x400,0x4000000,0x0,0x0,0x0,0x0,0x2,0x200,0x100,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x400ff42,0x0,0x100,0x0,0x800,0x0,0x400ff42,0x0,0x0,0x0,0x4000000,0x400f740,0x8,0x7f8a594,0x0,0x0,0x4000000,0x4000,0x0,0x0,0x0,0x4000000,0x4000000,0x4000,0x4000000,0x4000000,0x400f740,0x4000,0x8,0x7f8a594,0x0,0x0,0x0,0x0,0x0,0x400f740,0x5040,0x0,0x5040,0x4000000,0x0,0x5040,0x0,0x5040,0x4000000,0x0,0x5040,0x400a700,0x0,0x0,0x4005040,0x0,0x0,0x7f8a59c,0x7f8a59c,0x4000000,0x400ff42,0x0,0x0,0x4000000,0x0,0x200,0x200,0x400ff42,0x400ff42,0x0,0x2,0x4000000,0x4000000,0x4000000,0x400f740,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x4001000,0x0,0x0,0x7f8a59c,0x0,0x4000000,0x0,0x0,0x0,0x400f740,0x4000000,0x0,0x4000000,0x0,0x4000000,0x0,0x102,0x4000000,0x0,0x7f80014,0x7f80014,0x3f80014,0x4000000,0x0,0x0,0x0,0x400e700,0x7f8a59c,0x400e700,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[128];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public CPPParser3rd(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CPPParser3rdTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CPPParser3rd(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CPPParser3rdTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CPPParser3rd(CPPParser3rdTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CPPParser3rdTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 210; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[155];
    for (int i = 0; i < 155; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 210; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 155; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 128; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

  /*
   * Methods used in semantics predicates.
   */

  /**
   * Reads a fully qualified name (since it is used during lookahead, we
   * cannot use token. We have to explicitly use getToken).
   */
   // CHECK THIS
/*
  String getFullyScopedName()
  {
     Token t = getToken(1);

     if (t.kind != IDENTIFIER && t.kind != SCOPE)
        return null;

     StringBuffer s = new StringBuffer();

     int i;
     if (t.kind != SCOPE)
     {
        s.append(t.image);
        t = getToken(2);
        i = 3;
     }
     else
        i = 2;

     while (t.kind == SCOPE)
     {
        s.append(t.image);
        s.append((t = getToken(i++)).image);
        t = getToken(i++);
     }

     return s.toString();
  }
*/
  /**
   * This method first tries to read a sequence of tokens of the form
   *             (<SCOPE>)? identifier() (<SCOPE> identifier())*
   * and if it succeeds then asks the symbol table manager  if this is
   * the name of a constructor.
   */
/*
  boolean isCtor()
  {
      return sym.isCtor(getFullyScopedName());
  }
*/
}
