// Copyright 2000, CERN, Geneva, Switzerland and SLAC, Stanford, California, U.S.A.
package org.freehep.jaco.generator;

import java.io.*;

import org.freehep.jaco.rtti.*;

/**
 * @author Mark Donszelmann
 * @version $Id: JavaInterface.java,v 1.1.1.1 2004/05/31 05:08:51 kuromaru Exp $
 */
public class JavaInterface extends AbstractGenerator
{
    protected final static String language = "java";

    public JavaInterface() {
        super();
    }

    public String directory(IClass clazz)
    {
        String directory = clazz.getPackageName(packagePrefix);
        return directory.replace('.',File.separatorChar);
    }

    public String filename(IClass clazz)
    {
        return clazz.getName()+".java";
    }

    public boolean print(PrintWriter out, IClass clazz)
    {
        this.out = out;

        warning();

        if (!clazz.getPackageName(packagePrefix).equals("")) {
            out.println("package "+clazz.getPackageName(packagePrefix)+";");
            out.println();
        }

        String[] comments = clazz.getComments(language);
        for (int i=0; i<comments.length; i++)
        {
            out.println(comments[i]);
        }
        out.println();

        out.print("public interface "+clazz.getName()+" extends org.freehep.jaco.CPPUtil");

        String[] interfaces = clazz.getInterfaces();
        for (int i=0; i<interfaces.length; i++)
        {
            out.print(", "+interfaces[i]);
        }

        out.println();
        out.println("{");

        IMethod[] methods = clazz.getMethods();
        for (int i=0; i<methods.length; i++)
        {
            if (!methods[i].isStatic()) printMethod(methods[i]);
        }
        out.println("}");

        return false;
    }

    protected void printMethodHeader(IMethod method)
    {
        String[] comments = method.getComments(language);
        for (int i=0; i<comments.length; i++) out.println(comments[i]);

        INamedType[] parameterTypes = method.getParameterTypes();
        String[] exceptionTypes = method.getExceptionTypes();

        out.print("   public ");
        out.print(type(method.getReturnType()));
        out.print(" ");
        out.print(method.getName());
        out.print("(");

        for (int i=0; i<parameterTypes.length; i++)
        {
            out.print(namedType(parameterTypes[i]));
            if (i<parameterTypes.length-1) out.print(", ");
        }
        out.print(")");

        if (exceptionTypes.length > 0)
        {
            out.print(" throws ");
            for (int i=0; i<exceptionTypes.length; i++)
            {
                out.print(exceptionTypes[i]);
                if (i<exceptionTypes.length-1) out.print(", ");
            }
        }
    }

    private void printMethod(IMethod method)
    {
        printMethodHeader(method);
        out.println(";");
    }
    protected String namedType(INamedType namedType)
    {
        return type(namedType.getType())+" "+namedType.getName();
    }
    protected String type(IType type)
    {
        StringBuffer s = new StringBuffer(type.getName());
        for (int i=0; i<type.getDimension(); i++) s.append("[]");
        return s.toString();
    }
}
