package org.freehep.application;

/**
 *
 * @author tonyj
 */
class PrintOptions extends javax.swing.JPanel
{
   /** Creates new form JPanel */
   PrintOptions(PrintHelper helper)
   {
      this.helper = helper;
      initComponents();
   }

   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      java.awt.GridBagConstraints gridBagConstraints;
      javax.swing.JPanel jPanel1;
      javax.swing.JPanel jPanel2;

      buttonGroup1 = new javax.swing.ButtonGroup();
      jPanel2 = new javax.swing.JPanel();
      scaleUp = new javax.swing.JCheckBox();
      portrait = new javax.swing.JRadioButton();
      landscape = new javax.swing.JRadioButton();
      bestFit = new javax.swing.JRadioButton();
      jPanel1 = new javax.swing.JPanel();
      pageBorder = new javax.swing.JCheckBox();
      hasHeader = new javax.swing.JCheckBox();
      header = new javax.swing.JTextField();
      hasFooter = new javax.swing.JCheckBox();
      footer = new javax.swing.JTextField();

      setLayout(new java.awt.GridBagLayout());

      jPanel2.setLayout(new java.awt.GridBagLayout());

      jPanel2.setBorder(new javax.swing.border.TitledBorder("Page Layout"));
      scaleUp.setMnemonic('E');
      scaleUp.setSelected(helper.getScaleUp());
      scaleUp.setText("Enlarge to fill page");
      scaleUp.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            scaleUpActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add(scaleUp, gridBagConstraints);

      portrait.setMnemonic('P');
      portrait.setSelected(helper.getOrientation() == helper.ORIENTATION_PORTRAIT);
      portrait.setText("Portrait");
      buttonGroup1.add(portrait);
      portrait.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            portraitActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add(portrait, gridBagConstraints);

      landscape.setMnemonic('L');
      landscape.setSelected(helper.getOrientation() == helper.ORIENTATION_LANDSCAPE);
      landscape.setText("Landscape");
      buttonGroup1.add(landscape);
      landscape.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            landscapeActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add(landscape, gridBagConstraints);

      bestFit.setMnemonic('B');
      bestFit.setSelected(helper.getOrientation() == helper.ORIENTATION_BEST_FIT);
      bestFit.setText("Best Fit");
      buttonGroup1.add(bestFit);
      bestFit.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            bestFitActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add(bestFit, gridBagConstraints);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
      add(jPanel2, gridBagConstraints);

      jPanel1.setLayout(new java.awt.GridBagLayout());

      jPanel1.setBorder(new javax.swing.border.TitledBorder("Page Border"));
      pageBorder.setMnemonic('P');
      pageBorder.setSelected(helper.isDrawBorder());
      pageBorder.setText("Page Border");
      pageBorder.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            pageBorderActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel1.add(pageBorder, gridBagConstraints);

      hasHeader.setMnemonic('H');
      hasHeader.setSelected(helper.isShowHeader());
      hasHeader.setText("Header");
      hasHeader.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            hasHeaderActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel1.add(hasHeader, gridBagConstraints);

      header.setColumns(20);
      header.setText(helper.getHeader());
      header.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            headerActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel1.add(header, gridBagConstraints);

      hasFooter.setMnemonic('F');
      hasFooter.setSelected(helper.isShowFooter());
      hasFooter.setText("Footer");
      hasFooter.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            hasFooterActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      jPanel1.add(hasFooter, gridBagConstraints);

      footer.setColumns(20);
      footer.setText(helper.getFooter());
      footer.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            footerActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel1.add(footer, gridBagConstraints);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
      add(jPanel1, gridBagConstraints);

   }//GEN-END:initComponents

   private void footerActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_footerActionPerformed
   {//GEN-HEADEREND:event_footerActionPerformed
      helper.setFooter(footer.getText());
   }//GEN-LAST:event_footerActionPerformed

   private void headerActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_headerActionPerformed
   {//GEN-HEADEREND:event_headerActionPerformed
      helper.setHeader(header.getText());
   }//GEN-LAST:event_headerActionPerformed

   private void hasFooterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_hasFooterActionPerformed
   {//GEN-HEADEREND:event_hasFooterActionPerformed
      helper.setShowFooter(hasFooter.isSelected());
   }//GEN-LAST:event_hasFooterActionPerformed

   private void hasHeaderActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_hasHeaderActionPerformed
   {//GEN-HEADEREND:event_hasHeaderActionPerformed
      helper.setShowHeader(hasHeader.isSelected());
   }//GEN-LAST:event_hasHeaderActionPerformed

   private void pageBorderActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_pageBorderActionPerformed
   {//GEN-HEADEREND:event_pageBorderActionPerformed
      helper.setDrawBorder(pageBorder.isSelected());
   }//GEN-LAST:event_pageBorderActionPerformed

   private void bestFitActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_bestFitActionPerformed
   {//GEN-HEADEREND:event_bestFitActionPerformed
      helper.setOrientation(helper.ORIENTATION_BEST_FIT);
   }//GEN-LAST:event_bestFitActionPerformed

   private void landscapeActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_landscapeActionPerformed
   {//GEN-HEADEREND:event_landscapeActionPerformed
      helper.setOrientation(helper.ORIENTATION_LANDSCAPE);
   }//GEN-LAST:event_landscapeActionPerformed

   private void portraitActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_portraitActionPerformed
   {//GEN-HEADEREND:event_portraitActionPerformed
      helper.setOrientation(helper.ORIENTATION_PORTRAIT);
   }//GEN-LAST:event_portraitActionPerformed

   private void scaleUpActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_scaleUpActionPerformed
   {//GEN-HEADEREND:event_scaleUpActionPerformed
      helper.setScaleUp(scaleUp.isSelected());
   }//GEN-LAST:event_scaleUpActionPerformed


   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JRadioButton bestFit;
   private javax.swing.ButtonGroup buttonGroup1;
   private javax.swing.JTextField footer;
   private javax.swing.JCheckBox hasFooter;
   private javax.swing.JCheckBox hasHeader;
   private javax.swing.JTextField header;
   private javax.swing.JRadioButton landscape;
   private javax.swing.JCheckBox pageBorder;
   private javax.swing.JRadioButton portrait;
   private javax.swing.JCheckBox scaleUp;
   // End of variables declaration//GEN-END:variables
   private PrintHelper helper;
}
