/*
 * SGStartupFigurePropertySettingDialog.java
 *
 * Created on 2004/10/15, 14:01
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGStartupFigurePropertySettingDialog extends SGWizardDialog
{

	/** Creates new form SGStartupFigurePropertySettingDialog */
	public SGStartupFigurePropertySettingDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /** Creates new form SGStartupFigurePropertySettingDialog */
    public SGStartupFigurePropertySettingDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mFigurePanel = new javax.swing.JPanel();
        mWidthLabel = new javax.swing.JLabel();
        mHeightLabel = new javax.swing.JLabel();
        mWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mHeightSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLocationLabel = new javax.swing.JLabel();
        mSizeLabel = new javax.swing.JLabel();
        mXLabel = new javax.swing.JLabel();
        mXSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mYLabel = new javax.swing.JLabel();
        mYSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSpaceLabel = new javax.swing.JLabel();
        mSpaceLineAndScaleLabel = new javax.swing.JLabel();
        mSpaceScaleAndTitleLabel = new javax.swing.JLabel();
        mSpaceLineAndScaleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSpaceScaleAndTitleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBackgroundColorLabel = new javax.swing.JLabel();
        mBackgroundColorButton = new javax.swing.JButton();
        mLegendVisibleCheckBox = new javax.swing.JCheckBox();
        mLegendVisibleLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mSizeSeparator = new javax.swing.JSeparator();
        mSpaceSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mTransparentCheckBox = new javax.swing.JCheckBox();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mFigurePanel.setLayout(new java.awt.GridBagLayout());

        mFigurePanel.setBorder(new javax.swing.border.EtchedBorder());
        mWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mWidthLabel, gridBagConstraints);

        mHeightLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightLabel.setText("Height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mHeightLabel, gridBagConstraints);

        mWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mWidthSpinner, gridBagConstraints);

        mHeightSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mHeightSpinner, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mFigurePanel.add(mLocationLabel, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSizeLabel, gridBagConstraints);

        mXLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mXLabel, gridBagConstraints);

        mXSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mXSpinner, gridBagConstraints);

        mYLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mYLabel, gridBagConstraints);

        mYSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mYSpinner, gridBagConstraints);

        mSpaceLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSpaceLabel.setText("Space");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceLabel, gridBagConstraints);

        mSpaceLineAndScaleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mSpaceLineAndScaleLabel, gridBagConstraints);

        mSpaceScaleAndTitleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mSpaceScaleAndTitleLabel, gridBagConstraints);

        mSpaceLineAndScaleSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceLineAndScaleSpinner, gridBagConstraints);

        mSpaceScaleAndTitleSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceScaleAndTitleSpinner, gridBagConstraints);

        mBackgroundColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mBackgroundColorLabel, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mFigurePanel.add(mBackgroundColorButton, gridBagConstraints);

        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mLegendVisibleLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLegendVisibleLabel.setText("Legend ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mLegendVisibleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 60, 0, 0);
        mFigurePanel.add(mLocationSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        mFigurePanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 48, 0, 0);
        mFigurePanel.add(mSpaceSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        mFigurePanel.add(mColorSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mFigurePanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mFigurePanel.add(mRightSpaceLabel, gridBagConstraints);

        mTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mFigurePanel.add(mTransparentCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mFigurePanel, gridBagConstraints);

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mPreviousButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JPanel mFigurePanel;
    private javax.swing.JLabel mHeightLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mHeightSpinner;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JCheckBox mLegendVisibleCheckBox;
    private javax.swing.JLabel mLegendVisibleLabel;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JLabel mSpaceLabel;
    private javax.swing.JLabel mSpaceLineAndScaleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceLineAndScaleSpinner;
    private javax.swing.JLabel mSpaceScaleAndTitleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceScaleAndTitleSpinner;
    private javax.swing.JSeparator mSpaceSeparator;
    private javax.swing.JCheckBox mTransparentCheckBox;
    private javax.swing.JLabel mWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mWidthSpinner;
    private javax.swing.JLabel mXLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mXSpinner;
    private javax.swing.JLabel mYLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mYSpinner;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGFigureDialog.TITLE );


		this.mNextButton.setEnabled( false );


		//
		// Xsi[f̐ݒ
		//

		this.mXSpinner.setDigitForRoundingOut(-2);
		this.mXSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -50.0, 50.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_CM	);
		this.mXSpinner.setMinimumFractionDigits(1);
		this.mXSpinner.setMaximumFractionDigits(1);

		this.mYSpinner.setDigitForRoundingOut(-2);
		this.mYSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -50.0, 50.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_CM	);
		this.mYSpinner.setMinimumFractionDigits(1);
		this.mYSpinner.setMaximumFractionDigits(1);

		this.mWidthSpinner.setDigitForRoundingOut(-2);
		this.mWidthSpinner.initProperties(
			new SpinnerNumberModel( 10.0, 1.0, 50.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_CM	);
		this.mWidthSpinner.setMinimumFractionDigits(1);
		this.mWidthSpinner.setMaximumFractionDigits(1);

		this.mHeightSpinner.setDigitForRoundingOut(-2);
		this.mHeightSpinner.initProperties(
			new SpinnerNumberModel( 10.0, 1.0, 50.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_CM	);
		this.mHeightSpinner.setMinimumFractionDigits(1);
		this.mHeightSpinner.setMaximumFractionDigits(1);

		this.mSpaceLineAndScaleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, 0.0, 5.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );

		this.mSpaceScaleAndTitleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, 0.0, 5.0, 0.01 ),
			SGSpinner.SPINNER_UNIT_CM );


		// FύX{^ɃANVXiǉ
		this.mBackgroundColorButton.addActionListener(this);


		//
		this.mTransparentCheckBox.addActionListener(this);


this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);


		return true;
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}



	/**
	 * 
	 */
	public Number getFigureX()
	{
		return this.mXSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureY()
	{
		return this.mYSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureWidth()
	{
		return this.mWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureHeight()
	{
		return this.mHeightSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getSpaceLineAndNumber()
	{
		return this.mSpaceLineAndScaleSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getSpaceNumberAndTitle()
	{
		return this.mSpaceScaleAndTitleSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getFigureBackgroundColor()
	{
		return this.mBackgroundColorButton.getBackground();
	}

	/**
	 * 
	 * @return
	 */
	public boolean getFigureTransparentFlag()
	{
		return this.mTransparentCheckBox.isSelected();
	}

	/**
	 * 
	 */
	public boolean getFigureLegendVisible()
	{
		return this.mLegendVisibleCheckBox.isSelected();
	}




	/**
	 * 
	 */
	public boolean setFigureX( final float x )
	{
		this.mXSpinner.setValue( new Double( x ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureY( final float y )
	{
		this.mYSpinner.setValue( new Double( y ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureWidth( final float w )
	{
		this.mWidthSpinner.setValue( new Double( w ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureHeight( final float h )
	{
		this.mHeightSpinner.setValue( new Double( h ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureSpaceLineAndNumber( final float space )
	{
		this.mSpaceLineAndScaleSpinner.setValue( new Double( space ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureSpaceNumberAndTitle( final float space )
	{
		this.mSpaceScaleAndTitleSpinner.setValue( new Double( space ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setBackground( cl );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureTransparentFlag( final boolean b )
	{
		this.mTransparentCheckBox.setSelected(b);
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureLegendVisible( final boolean flag )
	{
		this.mLegendVisibleCheckBox.setSelected(flag);
		return true;
	}


}
