/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;

public class SGTimingLineDialog
extends SGPropertyDialog {
    public static final String TITLE = "Timing Line Dialog";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JLabel mLeftSpaceLabel;
    private JButton mLineColorButton;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JPanel mTimingLinePanel;
    private JLabel mTimingValueLabel;
    private JTextField mTimingValueTextField;

    public SGTimingLineDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTimingLinePanel = new JPanel();
        this.mTimingValueLabel = new JLabel();
        this.mLineTypeLabel = new JLabel();
        this.mLineWidthLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mTimingValueTextField = new JTextField();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorButton = new JButton();
        this.mLineTypeComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGTimingLineDialog.this.closeDialog(windowEvent);
            }
        });
        this.mTimingLinePanel.setLayout(new GridBagLayout());
        this.mTimingLinePanel.setBorder(new BevelBorder(0));
        this.mTimingLinePanel.setFont(new Font("MS Sans Serif", 0, 10));
        this.mTimingValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mTimingValueLabel.setText("Value");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueLabel, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTimingLinePanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mTimingValueTextField.setColumns(6);
        this.mTimingValueTextField.setPreferredSize(new Dimension(59, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueTextField, gridBagConstraints);
        this.mLineWidthSpinner.setMinimumSize(new Dimension(65, 20));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mLineTypeComboBox.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTimingLinePanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = new String[]{"Solid", "Broken", "Dotted"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mLineTypeComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mLineColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        this.mTimingValueTextField.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public String getTimingValueString() {
        return this.mTimingValueTextField.getText();
    }

    public boolean setTiminValueString(double d) {
        this.mTimingValueTextField.setText(new Double(d).toString());
        return true;
    }

    public boolean setLineType(int n) {
        String string = SGDrawingElementLine.getLineTypeName(n);
        this.mLineTypeComboBox.setSelectedItem(string);
        return true;
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        if (n == null) {
            throw new Error();
        }
        return n;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setLineColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public ArrayList getLineColorList() {
        Color color = this.mLineColorButton.getBackground();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(color);
        return arrayList;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mTimingValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = null;
        actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            this.mTimingValueTextField.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGElementGroupLine.LineProperties getLineProperties() {
        SGElementGroupLine.LineProperties lineProperties = new SGElementGroupLine.LineProperties();
        Number number = this.getLineWidth();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        lineProperties.setLineWidth(number.floatValue());
        lineProperties.setLineType(this.getLineType());
        lineProperties.setColorList(this.getLineColorList());
        return lineProperties;
    }
}

