/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGDrawingElementSymbol
extends SGDrawingElement {
    protected SGTuple2f mLocation = new SGTuple2f();
    protected float mSize;
    protected int mType;
    protected float mAngle;
    protected Color mLineColor;
    protected float mLineWidth;
    public static final int SYMBOL_TYPE_VOID = -1;
    public static final int SYMBOL_TYPE_CIRCLE = 0;
    public static final int SYMBOL_TYPE_SQUARE = 1;
    public static final int SYMBOL_TYPE_TRIANGLE = 2;
    public static final int SYMBOL_TYPE_INVERTEDTRIANGLE = 3;
    public static final int SYMBOL_TYPE_CROSS = 4;
    public static final int SYMBOL_TYPE_PLUS = 5;
    public static final int SYMBOL_TYPE_TRANSVERSELINE = 6;
    public static final String SYMBOL_VOID = "No Symbol";
    public static final String SYMBOL_CIRCLE = "Circle";
    public static final String SYMBOL_SQUARE = "Square";
    public static final String SYMBOL_TRIANGLE = "Triangle";
    public static final String SYMBOL_INVERTED_TRIANGLE = "I-Triangle";
    public static final String SYMBOL_CROSS = "Cross";
    public static final String SYMBOL_PLUS = "Plus";
    public static final String SYMBOL_TRANSVERSELINE = "Transverse Line";
    public static final String KEY_SYMBOL_SIZE = "Size";
    public static final String KEY_SYMBOL_TYPE = "Type";
    public static final String KEY_LINE_WIDTH = "Edge Line Width";
    public static final String KEY_LINE_COLOR = "Edge Line Color";
    public static final String PF_SYMBOL_COLOR_LIST = "Inner Color List";

    public boolean setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
        return true;
    }

    public boolean setSize(float f) {
        this.mSize = f;
        return true;
    }

    public boolean setType(int n) {
        this.mType = n;
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.mLocation);
    }

    public float getX() {
        return this.mLocation.x;
    }

    public float getY() {
        return this.mLocation.y;
    }

    public float getSize() {
        return this.mSize;
    }

    public int getType() {
        return this.mType;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public static Integer getSymbolTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals(SYMBOL_VOID)) {
            n = -1;
        } else if (string.equals(SYMBOL_CIRCLE)) {
            n = 0;
        } else if (string.equals(SYMBOL_SQUARE)) {
            n = 1;
        } else if (string.equals(SYMBOL_TRIANGLE)) {
            n = 2;
        } else if (string.equals(SYMBOL_INVERTED_TRIANGLE)) {
            n = 3;
        } else if (string.equals(SYMBOL_CROSS)) {
            n = 4;
        } else if (string.equals(SYMBOL_PLUS)) {
            n = 5;
        } else if (string.equals(SYMBOL_TRANSVERSELINE)) {
            n = 6;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = SYMBOL_VOID;
                break;
            }
            case 0: {
                string = SYMBOL_CIRCLE;
                break;
            }
            case 1: {
                string = SYMBOL_SQUARE;
                break;
            }
            case 2: {
                string = SYMBOL_TRIANGLE;
                break;
            }
            case 3: {
                string = SYMBOL_INVERTED_TRIANGLE;
                break;
            }
            case 4: {
                string = SYMBOL_CROSS;
                break;
            }
            case 5: {
                string = SYMBOL_PLUS;
                break;
            }
            case 6: {
                string = SYMBOL_TRANSVERSELINE;
                break;
            }
        }
        return string;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        symbolProperties.angle = this.getAngle();
        return true;
    }

    public static class SymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        double angle;
        public static final String[] keys = new String[]{"Type", "Size", "Edge Line Width", "Edge Line Color"};

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(symbolProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return symbolProperties.angle == this.angle;
        }

        public Float getSize() {
            String string = this.getProperty(SGDrawingElementSymbol.KEY_SYMBOL_SIZE);
            return SGUtilityText.getFloat(string);
        }

        public Integer getSymbolType() {
            String string = this.getProperty(SGDrawingElementSymbol.KEY_SYMBOL_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public Float getLineWidth() {
            String string = this.getProperty(SGDrawingElementSymbol.KEY_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Color getLineColor() {
            String string = this.getProperty(SGDrawingElementSymbol.KEY_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public boolean setSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingElementSymbol.KEY_SYMBOL_SIZE, new Float(f).toString());
            return true;
        }

        public boolean setSymbolType(int n) {
            this.setProperty(SGDrawingElementSymbol.KEY_SYMBOL_TYPE, new Integer(n).toString());
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingElementSymbol.KEY_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGDrawingElementSymbol.KEY_LINE_COLOR, string);
            return true;
        }
    }
}

