/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EtchedBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public class SGScrollPaneDialog
extends SGDialog
implements AdjustmentListener {
    protected JPanel mButtonPanel;
    protected JButton mCancelButton;
    protected JScrollPane mDetailScrollPane;
    protected JTextArea mDetailTextArea;
    protected JEditorPane mMessageEditorPane;
    protected JButton mOKButton;
    protected JPanel mPanel;
    private boolean mCanceledFlag = false;
    private boolean mTempFlag = false;

    public SGScrollPaneDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGScrollPaneDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGScrollPaneDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mMessageEditorPane = new JEditorPane();
        this.mDetailScrollPane = new JScrollPane();
        this.mDetailTextArea = new JTextArea();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(9, 6, 4, 6);
        this.mPanel.add((Component)this.mButtonPanel, gridBagConstraints);
        this.mMessageEditorPane.setEditable(false);
        this.mMessageEditorPane.setPreferredSize(new Dimension(304, 48));
        this.mMessageEditorPane.setOpaque(false);
        this.mPanel.add((Component)this.mMessageEditorPane, new GridBagConstraints());
        this.mDetailScrollPane.setPreferredSize(new Dimension(304, 104));
        this.mDetailTextArea.setEditable(false);
        this.mDetailScrollPane.setViewportView(this.mDetailTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.mPanel.add((Component)this.mDetailScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
        this.getVerticalScrollBar().addAdjustmentListener(this);
        return true;
    }

    public boolean setMessage(String string) {
        this.mMessageEditorPane.setText(string);
        return true;
    }

    public String getMessage() {
        return this.mMessageEditorPane.getText();
    }

    public boolean setDetailText(String string) {
        this.mDetailTextArea.setText(string);
        return true;
    }

    public String getDetailText() {
        return this.mDetailTextArea.getText();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.mDetailScrollPane.getVerticalScrollBar();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.mDetailScrollPane.getHorizontalScrollBar();
    }

    public JViewport getViewport() {
        return this.mDetailScrollPane.getViewport();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }

    protected boolean onOK() {
        this.mCanceledFlag = false;
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.mCanceledFlag = true;
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }

    public boolean isCanceled() {
        return this.mCanceledFlag;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.mTempFlag) {
            JViewport jViewport = this.getViewport();
            jViewport.setViewPosition(new Point());
            this.mTempFlag = false;
        }
    }

    public void setVisible(boolean bl) {
        this.mTempFlag = true;
        super.setVisible(bl);
    }
}

