/*
 * SGAxisBreakSymbolDialog.java
 *
 * Created on 2004/09/30, 11:02
 */

package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;

/**
 *
 * @author  kuromaru
 */
public class SGAxisBreakSymbolDialog extends SGPropertyDialog
{

	public static final String TITLE = "Axis Break Symbol";


    /** Creates new form SGAxisBreakSymbolDialog */
    public SGAxisBreakSymbolDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mDistortionLabel = new javax.swing.JLabel();
        mAngleLabel = new javax.swing.JLabel();
        mDistortionSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSizeLabel = new javax.swing.JLabel();
        mFormLabel = new javax.swing.JLabel();
        mLengthLabel = new javax.swing.JLabel();
        mLengthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mIntervalLabel = new javax.swing.JLabel();
        mIntervalSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mInnerColorButton = new javax.swing.JButton();
        mSizeSeparator = new javax.swing.JSeparator();
        mFormSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new javax.swing.JButton();
        mInnerColorLabel = new javax.swing.JLabel();
        mHorizontalRadioButton = new javax.swing.JRadioButton();
        mVerticalRadioButton = new javax.swing.JRadioButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mDistortionLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mDistortionLabel.setText("Distortion");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mDistortionLabel, gridBagConstraints);

        mAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mAngleLabel, gridBagConstraints);

        mDistortionSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mDistortionSpinner, gridBagConstraints);

        mAngleSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mAngleSpinner, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mPanel.add(mSizeLabel, gridBagConstraints);

        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        mLengthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLengthLabel.setText("Length");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLengthLabel, gridBagConstraints);

        mLengthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLengthSpinner, gridBagConstraints);

        mIntervalLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalLabel.setText("Interval");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mIntervalLabel, gridBagConstraints);

        mIntervalSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mIntervalSpinner, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mColorLabel, gridBagConstraints);

        mInnerColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mPanel.add(mInnerColorButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 60, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mPanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mPanel.add(mFormSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mPanel.add(mColorSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mLineColorButton, gridBagConstraints);

        mInnerColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerColorLabel.setText("Inner");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mInnerColorLabel, gridBagConstraints);

        mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mHorizontalRadioButton, gridBagConstraints);

        mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mVerticalRadioButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mAngleSpinner;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JLabel mDistortionLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mDistortionSpinner;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JRadioButton mHorizontalRadioButton;
    private javax.swing.JButton mInnerColorButton;
    private javax.swing.JLabel mInnerColorLabel;
    private javax.swing.JLabel mIntervalLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mIntervalSpinner;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLengthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLengthSpinner;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JRadioButton mVerticalRadioButton;
    // ϐ錾̏I//GEN-END:variables




	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGAxisBreakSymbolDialog.TITLE );


		//
		// set the spinner model
		//

		// length
		this.mLengthSpinner.initProperties(
			new SpinnerNumberModel( 0.50, 0.50, 2.0, 0.10 ),
			SGSpinner.SPINNER_UNIT_CM );

		// interval
		this.mIntervalSpinner.initProperties(
			new SpinnerNumberModel( 0.50, 0.10, 2.0, 0.10 ),
			SGSpinner.SPINNER_UNIT_CM );

		// distortion
		this.mDistortionSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -1.0, 1.0, 0.10 ),
			null );

		// angle
		final float max = SGAxisBreakingSymbol.ANGLE_ABS_MAX/(float)(Math.PI/180.0);
		this.mAngleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -max, max, 1.0 ),
			SGSpinner.SPINNER_UNIT_DEGREE );

		// line width
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		//
		// create a radio-button-group
		//
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mHorizontalRadioButton );
			group.add( this.mVerticalRadioButton );
		}


		//
		// add action listeners
		//

{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}

		this.mLineColorButton.addActionListener(this);
		this.mInnerColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


		return true;
	}



	/**
	 * 
	 * @return
	 */
	public Number getLength()
	{
		return this.mLengthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getInterval()
	{
		return this.mIntervalSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getDistortion()
	{
		return this.mDistortionSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getAngle()
	{
		return this.mAngleSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Boolean isHorizontal()
	{
		return new Boolean( this.mHorizontalRadioButton.isSelected() );
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getBackground();
	}


	/**
	 * 
	 * @return
	 */
	public Color getInnerColor()
	{
		return this.mInnerColorButton.getBackground();
	}



	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLength( final Object obj )
	{
		if( obj==null )
		{
			this.mLengthSpinner.setText("");
			return false;
		}
		Float value = null;
		try
		{
			value = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mLengthSpinner.setValue( value );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setInterval( final Object obj )
	{
		if( obj==null )
		{
			this.mIntervalSpinner.setText("");
			return false;
		}
		Float value = null;
		try
		{
			value = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mIntervalSpinner.setValue( value );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setDistortion( final Object obj )
	{
		if( obj==null )
		{
			this.mDistortionSpinner.setText("");
			return false;
		}
		Float value = null;
		try
		{
			value = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mDistortionSpinner.setValue( value );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setAngle( final Object obj )
	{
		if( obj==null )
		{
			this.mAngleSpinner.setText("");
			return false;
		}
		Float value = null;
		try
		{
			value = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mAngleSpinner.setValue( value );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLineWidth( final Object obj )
	{
		if( obj==null )
		{
			this.mLineWidthSpinner.setText("");
			return false;
		}
		Float value = null;
		try
		{
			value = Float.valueOf( obj.toString() );
		}
		catch( NumberFormatException ex )
		{
			return false;
		}
		this.mLineWidthSpinner.setValue( value );
		return true;
	}



	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean setHorizontal( final boolean flag )
	{
		this.mHorizontalRadioButton.setSelected( flag );
		this.mVerticalRadioButton.setSelected( !flag );

		return true;
	}



	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setLineColor( final Color c )
	{
		this.mLineColorButton.setBackground(c);
		return true;
	}


	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setInnerColor( final Color c )
	{
		this.mInnerColorButton.setBackground(c);
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		ArrayList list = new ArrayList();
		return list;
	}


	/**
	 * 
	 */    
	public ArrayList getColorSelectionComponentList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineColorButton );
		list.add( this.mInnerColorButton );
		return list;
	}


	/**
	 * 
	 */    
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLengthSpinner );
		list.add( this.mIntervalSpinner );
		list.add( this.mDistortionSpinner );
		list.add( this.mAngleSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}
    
    
    
	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener l )
	{
		this.mOKButton.addActionListener(l);
		this.mCancelButton.addActionListener(l);
		this.mPreviewButton.addActionListener(l);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener(l);
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGAxisBreakingSymbol.AxisBreakSymbolProperties getProperties()
	{
		SGAxisBreakingSymbol.AxisBreakSymbolProperties p
			= new SGAxisBreakingSymbol.AxisBreakSymbolProperties();

		// length
		final Number len = this.getLength();
		if( len==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLength( len.floatValue()/SGConstants.CM_POINT_RATIO );
		}


		// interval
		final Number interval = this.getInterval();
		if( interval==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setInterval( interval.floatValue()/SGConstants.CM_POINT_RATIO );
		}


		// distortion
		final Number distortion = this.getDistortion();
		if( distortion==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setDistortion( distortion.floatValue() );
		}


		// angle
		final Number angle = this.getAngle();
		if( angle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setAngle( angle.floatValue()*(float)((Math.PI)/180.0) );
		}


		// line width
		final Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineWidth( lineWidth.floatValue() );
		}


		// horizontal
		final Boolean horizontal = this.isHorizontal();
		if( horizontal==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setHorizontal( horizontal.booleanValue() );
		}


		// line color
		final Color lc = this.getLineColor();
		p.setLineColor(lc);
		
		
		// inner color
		final Color ic = this.getInnerColor();
		p.setColor(ic);


		return p;
	}



}

