/*
 * SGPropertyFileChooserWizardDialog.java
 *
 * Created on 2004/06/29, 16:31
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;
import jp.riken.brain.ni.samuraigraph.figure.java2d.*;


/**
 *
 * @author  kuromaru
 */
public class SGPropertyFileChooserWizardDialog extends SGFileChooserWizardDialog implements CaretListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Choose a property file.";


    /** Creates new form SGPropertyFileChooserWizardDialog */
    public SGPropertyFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mDataFileNameTextField = new javax.swing.JTextField();
        mShowFileChooserButton = new javax.swing.JButton();
        mButtonPanel = new javax.swing.JPanel();
        mNextButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mDataFileNameTextField.setPreferredSize(new java.awt.Dimension(250, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mDataFileNameTextField, gridBagConstraints);

        mShowFileChooserButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mShowFileChooserButton.setText("Choose");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mPanel.add(mShowFileChooserButton, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mNextButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new SGPropertyFileChooserWizardDialog(new javax.swing.JFrame(), true).show();
    }
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JTextField mDataFileNameTextField;
    private javax.swing.JButton mNextButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mShowFileChooserButton;
    // ϐ錾̏I//GEN-END:variables



    
	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGPropertyFileChooserWizardDialog.TITLE );


		//
		this.setResizable(false);


		//
		this.mCancelButton.addActionListener(this);
//		this.mPreviousButton.addActionListener(this);
		this.mNextButton.addActionListener(this);

		this.mNextButton.setEnabled(false);


		//
		this.mShowFileChooserButton.addActionListener(this);

		this.mDataFileNameTextField.addCaretListener(this);


		return true;

	}


	/**
	 * 
	 */
	public String getFileName()
	{
		return this.mDataFileNameTextField.getText();
	}


	/**
	 * 
	 */
	public boolean setFileName( final String pathName )
	{
		this.mDataFileNameTextField.setText( pathName );
		return true;
	}


	/**
	 * 
	 */
	public File getSelectedFile()
	{
		File file = new File( this.getFileName() );
		return file;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
            
		if( source.equals( this.mCancelButton ) )
		{
			this.onCanceled();
		}
//		else if( source.equals( this.mPreviousButton ) )
//		{
//			this.onPrevious();
//		}
		else if( source.equals( this.mNextButton ) )
		{
			this.onNext();
		}
		else if( source.equals( this.mShowFileChooserButton ) )
		{
			this.showFileChooser();
		}

	}



	/**
	 * 
	 */
	public void caretUpdate( CaretEvent e )
	{
		Object source = e.getSource();
		if( source instanceof JTextComponent )
		{
			JTextComponent tc = (JTextComponent)source;
			String str = tc.getText();
			if( str.length()==0 )
			{
				this.mNextButton.setEnabled(false);
			}
			else
			{
				this.mNextButton.setEnabled(true);
			}
		}

	}



	/**
	 * 
	 */
	private boolean showFileChooser()
	{

		ArrayList list = this.openFileChooser();
		if( list==null )
		{
			return false;
		}
		if( list.size()!=1 )
		{
			return true;
		}

		File file = (File)list.get(0);

		boolean flag = this.setFileName(file.getPath());

		this.mNextButton.setEnabled(true);

		PATH_NAME = file.getAbsolutePath();

		return flag;
	}





}
