;Samurai Graph installer script for Win32

!define SG_PRODUCT "Samurai-Graph"
!define SG_VER_MAJOR "0"
!define SG_VER_MINOR "1"
!define SG_VER_MICRO "4"
!define SG_VERSION "${SG_VER_MAJOR}.${SG_VER_MINOR}.${SG_VER_MICRO}"
!define SG_REGKEY  "Software\${SG_PRODUCT}"
!define SG_URL     "http://www.sourceforge.jp/projects/samurai-graph"

; !define SG_SELECT_COMPONENTS  "YES"

!include "MUI.nsh"

;--------------------------------
;General

  ;Name and file
  Name "${SG_PRODUCT} ${SG_VERSION}"
  OutFile "samurai-graph-win32-${SG_VERSION}.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\${SG_PRODUCT}-${SG_VERSION}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "${SG_REGKEY}" ""

  ;------------------------------
  ;Interface Configuration

  ; Installer and uninstaller icon file
  !define MUI_ICON   "resources\setup.ico"
  !define MUI_UNICON "resources\remove.ico"
  ; welcome page bitmap
  !define MUI_WELCOMEFINISHPAGE_BITMAP "resources\welcome.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "resources\unwelcome.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
!ifdef SG_SELECT_COMPONENTS
  !insertmacro MUI_PAGE_COMPONENTS
!endif
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"

;-------------------------
;Installer Sections

Section "Samura Graph" SecCopyUI

  ;Store installation folder
  WriteRegStr HKCU "${SG_REGKEY}" "" $INSTDIR

  ;Install Files
  SetOutPath "$INSTDIR"
  File ..\..\dist\COPYING.txt
  File ..\..\dist\LICENSE.txt
  File ..\..\dist\samurai-graph.ico
  File ..\..\dist\samurai-graph.jar
;  File ..\..\dist\samurai-graph-client.jar

  SetOutPath "$INSTDIR\lib\vectorgraphics"
  File ..\..\dist\lib\vectorgraphics\freehep-base.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphics2d.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-cgm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-emf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-gif.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-java.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-pdf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ppm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ps.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-svg.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-swf.jar

  SetOutPath "$INSTDIR\doc\vectorgraphics"
  File ..\..\dist\doc\vectorgraphics\LGPL.txt
  File ..\..\dist\doc\vectorgraphics\LICENSE.txt
  File ..\..\dist\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt
  File ..\..\dist\doc\vectorgraphics\ReleaseNotes-1.2.2.html

  SetOutPath "$INSTDIR\examples"
  File ..\..\examples\data\ReadMe.txt
  File ..\..\examples\data\Example1.txt
  File ..\..\examples\data\Example2.txt
  File ..\..\examples\data\Example3.txt
  File ..\..\examples\data\Example4.txt
  File ..\..\examples\data\Example5.txt
  File ..\..\examples\data\Example6.txt
  File ..\..\examples\data\Property1.txt

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
; Section for Create shortcut on Desktop

Section "Desktop Shortcut" DesktopIcon
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateShortCut  "$DESKTOP\${SG_PRODUCT} ${SG_VERSION}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
SectionEnd

;--------------------------------
; Section for Create shortcut on Start Menu

Section "Start Menu Shortcuts" StartMenu
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateDirectory "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}"
  CreateShortCut  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
  CreateShortCut  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Examples Directory.lnk" "$INSTDIR\examples"
  WriteINIStr "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Site.url" "InternetShortcut" "URL" "${SG_URL}"
  CreateShortCut  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\Uninstall.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0
SectionEnd

;--------------------------------
; Section for Regist Uninstall information

Section -post
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "InstallLocation" "$INSTDIR"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "DisplayName" "Samurai Graph"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "DisplayIcon" "$INSTDIR\samurai-graph.ico,0"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "DisplayVersion" "${SG_VERSION}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "VersionMajor" "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "VersionMinor" "${SG_VER_MINOR}.${SG_VER_MICRO}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "URLInfoAbout" "${SG_URL}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "NoModify" "1"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}" "NoRepair" "1"
SectionEnd

!ifdef SG_SELECT_COMPONENTS
;--------------------------------
;Descriptions
  ;Language strings
  LangString DESC_SecCopyUI ${LANG_ENGLISH} "Copy the Samurai Graph application to your local folder."
  LangString DESC_SecCopyUI ${LANG_JAPANESE} "Samurai GraphAvP[V[JtH_ɃRs[܂B"

  LangString DESC_DesktopIcon ${LANG_ENGLISH} "Create a shortcut to your desktop."
  LangString DESC_DesktopIcon ${LANG_JAPANESE} "fXNgbvɃV[gJbg܂B"

  LangString DESC_StartMenu ${LANG_ENGLISH} "Create a shortcut to your start menu."
  LangString DESC_StartMenu ${LANG_JAPANESE} "X^[gj[ɃV[gJbg܂B"

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
    !insertmacro MUI_DESCRIPTION_TEXT ${DesktopIcon} $(DESC_DesktopIcon)
    !insertmacro MUI_DESCRIPTION_TEXT ${StartMenu} $(DESC_StartMenu)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

;-------------------------
;Uninstaller Section

Section "Uninstall"

  ;Uninstall Files
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\LICENSE.txt"
  Delete "$INSTDIR\samurai-graph.ico"
  Delete "$INSTDIR\samurai-graph.jar"
;  Delete "$INSTDIR\samurai-graph-client.jar"

  Delete "$INSTDIR\lib\vectorgraphics\freehep-base.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphics2d.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-cgm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-emf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-gif.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-java.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-pdf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ppm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ps.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-svg.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-swf.jar"

  Delete "$INSTDIR\doc\vectorgraphics\LGPL.txt"
  Delete "$INSTDIR\doc\vectorgraphics\LICENSE.txt"
  Delete "$INSTDIR\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt"
  Delete "$INSTDIR\doc\vectorgraphics\ReleaseNotes-1.2.2.html"

  Delete "$INSTDIR\examples\ReadMe.txt"
  Delete "$INSTDIR\examples\Example1.txt"
  Delete "$INSTDIR\examples\Example2.txt"
  Delete "$INSTDIR\examples\Example3.txt"
  Delete "$INSTDIR\examples\Example4.txt"
  Delete "$INSTDIR\examples\Example5.txt"
  Delete "$INSTDIR\examples\Example6.txt"
  Delete "$INSTDIR\examples\Property1.txt"

  Delete "$INSTDIR\Uninstall.exe"

  ; desktop
  Delete "$DESKTOP\${SG_PRODUCT} ${SG_VERSION}.lnk"

  ; start menu
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT}.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Examples Directory.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Site.url"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\Uninstall.lnk"
  RMDir  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}"

  RMDir "$INSTDIR\lib\vectorgraphics"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\doc\vectorgraphics"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\examples\data"
  RMDir "$INSTDIR\examples"
  RMDir "$INSTDIR"

  ; delete regkeys
  DeleteRegKey /ifempty HKCU "${SG_REGKEY}"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_PRODUCT}-${SG_VERSION}"
SectionEnd

;  Find JRE (javaw.exe)
Function GetJRE
;  1 - in .\jre directory (JRE Installed with application)
;  2 - in JAVA_HOME environment variable
;  3 - in the registry
;  4 - assume java.exe in current dir or PATH

  Push $R0
  Push $R1

  ClearErrors
  StrCpy $R0 "$EXEDIR\jre\bin\javaw.exe"
  IfFileExists $R0 JreFound
  StrCpy $R0 ""

  ClearErrors
  ReadEnvStr $R0 "JAVA_HOME"
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfErrors 0 JreFound

  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
  ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R1" "JavaHome"
  StrCpy $R0 "$R0\jre\bin\javaw.exe"
  IfErrors 0 JreFound

  StrCpy $R0 "javaw.exe"
        
 JreFound:
  Pop $R1
  Exch $R0
FunctionEnd
