<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">

<xsl:import href="../../docbook/xsl/html/chunk.xsl" />

<!-- body color -->
<xsl:template name="body.attributes">
  <xsl:attribute name="bgcolor">white</xsl:attribute>
  <xsl:attribute name="text">black</xsl:attribute>
  <xsl:attribute name="link">#000099</xsl:attribute>
  <xsl:attribute name="vlink">#000099</xsl:attribute>
  <xsl:attribute name="alink">#840084</xsl:attribute>
</xsl:template>

<!-- Page header -->
<xsl:template name="header.navigation">
  <xsl:param name="prev" select="/foo"/>
  <xsl:param name="next" select="/foo"/>
  <xsl:param name="nav.context"/>

  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="up" select="parent::*"/>

  <xsl:variable name="row1" select="$navig.showtitles != 0"/>
  <xsl:variable name="row2" select="count($prev) &gt; 0
                                    or (count($up) &gt; 0 
					and generate-id($up) != generate-id($home)
                                        and $navig.showtitles != 0)
                                    or count($next) &gt; 0"/>

  <xsl:if test="$suppress.navigation = '0' and $suppress.header.navigation = '0'">
    <div class="navheader">
      <xsl:if test="$row1 or $row2">
        <table width="100%" cellspacing="0" summary="Navigation header">
            <tr>
              <td width="74%" align="left">
                <xsl:if test="count($prev)>0">
                  <a accesskey="p">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$prev"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'prev'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
                <xsl:text>&#160;</xsl:text>
              </td>
              <td width="26%" align="right">
                <xsl:text>&#160;</xsl:text>
                <xsl:if test="count($next)>0">
                  <a accesskey="n">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$next"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'next'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
              </td>
            </tr>
            <tr>
              <th align="left" class="function_name">
              <span>
                <xsl:apply-templates select="." mode="object.title.markup"/>
              </span>
              </th>
              <th align="right" class="section_title">
                <xsl:choose>
                  <xsl:when test="count($up) > 0
				  and generate-id($up) != generate-id($home)
                                  and $navig.showtitles != 0">
                    <xsl:apply-templates select="$up" mode="object.title.markup"/>
                  </xsl:when>
                  <xsl:otherwise>&#160;</xsl:otherwise>
                </xsl:choose>
              </th>
            </tr>
        </table>
      </xsl:if>
      <xsl:if test="$header.rule != 0">
        <hr size="7" color="#2E4E99"/>
      </xsl:if>
    </div>
  </xsl:if>
</xsl:template>

<!-- Page footer -->
<xsl:template name="footer.navigation">
  <xsl:param name="prev" select="/foo"/>
  <xsl:param name="next" select="/foo"/>
  <xsl:param name="nav.context"/>

  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="up" select="parent::*"/>

  <xsl:variable name="row1" select="count($prev) &gt; 0
                                    or count($up) &gt; 0
                                    or count($next) &gt; 0"/>

  <xsl:variable name="row2" select="($prev and $navig.showtitles != 0)
                                    or (generate-id($home) != generate-id(.)
                                        or $nav.context = 'toc')
                                    or ($chunk.tocs.and.lots != 0
                                        and $nav.context != 'toc')
                                    or ($next and $navig.showtitles != 0)"/>

  <xsl:if test="$suppress.navigation = '0' and $suppress.footer.navigation = '0'">
    <div class="navfooter">
      <xsl:if test="$footer.rule != 0">
      <p></p>
        <hr size="5" color="#2E4E99"/>
      </xsl:if>

      <xsl:if test="$row1 or $row2">
        <table width="100%" summary="Navigation footer">
          <xsl:if test="$row1">
            <tr>
              <td width="40%" align="left">
                <xsl:if test="count($prev)>0">
                  <a accesskey="p">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$prev"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'prev'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
                <xsl:text>&#160;</xsl:text>
              </td>
              <td width="20%" align="center">
                <xsl:choose>
                  <xsl:when test="count($up)>0">
                    <a accesskey="u">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$up"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'up'"/>
                      </xsl:call-template>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>&#160;</xsl:otherwise>
                </xsl:choose>
              </td>
              <td width="40%" align="right">
                <xsl:text>&#160;</xsl:text>
                <xsl:if test="count($next)>0">
                  <a accesskey="n">
                    <xsl:attribute name="href">
                      <xsl:call-template name="href.target">
                        <xsl:with-param name="object" select="$next"/>
                      </xsl:call-template>
                    </xsl:attribute>
                    <xsl:call-template name="navig.content">
                      <xsl:with-param name="direction" select="'next'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
              </td>
            </tr>
          </xsl:if>

          <xsl:if test="$row2">
            <tr>
              <th width="40%" align="left" valign="top">
                <xsl:if test="$navig.showtitles != 0">
                  <xsl:apply-templates select="$prev" mode="object.title.markup"/>
                </xsl:if>
                <xsl:text>&#160;</xsl:text>
              </th>
              <th width="20%" align="center">
                <xsl:choose>
                  <xsl:when test="$home != . or $nav.context = 'toc'">
                    <a accesskey="h">
                      <xsl:attribute name="href">
                        <xsl:call-template name="href.target">
                          <xsl:with-param name="object" select="$home"/>
                        </xsl:call-template>
                      </xsl:attribute>
                      <xsl:call-template name="navig.content">
                        <xsl:with-param name="direction" select="'home'"/>
                      </xsl:call-template>
                    </a>
                    <xsl:if test="$chunk.tocs.and.lots != 0 and $nav.context != 'toc'">
                      <xsl:text>&#160;|&#160;</xsl:text>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>&#160;</xsl:otherwise>
                </xsl:choose>

                <xsl:if test="$chunk.tocs.and.lots != 0 and $nav.context != 'toc'">
                  <a accesskey="t">
                    <xsl:attribute name="href">
                      <xsl:apply-templates select="/*[1]"
                                           mode="recursive-chunk-filename"/>
                      <xsl:text>-toc</xsl:text>
                      <xsl:value-of select="$html.ext"/>
                    </xsl:attribute>
                    <xsl:call-template name="gentext">
                      <xsl:with-param name="key" select="'nav-toc'"/>
                    </xsl:call-template>
                  </a>
                </xsl:if>
              </th>
              <th width="40%" align="right" valign="top">
                <xsl:text>&#160;</xsl:text>
                <xsl:if test="$navig.showtitles != 0">
                  <xsl:apply-templates select="$next" mode="object.title.markup"/>
                </xsl:if>
              </th>
            </tr>
          </xsl:if>
        </table>
        <br/>
        <table width="100%" summary="Copyright URL">
          <tr>
            <td align="left">
              <div class="cright">Copyright  2004 RIKEN (The Institute of Physical and Chemical Research)
              </div>
              <div class="cright">All rights reserved.</div>
              <div class="url">
                <a href="http://satellite.sourceforge.jp/" target="_blank">http://satellite.sourceforge.jp/</a>
              </div>
            </td>
            <td align="right" valign="top">
              <div class="lastmodified">Last modified: 2004/09/22</div>
            </td>
          </tr>
        </table>
      </xsl:if>
    </div>
  </xsl:if>
</xsl:template>

<!-- Name of each function -->
<xsl:template match="refname">
<!--  <xsl:apply-templates/> -->
  <xsl:if test="following-sibling::refname">
    <xsl:text>, </xsl:text>
  </xsl:if>
</xsl:template>

<!-- Explanation of each function -->
<xsl:template match="refpurpose">
<!--  <xsl:text> </xsl:text>
  <xsl:call-template name="dingbat">
    <xsl:with-param name="dingbat">em-dash</xsl:with-param>
  </xsl:call-template>
  <xsl:text> </xsl:text> -->
  <xsl:apply-templates/>
</xsl:template>

<!-- TopPage Title -->
<xsl:template match="title" mode="titlepage.mode">
  <xsl:variable name="id">
    <xsl:choose>
      <!-- if title is in an *info wrapper, get the grandparent -->
      <xsl:when test="contains(local-name(..), 'info')">
        <xsl:call-template name="object.id">
          <xsl:with-param name="object" select="../.."/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="object.id">
          <xsl:with-param name="object" select=".."/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

<!--  <h1 class="{name(.)}">
    <a name="{$id}"/>
    <xsl:choose>
      <xsl:when test="$show.revisionflag != 0 and @revisionflag">
	<span class="{@revisionflag}">
	  <xsl:apply-templates mode="titlepage.mode"/>
	</span>
      </xsl:when>
      <xsl:otherwise>
	<xsl:apply-templates mode="titlepage.mode"/>
      </xsl:otherwise>
    </xsl:choose>
  </h1> -->
</xsl:template>

<!-- Text -->
<xsl:param name="local.l10n.xml" select="document('')"/>
<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
  <l:l10n language="ja" english-language-name="Japanese">
    <l:gentext key="Copyright" text="Copyright" lang="en"/>
    <l:gentext key="copyright" text="Copyright" lang="en"/>
    <l:gentext key="RefName" text="&#27231;&#33021;"/>
    <l:gentext key="refname" text="&#27231;&#33021;"/>
    <l:gentext key="RefSynopsisDiv" text="&#24418;&#24335;"/>
    <l:gentext key="refsynopsisdiv" text="&#24418;&#24335;"/>
  </l:l10n>
</l:i18n>

<!-- StyleSheet -->
<xsl:param name="html.stylesheet" select="'../css/style.css'"></xsl:param>
<xsl:param name="html.stylesheet.type">text/css</xsl:param>

<xsl:param name="saxon.character.representation" select="'native'"/>
<xsl:param name="root.filename" select="'index'"/>

<!-- HTML -->
<xsl:param name="use.id.as.filename" select="1"/>
<xsl:param name="generate.id.attributes" select="1"/>

<!-- <xsl:param name="suppress.navigation" select="1"/> -->
<xsl:param name="navig.graphics" select="1"/>
<xsl:param name="navig.graphics.path" select="'../images/'"/>
<xsl:param name="navig.graphics.extension" select="'.gif'"/>

<!-- Toc -->
<xsl:param name="generate.section.toc.level" select="0"/>
<xsl:param name="toc.max.depth" select="0"/>
<xsl:param name="toc.section.depth" select="0"/>
<xsl:param name="generate.toc">
appendix  toc,title
article/appendix  nop
article   toc,title
book      toc,title,figure,table,example,equation
chapter   toc,title
part      toc,title
preface   toc,title
qandadiv  toc
qandaset  toc
reference toc,title
sect1     title
sect2     title
sect3     title
sect4     title
sect5     title
section   title
set       toc,title
</xsl:param>

<!-- Encode -->
<xsl:param name="default.encoding" select="'UTF-8'"/>

<!-- Tables -->
<xsl:param name="html.cellspacing" select="0"/>
<xsl:param name="html.cellpadding" select="5"/>

<!-- Chunking -->
<xsl:param name="chunker.output.encoding" select="'UTF-8'"/>
<xsl:param name="chunk.first.sections" select="1"></xsl:param>

<!-- Localization -->
<xsl:param name="l10n.gentext.language" select="'ja'"/>
<xsl:param name="l10n.gentext.default.language" select="'ja'"/>

<!-- TeX -->
<xsl:param name="tex.math.in.alt" select="'latex'"/>
<xsl:param name="passivetex.extensions" select="1"/>

</xsl:stylesheet>
