package org.freehep.jaco.rtti.cpp;

import java.util.Vector;

/**
 * Holds the various attributes of a declaration. This is filled up as the
 * declaration is parsed.
 *
 * @author Mark Donszelmann
 * @version $Id: Declaration.java,v 1.1.1.1 2004/05/31 05:08:51 kuromaru Exp $
 */

class Declaration
{
   /**
    * class/struct/union is indicated by CLASS.
    */
   boolean isClass;

   /**
    * Indicates if this is a typedef declaration.
    */
   boolean isTypedef;

   /**
    * Indicates if this is a static declaration.
    */
   boolean isStatic;

   boolean isReference;

   /**
    * Pointer
    */
   int pointer;

   /**
    * Name of the declarator.
    */
   String name;

   /**
    * Scopename. By default, it is the current scope. If the name is declared
    * with scope override operator, it will be set to that scope.
    * NOT FILLED AT THE MOMENT
    */
   Scope scope;
}
