
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.geom.*;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */
public abstract class SGDrawingElementString extends SGDrawingElement
{


	/**
	 *
	 */
	protected String mString;


	/**
	 * 
	 */
	protected String mFontFamilyName;


	/**
	 * ̂wW
	 */
	protected float mX;


	/**
	 * ̂xW
	 */
	protected float mY;


	/**
	 *
	 */
	protected float mFontSize;


	/**
	 *
	 */
	protected int mFontStyle;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	public SGDrawingElementString()
	{
		super();
	}


	/**
	 * 
	 */
	public SGDrawingElementString( final String str )
	{
		super();

		mString = str;
	}


	/**
	 * 
	 */
	public SGDrawingElementString(
		final SGDrawingElementString element )
	{
		super();

		this.mString = element.getString();
		this.mFontFamilyName = element.getFontFamilyName();
		this.mX = element.getX();
		this.mY = element.getY();
		this.mFontSize = element.getFontSize();
		this.mFontStyle = element.getFontStyle();
		this.mAngle = element.getAngle();
		this.mColorList = new ArrayList( element.getColorList() );
	}


	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final int fontStyle,
		final float fontSize )
	{
		super();

		mString = str;
		mFontStyle = fontStyle;
		mFontSize = fontSize;
	}
	

	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final int fontStyle,
		final float fontSize,
		final float x,
		final float y )
	{
		super();
		
		mString = str;
		mFontStyle = fontStyle;
		mFontSize = fontSize;
		mX = x;
		mY = y;
	}



	/**
	 * 
	 */
	public String toString()
	{
		return this.mString;
	}



	/**
	 *
	 */
	public boolean setFontSize( final float size )
	{
		mFontSize = size;
		return true;
	}


	/**
	 *
	 */
	public boolean setFontStyle( final int type )
	{
		mFontStyle = type;
		return true;
	}



	/**
	 *
	 */
	public boolean setString( final String str )
	{
		mString = str;
		return true;
	}


	/**
	 *
	 */
	public String getString()
	{
		return mString;
	}



	/**
	 *
	 */
	public float getX()
	{
		return mX;
	}


	/**
	 *
	 */
	public float getY()
	{
		return mY;
	}



	/**
	 * 
	 * @return
	 */
	public Point2D getLocation()
	{
		final Point2D pos
			= new Point2D.Float( this.getX(), this.getY() );
		return pos;
	}



	/**
	 *
	 */
	public float getFontSize()
	{
		return mFontSize;
	}


	/**
	 *
	 */
	public int getFontStyle()
	{
		return mFontStyle;
	}


	/**
	 *
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}



	/**
	 * 
	 */
	public boolean setX( final float x )
	{
		this.mX = x;
		return true;
	}


	/**
	 * 
	 */
	public boolean setY( final float y )
	{
		this.mY = y;
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return mAngle;
	}


	/**
	 * 
	 * @return
	 */
	public String getFontFamilyName()
	{
		return mFontFamilyName;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.mFontFamilyName = name;
		return true;
	}
	


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementString) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementString el = (SGDrawingElementString)element;
		
		this.setFontFamilyName( el.getFontFamilyName() );
		this.setFontSize( el.getFontSize() );
		this.setFontStyle( el.getFontStyle() );
		this.setAngle( el.getAngle() );

		return true;
	}

	


}
