#include <stdio.h>
#include <strings.h>

#define ERR_DEFALT_ENCRYPTION		"Invalid default encryption strings."
#define DEFALT_ENCSTR_YES		"yes"
#define DEFALT_ENCSTR_NO		"no"

char * is_defaultenc(char *);

int
main()
{
    // valid
    char *test1 = "yes";
    char *test2 = "YES";
    char *test3 = "YeS";
    char *test4 = "yEs";
    char *test5 = "no";
    char *test6 = "No";
    char *test7 = "nO";
    char *test8 = "NO";

    if (is_defaultenc(test1) != NULL) {
	printf("error: %s\n", test1);
    }
    if (is_defaultenc(test2) != NULL) {
	printf("error: %s\n", test2);
    }
    if (is_defaultenc(test3) != NULL) {
	printf("error: %s\n", test3);
    }
    if (is_defaultenc(test4) != NULL) {
	printf("error: %s\n", test4);
    }
    if (is_defaultenc(test5) != NULL) {
	printf("error: %s\n", test5);
    }
    if (is_defaultenc(test6) != NULL) {
	printf("error: %s\n", test6);
    }
    if (is_defaultenc(test7) != NULL) {
	printf("error: %s\n", test7);
    }
    if (is_defaultenc(test8) != NULL) {
	printf("error: %s\n", test8);
    }

    // invalid
    char *test9 = "";
    char *test10 = NULL;
    char *test11 = "aaaa";
    char *test12 = "yess";
    char *test13 = "yyes";
    char *test14 = "noo";
    char *test15 = "nno";

    if (is_defaultenc(test9) == NULL) {
	printf("error: %s\n", test9);
    }
    if (is_defaultenc(test10) == NULL) {
	printf("error: %s\n", test10);
    }
    if (is_defaultenc(test11) == NULL) {
	printf("error: %s\n", test11);
    }
    if (is_defaultenc(test12) == NULL) {
	printf("error: %s\n", test12);
    }
    if (is_defaultenc(test13) == NULL) {
	printf("error: %s\n", test13);
    }
    if (is_defaultenc(test14) == NULL) {
	printf("error: %s\n", test14);
    }
    if (is_defaultenc(test15) == NULL) {
	printf("error: %s\n", test15);
    }

    return(0);
}

char *
is_defaultenc(char *str)
{
    if (str == NULL) {
	return (ERR_DEFALT_ENCRYPTION);
    }

    if ((strcasecmp(str, DEFALT_ENCSTR_YES) != 0) && 
	(strcasecmp(str, DEFALT_ENCSTR_NO) != 0)){
	return (ERR_DEFALT_ENCRYPTION);
    }

    return (NULL);
}
