
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxFalse : public TestCase
{
public:

	TestRxFalse(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxFalse");

		suite->addTest(new TEST_CALLER(TestRxFalse, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxFalse, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxFalse, test_is_false));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxFalse().is_nil() == false);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxFalse().is_true() == false);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxFalse().is_false() == true);
	}

};
