/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SmaLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="SmaLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class SmaLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final SmaLine m_smaLine;

    public SmaLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        int cost = pcountGene.getIntValue();
        this.m_smaLine = new SmaLine(cost);
        this.getPortList().add("@IndexLine", cost);
    }

    @Override
    public void notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_smaLine.addPoint((IndexLine)port.getIndexStream().getValues());
        this.notifyIndexNext();
    }

    @Override
    public SmaLine getValues() {
        return this.m_smaLine;
    }

    @Override
    public void economizeCapacity() {
        this.m_smaLine.setCapacity(this.getDestinationMaxCost());
    }
}

