/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.EventSignalBlock;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"count"})
@InputComponentList(values={"any@Signal"})
public class CountDownSignalBlock
extends EventSignalBlock {
    private static final long serialVersionUID = 1L;
    private final int m_initialCount;
    private int m_currentCount;
    private NmSignal m_triggerSignal;
    private boolean m_active;

    public CountDownSignalBlock(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList, String p_countLabel) throws GeneListException {
        super(p_label, p_priority, p_outputSignal);
        this.m_initialCount = p_geneList.getGene(p_countLabel).getIntValue();
        this.m_triggerSignal = NmSignal.NOSIGNAL;
        this.m_active = false;
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        if (this.getLastJudgmentResult() != null && inputTag.equals(this.getLastJudgmentResult().getTag())) {
            return this.getLastJudgmentResult();
        }
        JudgmentResult returnValue = new JudgmentResult(inputTag, NmSignal.NOSIGNAL);
        JudgmentResult inputSignal = super.getJudgmentResultSub();
        if (this.m_active) {
            if (this.m_triggerSignal == NmSignal.LONG && inputSignal.getSignal() == NmSignal.SHORT || this.m_triggerSignal == NmSignal.SHORT && inputSignal.getSignal() == NmSignal.LONG) {
                this.m_currentCount = this.m_initialCount;
                this.m_triggerSignal = inputSignal.getSignal();
            } else if (inputSignal.getSignal() == NmSignal.ESCAPE) {
                this.m_currentCount = 0;
                returnValue = new JudgmentResult(inputTag, this.getOutputSignal());
            } else {
                if (this.m_currentCount > 0) {
                    --this.m_currentCount;
                }
                if (this.m_currentCount <= 0) {
                    this.m_currentCount = 0;
                    returnValue = new JudgmentResult(inputTag, this.getOutputSignal());
                }
            }
        } else if (inputSignal.getSignal() == NmSignal.LONG || inputSignal.getSignal() == NmSignal.SHORT) {
            this.m_active = true;
            this.m_currentCount = this.m_initialCount;
            this.m_triggerSignal = inputSignal.getSignal();
        }
        return returnValue;
    }
}

