/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickAvgLine;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickAvgLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickAvgLine m_candleStickAvgLine;

    public CandleStickAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) throws GeneListException {
        super(p_label);
        Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
        int closeRatio = closeRatioGene.getIntValue();
        this.m_candleStickAvgLine = new CandleStickAvgLine(closeRatio);
        this.getPortList().add("@CandleStickList", 1);
    }

    @Override
    public void notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_candleStickAvgLine.addPoint((CandleStick)port.getIndexStream().getValues().getLast());
        this.notifyIndexNext();
    }

    @Override
    public CandleStickAvgLine getValues() {
        return this.m_candleStickAvgLine;
    }

    @Override
    public void economizeCapacity() {
        this.m_candleStickAvgLine.setCapacity(this.getDestinationMaxCost());
    }
}

