/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.graph;

import java.util.ArrayList;
import jp.robotbrain.graph.GraphException;
import jp.robotbrain.graph.GraphLayer;
import jp.robotbrain.graph.GraphPanel;
import jp.robotbrain.signal.IndexObjectList;

public class GraphLayerList {
    private final GraphPanel m_parent;
    private int m_maxOverLapNo;
    private ArrayList<GraphLayer> m_graphLayerList;

    public GraphLayerList(GraphPanel p_parent) {
        this.m_parent = p_parent;
        this.m_maxOverLapNo = -1;
        this.m_graphLayerList = new ArrayList();
    }

    public GraphLayer add(String p_name, IndexObjectList<?> p_srcList, int p_overLapNo) throws GraphException {
        GraphLayer returnValue = null;
        if (p_overLapNo > this.m_maxOverLapNo) {
            this.m_maxOverLapNo = p_overLapNo;
        }
        returnValue = this.m_graphLayerList.size() <= 0 ? new GraphLayer(this.m_parent, p_name, true, p_srcList, p_overLapNo) : new GraphLayer(this.m_parent, p_name, false, p_srcList, p_overLapNo);
        this.m_graphLayerList.add(returnValue);
        return returnValue;
    }

    protected void init() {
        if (this.m_maxOverLapNo < 0) {
            return;
        }
        int i = 0;
        while (i <= this.m_maxOverLapNo) {
            double vmax = Double.MIN_VALUE;
            double vmin = Double.MAX_VALUE;
            for (GraphLayer layer : this.m_graphLayerList) {
                if (layer.getOverLapNo() != i || !layer.isSyncRuler()) continue;
                if (vmax < layer.getMax()) {
                    vmax = layer.getMax();
                }
                if (!(vmin > layer.getMin())) continue;
                vmin = layer.getMin();
            }
            for (GraphLayer layer : this.m_graphLayerList) {
                if (layer.getOverLapNo() != i || !layer.isSyncRuler()) continue;
                layer.setMax(vmax);
                layer.setMin(vmin);
            }
            ++i;
        }
    }

    protected ArrayList<GraphLayer> getValues() {
        return this.m_graphLayerList;
    }
}

