/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.SmaLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="SmaLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class SmaLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final SmaLine m_smaLine;

    public SmaLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
        super(p_label);
        Gene pcountGene = p_geneList.getGene(p_pcountLabel);
        int pcount = pcountGene.getIntValue();
        this.m_smaLine = new SmaLine(pcount);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_smaLine.size();
        this.m_smaLine.addPoint((IndexLine)p_indexObjectList);
        if (this.m_smaLine.size() > prevSize) {
            this.notifyIndexNext(this.m_smaLine);
        }
    }

    public SmaLine getValues() {
        return this.m_smaLine;
    }
}

