/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.StochasticsList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="StochasticsList")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccountRange", "pcountD"})
public class StochasticsListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final StochasticsList m_stochasticsList;

    public StochasticsListStream(String p_label, GeneList p_geneList, String p_ccountRangeLabel, String p_pcountDLabel) throws GeneListException, IndexStreamException {
        super(p_label);
        Gene ccountRangeGene = p_geneList.getGene(p_ccountRangeLabel);
        Gene pcountDGene = p_geneList.getGene(p_pcountDLabel);
        int ccountRange = ccountRangeGene.getIntValue();
        int pcountD = pcountDGene.getIntValue();
        this.m_stochasticsList = new StochasticsList(ccountRange, pcountD);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_stochasticsList.size();
        this.m_stochasticsList.addObject((CandleStickList)p_indexObjectList);
        if (this.m_stochasticsList.size() > prevSize) {
            this.notifyIndexNext(this.m_stochasticsList);
        }
    }

    public StochasticsList getValues() {
        return this.m_stochasticsList;
    }
}

