<?php
/**
 * RSS生成クラス
 *
 * RSS生成を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class rss extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT  `blog`.`blog_id`                                -- ブログID
                    , `blog`.`blog_title`                             -- ブログタイトル
                    , `blog`.`blog_body`                              -- ブログ本文
                    , `blog`.`post_datetime`                          -- 投稿日
                FROM `simpleblog_t_blog` blog
               WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                 AND (
                          TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                       OR (
                            `blog`.`end_datetime` = '0000-00-00 00:00:00'
                          )
                     )
            ORDER BY `blog`.`post_datetime` DESC
                   , `blog`.`blog_id`       DESC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は即時終了する
          exit;
        } // end of if
        else
        {
          // SQL文を組み立てる
          $sql =<<<End_Of_SQL
  
                SELECT  MAX( `blog`.`post_datetime` ) as max_date  -- 投稿日の最大値
                  FROM `simpleblog_t_blog` blog
                 WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                   AND (
                            TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                         OR (
                              `blog`.`end_datetime` = '0000-00-00 00:00:00'
                            )
                       )
              GROUP BY `blog`.`post_datetime`

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                        );

          // SQLを実行
          $tmp_max_date = $this->obj_db->dbGetRow( $sql, $param );
          if ( PEAR::isError( $tmp_max_date ) )
          {
            // エラーの場合は即時終了する
            exit;
          } // end of if

        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else


      // 取得した情報を表示に適した形に加工する
      $tmp_result_cooked = array();
      for( $cnt = 0 ; $cnt < count( $tmp_result ) ; $cnt ++ )
      {
        array_push( $tmp_result_cooked, array(
                                               'blog_id'       => $tmp_result[ $cnt ][ 'blog_id'       ]
                                             , 'blog_title'    => $tmp_result[ $cnt ][ 'blog_title'    ]
                                             , 'blog_body'     => $tmp_result[ $cnt ][ 'blog_body'     ]
                                             , 'post_datetime' => date( 'Y-m-d\TH:i:sP', strtotime( $tmp_result[ $cnt ][ 'post_datetime' ] ) )
                                             )
                  );
      } // end of for

      $this->gotDat[ 'items'   ] = $tmp_result_cooked;
      $this->gotDat[ 'maxdate' ] = date( 'Y-m-d\TH:i:sP', strtotime( $tmp_max_date[ 'max_date' ] ) );

      // ブログタイトルの取得
      $simpleblog_conf = new RisolutoConf();
      $simpleblog_conf->parse( RISOLUTO_CONF . 'simpleblog.ini' );
      $this->gotDat[ 'title' ] = $simpleblog_conf->get( 'BLOGINFO', 'title' );
      $this->gotDat[ 'desc'  ] = $simpleblog_conf->get( 'BLOGINFO', 'description' );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $this->smarty->assign ( 'title',           $this->gotDat[ 'title' ] );
      $this->smarty->assign ( 'description',     $this->gotDat[ 'desc'  ] );

      $this->smarty->assign ( 'baseurl',         $this->obj_util->getBaseUrl() );
      $this->smarty->assign ( 'rss_update_date', $this->gotDat[ 'maxdate' ] );
      $this->smarty->assign ( 'arr_items',       $this->gotDat[ 'items' ] );

      // 表示
      $this->smarty->display( 'rss_1.0.tpl' );

      return true;

    } // end of function:view()

  } // end of class:rss
?>
