create table Address (
	id		int not null,
	kind		int not null,
	prefecture		int not null,
	zip		varchar(10),
	city	varchar(300),
	address	varchar(300),
	comment	varchar(300),
	primary key(id));


create table EmailAddress (
	id		int not null,
	kind		int not null,
	email		varchar(200),
	primary key(id));

create table Telephone (
	id		int not null,
	kind		int not null,
	tel		varchar(20),
	primary key(id));
	
create table AddressBook (
	id		int not null,
	email	varchar(200),
	firstName	varchar(50),
	lastName	varchar(50),
	firstSpell	varchar(50),
	lastSpell	varchar(50),
	displayName	varchar(100),
	registrant	int not null,
	categoryid	int not null,
	primary key(id));

create table AddressBookAddress (
	id		int not null,
	addressBookId		int not null,
	addressId		int not null,
	primary key(id));

create table AddressBookEmailAddress (
	id		int not null,
	addressBookId		int not null,
	emailAddressId		int not null,
	primary key(id));

create table AddressBookTelephone (
	id		int not null,
	addressBookId		int not null,
	telephoneId			int not null,
	primary key(id));

	
create table AddressCategory (
	id		int not null,
	registrant	int not null,
	name	varchar(100),
	primary key(id));

create table AttachFile (
	id		int not null,
	sourceId	int not null,
	sourceTable	varchar(50) not null,
	registrant		int not null,
	registDate		Timestamp not null,
	subject		varchar(500) null,
	filename	varchar(1000) not null,
	comment	varchar(10000) null,
	primary key(id));
	


create table basebean (
	id		int not null,
	deleted		int default 0 not null,
	registDate		Timestamp not null,
	updateDate		Timestamp null,
	registrant		int not null,
	primary key(id));

create table Board (
	id		int not null,
	registrant		int not null,
	registDate		Timestamp not null,
	seq		int not null,
	depth		int not null,
	rootId		int not null,
	rootSeq		int not null,
	subject		varchar(500) not null,
	body		varchar(10000) not null,
	boardTreeId		int not null,
	primary key(id));
	
create table DAOSequence (
	keyname		varchar(50) not null,
	seq			int not null,
	primary key(keyname)
	);


create table WindowPos (
	id	int not null,
	memberId	int not null,
	x	int not null,
	y	int not null,
	height	int not null,
	width	int not null,
	windowName		varchar(100),
	optionXml		text,
	primary key(id));

create table Holiday (
	id		int not null,
	name	varchar(100) not null,
	day		date not null,
	primary key(id));
create table MailSetting (
	id					int not null,
	protocol			int not null,
	memberId			int not null,
	senderName			varchar(50) not null,
	name				varchar(50) not null,
	email				varchar(200),
	imapLoginid			varchar(50),
	imapHost			varchar(50),
	imapPassword		varchar(50),
	smtpHost			varchar(50),
	mailSendedFolder 	varchar(50),
	mailFooter 			varchar(500),
	primary key(id));
	

create table Member (
	id					int not null,
	loginid				varchar(50) not null,
	name				varchar(50) not null,
	passwd				varchar(50) not null,
	payhour				int default 0 not null,
	restminutes			int default 0 not null,
	trafficExpenses		int default 0 not null,
	trafficExpensesKind	int default 0 not null,
	primary key(id));
	
	
	
	
create table rolemember (
	roleid		int not null,
	memberid	int not null,
	primary key(roleid, memberid)
	);


create table Timecard (
	id			int not null,
	registrant	int not null,
	intime		Timestamp not null,
	outtime		Timestamp ,
	inipaddr		varchar(15),
	outipaddr		varchar(15),
	primary key(id));
	
	
	
	

create table Todo (
	id		int not null,
	registrant		int not null,
	registDate		Timestamp not null,
	seq				int not null,
	depth			int not null,
	rootId			int not null,
	subject			varchar(500) not null,
	body			varchar(10000) not null,
	todoTreeId		int not null,
	planFromDate	Timestamp ,
	planToDate		Timestamp ,
	deleted			int default 0 not null,
	updateDate		Timestamp null,
	loopunit		int null,
	loopinterval	int null,
	loopcount		int null,
	parentid		int null,
	complete		boolean null ,
	looptarget		Timestamp null,
	kind			int default 0 not null,
	open			boolean default true not null ,
	primary key(id));
	
create table TodoWorker (
	id		int not null,
	todoId	int not null,
	kind		int not null,
	memberId		int not null,
	primary key(id));
insert into holiday (id,name,day) values(20050101,'','2005/01/01');
insert into holiday (id,name,day) values(20050110,'ͤ','2005/01/10');
insert into holiday (id,name,day) values(20050211,'ǰ','2005/02/11');
insert into holiday (id,name,day) values(20050320,'ʬ','2005/03/20');
insert into holiday (id,name,day) values(20050321,'(ص)','2005/03/21');
insert into holiday (id,name,day) values(20050429,'ߤɤ','2005/04/29');
insert into holiday (id,name,day) values(20050503,'ˡǰ','2005/05/03');
insert into holiday (id,name,day) values(20050504,'̱ε','2005/05/04');
insert into holiday (id,name,day) values(20050505,'ɤ','2005/05/05');
insert into holiday (id,name,day) values(20050718,'','2005/07/18');
insert into holiday (id,name,day) values(20050919,'Ϸ','2005/09/19');
insert into holiday (id,name,day) values(20050923,'ʬ','2005/09/23');
insert into holiday (id,name,day) values(20051010,'ΰ','2005/10/10');
insert into holiday (id,name,day) values(20051103,'ʸ','2005/11/03');
insert into holiday (id,name,day) values(20051123,'ϫդ','2005/11/23');
insert into holiday (id,name,day) values(20051223,'ŷ','2005/12/23');
insert into holiday (id,name,day) values(20060101,'','2006/01/01');
insert into holiday (id,name,day) values(20060102,'(ص)','2006/01/02');
insert into holiday (id,name,day) values(20060109,'ͤ','2006/01/09');
insert into holiday (id,name,day) values(20060211,'ǰ','2006/02/11');
insert into holiday (id,name,day) values(20060321,'ʬ','2006/03/21');
insert into holiday (id,name,day) values(20060429,'ߤɤ','2006/04/29');
insert into holiday (id,name,day) values(20060503,'ˡǰ','2006/05/03');
insert into holiday (id,name,day) values(20060504,'̱ε','2006/05/04');
insert into holiday (id,name,day) values(20060505,'ɤ','2006/05/05');
insert into holiday (id,name,day) values(20060717,'','2006/07/17');
insert into holiday (id,name,day) values(20060918,'Ϸ','2006/09/18');
insert into holiday (id,name,day) values(20060923,'ʬ','2006/09/23');
insert into holiday (id,name,day) values(20061009,'ΰ','2006/10/09');
insert into holiday (id,name,day) values(20061103,'ʸ','2006/11/03');
insert into holiday (id,name,day) values(20061123,'ϫդ','2006/11/23');
insert into holiday (id,name,day) values(20061223,'ŷ','2006/12/23');
insert into holiday (id,name,day) values(20070101,'','2007/01/01');
insert into holiday (id,name,day) values(20070108,'ͤ','2007/01/08');
insert into holiday (id,name,day) values(20070211,'ǰ','2007/02/11');
insert into holiday (id,name,day) values(20070212,'(ص)','2007/02/12');
insert into holiday (id,name,day) values(20070321,'ʬ','2007/03/21');
insert into holiday (id,name,day) values(20070429,'¤','2007/04/29');
insert into holiday (id,name,day) values(20070430,'(ص)','2007/04/30');
insert into holiday (id,name,day) values(20070503,'ˡǰ','2007/05/03');
insert into holiday (id,name,day) values(20070504,'ߤɤ','2007/05/04');
insert into holiday (id,name,day) values(20070505,'ɤ','2007/05/05');
insert into holiday (id,name,day) values(20070716,'','2007/07/16');
insert into holiday (id,name,day) values(20070917,'Ϸ','2007/09/17');
insert into holiday (id,name,day) values(20070923,'ʬ','2007/09/23');
insert into holiday (id,name,day) values(20070924,'(ص)','2007/09/24');
insert into holiday (id,name,day) values(20071008,'ΰ','2007/10/08');
insert into holiday (id,name,day) values(20071103,'ʸ','2007/11/03');
insert into holiday (id,name,day) values(20071123,'ϫդ','2007/11/23');
insert into holiday (id,name,day) values(20071223,'ŷ','2007/12/23');
insert into holiday (id,name,day) values(20071224,'(ص)','2007/12/24');
insert into holiday (id,name,day) values(20080101,'','2008/01/01');
insert into holiday (id,name,day) values(20080114,'ͤ','2008/01/14');
insert into holiday (id,name,day) values(20080211,'ǰ','2008/02/11');
insert into holiday (id,name,day) values(20080320,'ʬ','2008/03/20');
insert into holiday (id,name,day) values(20080429,'¤','2008/04/29');
insert into holiday (id,name,day) values(20080503,'ˡǰ','2008/05/03');
insert into holiday (id,name,day) values(20080504,'ߤɤ','2008/05/04');
insert into holiday (id,name,day) values(20080505,'ɤ','2008/05/05');
insert into holiday (id,name,day) values(20080506,'(ص)','2008/05/06');
insert into holiday (id,name,day) values(20080721,'','2008/07/21');
insert into holiday (id,name,day) values(20080915,'Ϸ','2008/09/15');
insert into holiday (id,name,day) values(20080923,'ʬ','2008/09/23');
insert into holiday (id,name,day) values(20081013,'ΰ','2008/10/13');
insert into holiday (id,name,day) values(20081103,'ʸ','2008/11/03');
insert into holiday (id,name,day) values(20081123,'ϫդ','2008/11/23');
insert into holiday (id,name,day) values(20081124,'(ص)','2008/11/24');
insert into holiday (id,name,day) values(20081223,'ŷ','2008/12/23');
insert into holiday (id,name,day) values(20090101,'','2009/01/01');
insert into holiday (id,name,day) values(20090112,'ͤ','2009/01/12');
insert into holiday (id,name,day) values(20090211,'ǰ','2009/02/11');
insert into holiday (id,name,day) values(20090320,'ʬ','2009/03/20');
insert into holiday (id,name,day) values(20090429,'¤','2009/04/29');
insert into holiday (id,name,day) values(20090503,'ˡǰ','2009/05/03');
insert into holiday (id,name,day) values(20090504,'ߤɤ','2009/05/04');
insert into holiday (id,name,day) values(20090505,'ɤ','2009/05/05');
insert into holiday (id,name,day) values(20090506,'(ص)','2009/05/06');
insert into holiday (id,name,day) values(20090720,'','2009/07/20');
insert into holiday (id,name,day) values(20090921,'Ϸ','2009/09/21');
insert into holiday (id,name,day) values(20090922,'̱ε','2009/09/22');
insert into holiday (id,name,day) values(20090923,'ʬ','2009/09/23');
insert into holiday (id,name,day) values(20091012,'ΰ','2009/10/12');
insert into holiday (id,name,day) values(20091103,'ʸ','2009/11/03');
insert into holiday (id,name,day) values(20091123,'ϫդ','2009/11/23');
insert into holiday (id,name,day) values(20091223,'ŷ','2009/12/23');
insert into holiday (id,name,day) values(20100101,'','2010/01/01');
insert into holiday (id,name,day) values(20100111,'ͤ','2010/01/11');
insert into holiday (id,name,day) values(20100211,'ǰ','2010/02/11');
insert into holiday (id,name,day) values(20100321,'ʬ','2010/03/21');
insert into holiday (id,name,day) values(20100322,'(ص)','2010/03/22');
insert into holiday (id,name,day) values(20100429,'¤','2010/04/29');
insert into holiday (id,name,day) values(20100503,'ˡǰ','2010/05/03');
insert into holiday (id,name,day) values(20100504,'ߤɤ','2010/05/04');
insert into holiday (id,name,day) values(20100505,'ɤ','2010/05/05');
insert into holiday (id,name,day) values(20100719,'','2010/07/19');
insert into holiday (id,name,day) values(20100920,'Ϸ','2010/09/20');
insert into holiday (id,name,day) values(20100923,'ʬ','2010/09/23');
insert into holiday (id,name,day) values(20101011,'ΰ','2010/10/11');
insert into holiday (id,name,day) values(20101103,'ʸ','2010/11/03');
insert into holiday (id,name,day) values(20101123,'ϫդ','2010/11/23');
insert into holiday (id,name,day) values(20101223,'ŷ','2010/12/23');
insert into holiday (id,name,day) values(20110101,'','2011/01/01');
insert into holiday (id,name,day) values(20110110,'ͤ','2011/01/10');
insert into holiday (id,name,day) values(20110211,'ǰ','2011/02/11');
insert into holiday (id,name,day) values(20110321,'ʬ','2011/03/21');
insert into holiday (id,name,day) values(20110429,'¤','2011/04/29');
insert into holiday (id,name,day) values(20110503,'ˡǰ','2011/05/03');
insert into holiday (id,name,day) values(20110504,'ߤɤ','2011/05/04');
insert into holiday (id,name,day) values(20110505,'ɤ','2011/05/05');
insert into holiday (id,name,day) values(20110718,'','2011/07/18');
insert into holiday (id,name,day) values(20110919,'Ϸ','2011/09/19');
insert into holiday (id,name,day) values(20110923,'ʬ','2011/09/23');
insert into holiday (id,name,day) values(20111010,'ΰ','2011/10/10');
insert into holiday (id,name,day) values(20111103,'ʸ','2011/11/03');
insert into holiday (id,name,day) values(20111123,'ϫդ','2011/11/23');
insert into holiday (id,name,day) values(20111223,'ŷ','2011/12/23');
insert into member (id,loginid, name, passwd) values (0, 'root', 'root', 'root');
insert into rolemember (roleid, memberid) values (0, 0);
insert into daosequence values('rhtym role id', 1);
insert into daosequence values('rhtym member id', 1);
insert into daosequence values('rhtym schedule id', 1);
insert into daosequence values('rhtym todoworker id', 1);
insert into daosequence values('rhtym todotree id', 1);
insert into daosequence values('rhtym addresscategory id', 1);
insert into daosequence values('rhtym addressbook id', 1);
insert into daosequence values('rhtym WindowPos id', 1);
insert into daosequence values('rhtym board id', 1);
insert into daosequence values('rhtym boardtree id', 1);
insert into daosequence values('rhtym RhythmTree id', 1);
insert into daosequence values('rhtym AssignPermission id', 1);
insert into daosequence values('rhythm com.kickmogu.rhythm.core.MailSetting id', 1);
insert into daosequence values('rhtym todo id', 1);
insert into daosequence values('rhtym timecard id', 1);
