/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/15
 *
 */
package com.kickmogu.rhythm.mail.ws;

import java.io.IOException;
import java.util.Map;

import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;

import org.apache.log4j.Category;

import com.kickmogu.rhythm.core.BaseResult;
import com.kickmogu.rhythm.core.HttpCmdAction;
import com.kickmogu.rhythm.core.Member;
import com.kickmogu.rhythm.core.dao.MemberDao;
import com.kickmogu.rhythm.mail.Mail;
import com.kickmogu.s2.S2Util;

public class FastMailList implements HttpCmdAction {
	
	static Category log = Category.getInstance(FastMailList.class.getName());

	public String listMails(Member loginMember, int mailSettingId, String folderName) throws MessagingException, IOException {
		MailWs mailWs = new MailWs();
  		
    	Folder target = mailWs.getTargetFolder(loginMember, mailSettingId, folderName);
		target.open(Folder.READ_ONLY);
		StringBuffer out = new StringBuffer();
		try {
			Message[] msgs = target.getMessages();
			FetchProfile fp = new FetchProfile();
			fp.add(FetchProfile.Item.ENVELOPE);
			fp.add(FetchProfile.Item.FLAGS);
			target.fetch(msgs, fp);
			  
			for (int i = 0; i < msgs.length; i++) {
				 if (!msgs[i].getFlags().contains(Flags.Flag.DELETED)) {
					 Mail mail = null;
					 try {
					     mail = mailWs.getMessage2Mail(i, msgs[i], false);
					     out.append(mail.getIdx() + "\t" + mail.getMsgId() + "\t" 
					    		 + (mail.getSubject() != null ? mail.getSubject().replace("\r", "").replace("\n", "") : "") + "\t" 
					    		 + (mail.getFromaddr() != null && mail.getFromaddr().length > 0 && mail.getFromaddr()[0] != null ? mail.getFromaddr()[0].replace("\r", "").replace("\n", "") : "") 
					    		 + "\t" + (mail.getSendDate() != null ? mail.getSendDate().getTime() : 0) + "\n");
					 } catch (Exception ex) {
						 log.error("listMails:" + mailSettingId + "," + folderName + "," + i, ex);
					 }
				 }
			}
		} finally {
			target.close(false);
		}
		return out.toString();
	}
    
	public BaseResult doAction(Map<String, String[]> params) throws Exception {
		int memberId = Integer.parseInt(params.get("memberId")[0]);
		int mailSettingId = Integer.parseInt(params.get("mailSettingId")[0]);
		MemberDao memdao = (MemberDao) S2Util.getS2Container().getComponent(MemberDao.class);
		Member member = memdao.getMember(memberId);
		BaseResult result = new BaseResult();
		result.setResult(listMails(member, mailSettingId, params.get("folderName")[0]));
		return result;
	}

}
