/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/15
 *
 */
package com.kickmogu.rhythm.todo.ws;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.kickmogu.rhythm.core.BaseResult;
import com.kickmogu.rhythm.core.HttpCmdAction;
import com.kickmogu.rhythm.core.Member;
import com.kickmogu.rhythm.core.dao.MemberDao;
import com.kickmogu.rhythm.todo.Todo;
import com.kickmogu.s2.S2Util;
import org.apache.commons.lang.StringUtils;

public class FastScheduleList implements HttpCmdAction {
	
    public BaseResult listSchedules(Member loginMember, Date fromDate, Date toDate) throws Exception {
    	TodoWs todoWs = new TodoWs();
  		BaseResult result = todoWs.listSchedules(loginMember, fromDate, toDate);
  		if (result.getStatusCode() != 0) {
  			return result;
  		}
		StringBuffer out = new StringBuffer();
		List<Todo> todos = (List<Todo>) result.getResult();
		for (int i = 0; i < todos.size(); i++) {
			out.append(StringUtils.join(new String[] {
					"" + todos.get(i).getId(),
					todos.get(i).getSubject(),
					todos.get(i).getPlanFromDate() == null ? "" : "" + todos.get(i).getPlanFromDate().getTime(),
					todos.get(i).getPlanToDate() == null ? "" : "" + todos.get(i).getPlanToDate().getTime(),
					}, "\t") + "\n");
		}
		result.setResult(out.toString());
		return result;
	}
    
	public BaseResult doAction(Map<String, String[]> params) throws Exception {
		int memberId = Integer.parseInt(params.get("memberId")[0]);
		MemberDao memdao = (MemberDao) S2Util.getS2Container().getComponent(MemberDao.class);
		Member member = memdao.getMember(memberId);
		member.setSessionId(params.get("sessionId")[0]);
		Date fromDate = new Date();
		fromDate.setTime(Long.parseLong(params.get("fromDate")[0]));
		Date toDate = new Date();
		toDate.setTime(Long.parseLong(params.get("toDate")[0]));
		return listSchedules(member, fromDate, toDate);
	}

}
