/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/19
 *
 */
package com.kickmogu.rhythm.core.ws;

import java.util.List;
import org.apache.log4j.Category;
import com.kickmogu.rhythm.core.*;

public class PermissionWs {
	static Category log = Category.getInstance(PermissionWs.class.getName());

	public BaseResult getAllByXml(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Permission root = (Permission) RhythmTreeManager.getRoot(Permission.class);
		result.setResult(root.toXmlAll());
		return result;
	}

	public BaseResult getPermitTarget(Member loginMember, String permCode) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		try {
			List<PermissionTarget> ptTree = loginMember.getAssignTarget(permCode);
			String[] resultXml = new String[ptTree.size()];
			for (int i = 0; ptTree != null && i < ptTree.size(); i++) {
				resultXml[i] = ptTree.get(i).toXmlAll();
			}
			result.setResult(resultXml);
		} catch (Exception e) {
			log.error(e);
		}
		return result;
	}
}
