/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/20
 *
 */
package com.kickmogu.rhythm.core;

import java.io.*;
import java.util.*;
import org.apache.log4j.Category;

import com.kickmogu.Config;
import com.thoughtworks.xstream.XStream;

public class RhythmTreeManager {
	static Category log = Category.getInstance(RhythmTreeManager.class.getName());

	private static Map roots = new HashMap();
	
	static private String getXmlFilename(String prefix) {
		return Config.getProperty(prefix + ".path.xml");
	}
	
	public static void refresh(Class targetClass) throws FileNotFoundException {
        Reader reader = new FileReader(getXmlFilename(targetClass.getCanonicalName()));
        XStream xstream = new XStream();
        RhythmTree root = (RhythmTree) xstream.fromXML(reader);
        setRoot(root);
	}
	
	public static RhythmTree getRoot(Class targetClass) {
		System.out.println("getRoot class" + targetClass.getName());
		if (roots.get(targetClass) == null) {
			try {
				refresh(targetClass);
			} catch (FileNotFoundException e) {
				log.error(e);
			}
		}
		return (RhythmTree) roots.get(targetClass);
	}
	
	public static void setRoot(RhythmTree r) {
		System.out.println("setRoot class" + r.getClass().getName());
		roots.put(r.getClass(), r);
	}
	
	public static void write(Class targetClass) throws IOException {
        Writer writer = new FileWriter(getXmlFilename(targetClass.getCanonicalName()));
        XStream xstream = new XStream();
        xstream.toXML(getRoot(targetClass), writer);
	}
	

}
