require 'FileUtils'
require 'debug/rpgxpdt_log.rb'
require 'debug/rgss_base.rb'
require 'scratch/data_compiler.rb'

def database_compile(project_dir)
  Debug.log("database_compile(#{project_dir})") if $DEBUG
  current_dir = Dir.pwd
  begin
    Dir.chdir(project_dir)
    Debug.log("Dir.chdir(#{project_dir})") if $DEBUG
    dc = Data_Compiler.new
    dc.compile(::RPG::State,'States')
    dc.compile(::RPG::Skill,'Skills')
    dc.compile(::RPG::Item,'Items')
    dc.compile(::RPG::Weapon,'Weapons')
    dc.compile(::RPG::Armor,'Armors')
    dc.compile(::RPG::Enemy,'Enemies')
    dc.setup_weapon_equip_data
    dc.setup_armor_equip_data
    dc.setup_skill_learnings_data
  rescue => evar
    p $!
    p evar
  end
  Dir.chdir(current_dir)
  Debug.log("Dir.chdir(#{current_dir})") if $DEBUG
end
