class Data_Compiler
  def initialize
    @loads = {}
    @system = load_data('Data/System.rxdata')
    @map_elements = {}
    @system.elements.each_index() do |i|
      name = @system.elements[i]
      @map_elements[name] = i if not name.nil?
    end
    @enemy_actions = load_csv(::RPG::Enemy::Action,'EnemiesActions',{})
  end

  def load(klass,name)
    return compile(klass,name)
  end

  def load_map(klass,name)
    list = compile(klass,name)
    if @loads[name].key?('map')
      return @loads[name]['map']
    end
    result = {}
    list.each() do |o|
      if not o.nil?
        result[o.name] = o
      end
    end
    @loads[name]['map'] = result
    return @loads[name]['map']
  end

  def compile(klass,name)
    if update?(name)
      Debug.log("compile #{name}") if $DEBUG
      @loads.delete(name)
      data_list = load_csv(klass,name)
      if not data_list.nil?
        for i in 1 ... data_list.size
          if data_list[i].nil?
            data_list[i] = klass.new
            data_list[i].id = i
          end
        end
        datafilename = data_filename(name)
        save_data(data_list,datafilename)
        Debug.log("save_data #{datafilename}") if $DEBUG
      end
    end
    if @loads.key?(name)
      return @loads[name]['list']
    end
    @loads[name] = {}
    @loads[name]['list'] = load_data(data_filename(name))
    return @loads[name]['list']
  end

  def update?(name)
    file1 = csv_filename(name)
    file2 = data_filename(name)
    return false unless FileTest.exist?(file1)
    return true unless FileTest.exist?(file2)
    t1 = File.mtime(file1)
    t2 = File.mtime(file2)
    return t1 > t2
  end

  def csv_filename(name)
    return "csv/DB/#{name}.csv"
  end

  def data_filename(name)
    return "Data/#{name}.rxdata"
  end

  def read_keys(file)
    # sڂvpeBiځj
    list = nil
    while not file.eof?
      line = file.gets
      line.gsub!(/\r|\n|"/,'')
      next if line =~ /^#/
      next if line =~ /^$/
      break
    end
    return line.split(/,/).collect do |k|
      k.gsub(/"/,'').strip
    end
  end

  RANK_DATA = {
    'A' => 1,
    'B' => 2,
    'C' => 3,
    'D' => 4,
    'E' => 5,
    'F' => 6
  }

  def create_data(klass,keys,values,map_data={})
    data = klass.new
    # vpeBiځj
    for key in keys
      # ԂɎ擾
      value = values.shift
      if not value.nil?
        value.gsub!(/"/,'')
      end
      if (not value.nil?) and (not value.empty?)
        # ^ϊ
        (key_name,key_type) = key.split(/:/)
        case key_type
        when 'n'
          value = value.to_i
        when 'b'
          value = (value == 'TRUE' or value == 'true')
        when 's'
          value = value.split(/\s+/)
        when 'sn'
          value = value.split(/\s+/).collect() {|v|v.to_i}
        when 'se'
          args = value.split(/\s+/)
          if not args[1].nil?
            args[1] = args[1].to_i
          end
          value = ::RPG::AudioFile.new(*args)
        when 'tn' # Table.new() l
          if key_name == 'state_ranks'
            rank_map = {}
            value.split(/\s+/).each() do |e|
              (key,rank) = e.split(/:/)
              next if key.nil? or rank.nil?
              if RANK_DATA.member?(rank)
                rank_map[key] = RANK_DATA[rank]
              else
                rank_map[key] = rank.to_i
              end
            end
            value = [0]
            load(::RPG::State,'States').each() do |state|
              next if state.nil?
              if rank_map.member?(state.name)
                value[state.id] = rank_map[state.name]
              else
                value[state.id] = 3
              end
            end
          elsif key_name == 'element_ranks'
            rank_map = {}
            value.split(/\s+/).each() do |e|
              (key,rank) = e.split(/:/)
              next if key.nil? or rank.nil?
              if RANK_DATA.member?(rank)
                rank_map[key] = RANK_DATA[rank]
              else
                rank_map[key] = rank.to_i
              end
            end
            value = [0]
            @system.elements.each_index() do |i|
              name = @system.elements[i]
              next if name.nil? or name.empty?
              if rank_map.member?(name)
                value[i] = rank_map[name]
              else
                value[i] = 3
              end
            end
          else
            value = value.split(/\s+/).collect() {|v|v.to_i}
          end
          t = Table.new(value.size)
          value.each_index() do |i|
            t[i] = value[i]
          end
          value = t
        when 'd'
          map_data[key_name] = value
          next
        when 'elements_id'
          list = []
          value.split(/\s+/).each do |v|
            list.push(@map_elements[v])
          end
          value = list
        when 'states_id'
          map_states = load_map(::RPG::State,'States')
          states = []
          value.split(/\s+/).each do |v|
            states.push(map_states[v].id)
          end
          value = states
        when 'skill_id'
          map_skills = load_map(::RPG::Skill,'Skills')
          if value =~ /^[0-9]+$/
            value = value.to_i
          else
            value = map_skills[value].id
          end
        when 'actions'
          actions = []
          if not @enemy_actions.nil?
            value.split(/\s+/).each do |v|
              (name,rating) = v.split(/:/)
              if @enemy_actions.key?(name)
                action = Marshal.load(Marshal.dump(@enemy_actions[name]))
                if not rating.nil?
                  action.rating = rating.to_i()
                end
                actions.push(action)
              end
            end
          end
          value = actions
        end
        map_data[key_name] = value
        begin
          # lݒ
          data.method(key_name + '=').call(value)
        rescue
        end
      end
    end
    return data
  end

  def load_csv(klass,name,result=[],dummy_result={})
    csvfile = csv_filename(name)
    return nil unless FileTest.exist?(csvfile)
    Debug.log("load_csv #{csvfile}") if $DEBUG
    # bruǂݍ
    File.open(csvfile) do |file|
      keys = read_keys(file)
      # ȍ~f[^vpeB
      while not file.eof?
        line = file.gets
        line.gsub!(/\r|\n|"/,'')
        next if line =~ /^#/
        next if line =~ /^$/
        values = line.split(/,/,keys.size).collect {|v| v.strip}
        next if values.empty?
        i = nil
        if values[0] =~ /^[0-9]+$/
          i = values[0].to_i
        else
          i = values[0]
          next if i.empty?
        end
        map_data = {}
        data = create_data(klass,keys,values,map_data)
        dummy_result[i] = map_data
        result[i] = data
      end
    end
    return result
  end

  def setup_weapon_equip_data
    Debug.log("setup_weapon_equip_data()") if $DEBUG
    weapon_sets = []
    data_weapons = load_csv(::RPG::Weapon,'Weapons',[],weapon_sets)
    return if data_weapons.nil?
    data_classes = load_data('Data/Classes.rxdata')
    data_classes.each_index() do |class_id|
      klass = data_classes[class_id]
      next if klass.nil?
      weapon_set_key = 'equip_' + class_id.to_s
      weapon_set = []
      data_weapons.each_index() do |weapon_id|
        next if data_weapons[weapon_id].nil?
        if not weapon_sets[weapon_id][weapon_set_key].nil?
          weapon_set.push(weapon_id)
        end
      end
      klass.weapon_set = weapon_set
    end
    Debug.log("save_data Data/Classes.rxdata") if $DEBUG
    save_data(data_classes,'Data/Classes.rxdata')
  end

  def setup_armor_equip_data
    Debug.log("setup_armor_equip_data()") if $DEBUG
    armor_sets = []
    data_armors = load_csv(::RPG::Armor,'Armors',[],armor_sets)
    return if data_armors.nil?
    data_classes = load_data('Data/Classes.rxdata')
    data_classes.each_index() do |class_id|
      klass = data_classes[class_id]
      next if klass.nil?
      armor_set_key = 'equip_' + class_id.to_s
      armor_set = []
      data_armors.each_index() do |armor_id|
        next if data_armors[armor_id].nil?
        if not armor_sets[armor_id][armor_set_key].nil?
          armor_set.push(armor_id)
        end
      end
      klass.armor_set = armor_set
    end
    Debug.log("save_data Data/Classes.rxdata") if $DEBUG
    save_data(data_classes,'Data/Classes.rxdata')
  end

  # NXŊoXLf[^ݒ
  def setup_skill_learnings_data
    Debug.log("setup_skill_learnings_data()") if $DEBUG
    skills_sets = []
    data_skills = load_csv(::RPG::Skill,'Skills',[],skills_sets)
    return if data_skills.nil?
    data_classes = load_data('Data/Classes.rxdata')
    data_classes.each_index() do |class_id|
      klass = data_classes[class_id]
      next if klass.nil?
      learnings_set_key = 'learnings_' + class_id.to_s
      learnings_set = []
      data_skills.each_index() do |skill_id|
        next if data_skills[skill_id].nil?
        if not skills_sets[skill_id][learnings_set_key].nil?
          learning = ::RPG::Class::Learning.new
          learning.level = skills_sets[skill_id][learnings_set_key].to_i
          learning.skill_id = skill_id
          learnings_set.push(learning)
        end
      end
      klass.learnings = learnings_set.sort() {|a,b| a.level <=> b.level}
    end
    Debug.log("save_data Data/Classes.rxdata") if $DEBUG
    save_data(data_classes,'Data/Classes.rxdata')
  end

end
