# ACegf[^p[T
# Author:: fukuyama
# Date:: 2008/12/14
# Copyright:: Copyright (c) 2008 rgss-lib

module Parser

  # ACegf[^p[T
  class Item_Attribute_Parser < Parser_Base

    # 
    def initialize
      super
      @klass = RPG::Item_Attribute
      @names = ['datakey','exp_type','attr_name','attr_value']
      @exp_types = {
        'normal_fix'    => RPG::Item_Attribute::TYPE_NORMAL_FIX,
        'normal_range'  => RPG::Item_Attribute::TYPE_NORMAL_RANGE,
        'percent_fix'   => RPG::Item_Attribute::TYPE_PERCENT_FIX,
        'percent_range' => RPG::Item_Attribute::TYPE_PERCENT_RANGE,
        'method' => RPG::Item_Attribute::TYPE_METHOD,
      }
      add_parse('exp_type',:parse_exp_type)
      add_parse('attr_value',:parse_attr_value)
    end

    # g^Cvp[X
    def parse_exp_type(v)
      @exp_types[v]
    end

    # lp[X
    def parse_attr_value(v)
      if v =~ /^([+-]?[0-9]+)\s*\.\.\s*([+-]?[0-9]+)$/
        v = $1.to_i .. $2.to_i
      elsif v =~ /^([+-]?[0-9]+)\s*\-\s*([+-]?[0-9]+)$/
        v = $1.to_i .. $2.to_i
      elsif v =~ /^([+-]?[0-9]+)\s*\.\.\.\s*([+-]?[0-9]+)$/
        v = $1.to_i ... $2.to_i
      elsif v =~ /^([+-]?[0-9]+)$/
        v = $1.to_i
      end
      return v
    end

  end

end
