#==============================================================================
#  Markup_Graphics
#------------------------------------------------------------------------------
# }[NAbvOtBbNX
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \face[...]
# \face_close
# \img[folder_name,file_name]
#
# Window_Messagep
#==============================================================================

module Markup_Graphics_Image
  module_function
  def query
    return /^\\img\[(.+?),(.+?)\]/
  end
  def transfer(instance, bmp, x, y, text, match)
    folder_name = match[1]
    file_name = match[2]
    hue = 0
    img = RPG::Cache.load_bitmap('Graphics/' + folder_name,file_name,hue)
    size = bmp.font.size
    bmp.stretch_blt(Rect.new(x, y, size, size), img, img.rect)
    text[query] = ''
    return x + size,y,text
  end
end
String_Operation_Module.add_markup(Markup_Graphics_Image)

module Markup_Graphics_Face
  @@face_window = nil
  @@face_window_script = nil
  module_function
  def query
    return /^\\face\[([A-Za-z0-9_]+)\]/
  end
  def transfer(instance, bmp, x, y, text, match)
    picture = match[1]
    picture_bmp = RPG::Cache.picture(picture)
    w = Markup_Graphics_Face.face_window_open picture_bmp
    Markup_Graphics_Face.face_window_script.bitmap = picture_bmp
    text[query] = ''
    return x,y,text
  end
  def face_window_script
    return @@face_window_script
  end
  def face_window_open(picture_bmp)
    if @@face_window.nil?
      @@face_window = Window_Base.new(0,0,picture_bmp.width + 32,picture_bmp.height + 32)
      @@face_window_script = Sprite.new(@@face_window.viewport)
    end
    @@face_window.bottom = $scene.message_window.top
    @@face_window.left = $scene.message_window.left
    @@face_window_script.x = @@face_window.left + 16
    @@face_window_script.y = @@face_window.top + 16
    @@face_window_script.z = @@face_window.z + 100
    return @@face_window
  end
  def face_window_close
    if not @@face_window.nil?
      @@face_window.dispose
      @@face_window = nil
      @@face_window_script.dispose
      @@face_window_script = nil
    end
  end
end

String_Operation_Module.add_markup(Markup_Graphics_Face)

module Markup_Graphics_Face2
  module_function
  def query
    return /^\\face\[([A-Za-z0-9_]+),([0-1])\]/
  end
  def transfer(instance, bmp, x, y, text, match)
    picture = match[1]
    mirror = match[2].to_i == 1
    picture_bmp = RPG::Cache.picture(picture)
    w = Markup_Graphics_Face.face_window_open picture_bmp
    Markup_Graphics_Face.face_window_script.mirror = mirror
    Markup_Graphics_Face.face_window_script.bitmap = picture_bmp
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Graphics_Face2)

module Markup_Graphics_Face_Close
  @@face_window = nil
  module_function
  def query
    return /^\\face_close/
  end
  def transfer(instance,bmp, x, y, text, match)
    Markup_Graphics_Face.face_window_close
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Graphics_Face_Close)
