#==============================================================================
#  Window_Target_Module
#------------------------------------------------------------------------------
# ^[QbgEBhEW[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  module Battle
    
    module Window_Target_Module
      def target_actor(last_select = false)
        window = Window_Target_Actor.new(self)
        if last_select
          window.index = window.menu_size - 1
        end
        set_active_window(window.class)
      end
      def target_enemy(last_select = false)
        window = Window_Target_Enemy.new(self)
        if last_select
          window.index = window.menu_size - 1
        end
        set_active_window(window.class)
      end
      def next_window(object)
        if object.scope == 1            # GP̂̏ꍇ
          target_enemy
        elsif object.scope == 2         # GŜ̏ꍇ
          window = get_window(Window_Actor_Command)
          window.targets = $game_troop.enemies
          top_window.dispose
        elsif [3,5].include? object.scope      # P̂̏ꍇ
          target_actor
        elsif [4,6].include? object.scope      # Ŝ̏ꍇ
          window = get_window(Window_Actor_Command)
          window.targets = $game_party.actors
          top_window.dispose
        elsif 7 == object.scope                    # gp҂̏ꍇ
          window = get_window(Window_Actor_Command)
          window.targets = [window.actor]
          top_window.dispose
        end
      end
    end
    
  end
end
