# Sprite_Page_Arrow
# Author:: fukuyama
# Date:: 2007/05/27
# Copyright:: Copyright (c) 2005,2006 rgss-lib

module DQ
  # A[^CvJ[\NX
  class Sprite_Page_Arrow < Sprite_Cursor
    # 
    def initialize(name,viewport)
      super(viewport)
      self.bitmap = Script_Bitmap.get("#{name}_arrow")
    end
  end

  # EA[J[\
  class Sprite_Page_Right_Arrow < Sprite_Page_Arrow
    # 
    def initialize(viewport)
      super('right',viewport)
    end

  end

  # A[J[\
  class Sprite_Page_Left_Arrow < Sprite_Page_Arrow
    # 
    def initialize(viewport)
      super('left',viewport)
    end

  end

  module Sprite_Page_Arrow_Module
    # 
    def initialize(*arg)
      super(*arg)
      @sprite_page_right_arrow = Sprite_Page_Right_Arrow.new(self.viewport)
      @sprite_page_left_arrow = Sprite_Page_Left_Arrow.new(self.viewport)
      @sprite_page_right_arrow.visible = false
      @sprite_page_left_arrow.visible = false
      #      @sprite_page_right_arrow.white_blink_on
      #      @sprite_page_left_arrow.white_blink_on
    end

    # j
    def dispose
      super
      @sprite_page_right_arrow.dispose
      @sprite_page_left_arrow.dispose
    end

    # XV
    def update
      if self.contents.width > (self.width - 32)
        if (self.ox + self.width - 32) < self.contents.width
          @sprite_page_right_arrow.visible = true
          @sprite_page_right_arrow.z = self.z + 1
          @sprite_page_right_arrow.x = self.x + self.width - @sprite_page_right_arrow.src_rect.width
          @sprite_page_right_arrow.y = self.y + self.height - @sprite_page_right_arrow.src_rect.height
          #          @sprite_page_right_arrow.update
        else
          @sprite_page_right_arrow.visible = false
        end
        if self.ox > 0
          @sprite_page_left_arrow.visible = true
          @sprite_page_left_arrow.z = self.z + 1
          @sprite_page_left_arrow.x = self.x
          @sprite_page_left_arrow.y = self.y + self.height - @sprite_page_left_arrow.src_rect.height
          #          @sprite_page_left_arrow.update
        else
          @sprite_page_left_arrow.visible = false
        end
      else
        @sprite_page_right_arrow.visible = false
        @sprite_page_left_arrow.visible = false
      end
      super
    end

    # \
    def visible=(v)
      super(v)
      unless v
        @sprite_page_right_arrow.visible = v
        @sprite_page_left_arrow.visible = v
      end
    end

  end

end
