# XvCgړW[
# Author:: fukuyama
# Date:: 2006/11/27
# Copyright:: Copyright (c) 2005,2006 rgss-lib.sourceforge.jp

# XvCgړW[
module Sprite_Move_Module
  # ړIɌĂ΂郁\bh
  attr_accessor :move_end_proc
  def initialize(*args)
    super(*args)
    @_move_paths = nil
    @_move_count = 0
    @_wait_count = 0
  end

  # ړȂtrue
  def moving?
    return ((@_move_count > 0) or (@_wait_count > 0) or (not @_move_paths.nil?))
  end

  # ړȂtrue
  alias move? moving?

  def wait=(n)
    return true if @_move_count > 0
    @_wait_count = n
  end

  # ݒnw肵ړ
  def move_by(x,y,opacity = 0,velocity = 10)
    return false if move?
    @_to_x = self.x + x
    @_to_y = self.y + y
    @_to_opacity = self.opacity + opacity
    @_move_count = velocity
  end

  # w肵ꏊ猻ݒnɈړ
  def move_from(x,y,opacity = self.opacity,velocity = 10)
    return false if move?
    return false if x == self.x and y == self.y and opacity == self.opacity
    @_to_x = self.x
    @_to_y = self.y
    @_to_opacity = self.opacity
    @_move_count = velocity
    self.x = x
    self.y = y
    self.opacity = opacity
  end

  # ݒnw肵ꏊɈړ
  def move_to(x,y,opacity = self.opacity,velocity = 10)
    return false if move?
    return false if x == self.x and y == self.y and opacity == self.opacity
    @_to_x = x
    @_to_y = y
    @_to_opacity = opacity
    @_move_count = velocity
  end

  # ̃pX
  def next_move_path()
    path = @_move_paths[@_move_path_index]
    @_move_path_index += 1
    return path
  end

  # ړpX̐ݒ
  def set_move_paths(move_paths)
    @_move_count = 0
    @_move_path_index = 0
    @_move_paths = move_paths
    exec_move_paths()
  end

  # pX̎s
  def exec_move_paths
    # ̃pX
    path = next_move_path()
    if path.nil?
      # ΏI
      @_move_count = 0
      @_move_path_index = 0
      @_move_paths = nil
      @move_end_proc = nil
      return
    end
    # pXs
    (m,*args) = path
    send(m,*args)

    # P̃pXI玟s
    @move_end_proc = method(:exec_move_paths)
  end

  # EBhEړ
  def update
    if move?
      if @_wait_count > 0
        @_wait_count -= 1
      elsif @_move_count >= 0
        x = ((@_to_x - self.x) / @_move_count).round
        y = ((@_to_x - self.y) / @_move_count).round
        opacity = ((@_to_opacity - self.opacity) / @_move_count).round
        self.y += y
        self.x += x
        self.opacity += opacity
        @_move_count -= 1
        if @_move_count == 0 and (not @move_end_proc.nil?)
          exec_proc = @move_end_proc
          @move_end_proc = nil
          exec_proc.call
        end
      end
      # return
    end
    super
  end
end # Sprite_Move_Module

class Move_Sprite < RPG::Sprite
  include Sprite_Move_Module
end
