# Q[
# Auther:: a
# Date:: 2006/03/03
# Copyright:: Copyright (c) 2006 a(rgss-lib)

# Q[ԃW[
module GameTime
  # Ԃɑ΂{B
  # Ⴆ 1 ƌƓB
  # 2 ƌ 12 Ԃ 1 ɂȂB
  @@rate  = 12
  # j̐ݒ
  # KvȕׂĂ
  WEEKDAY = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
  # 1̓
  DAY_PER_MONTH = 30
  # 1Ň
  MONTH_PER_YEAR = 12

  # Q[ԍ\
  TIME = Struct.new(:year, :month, :day, :week, :hour, :minute, :second)
  REAL_DAY      = 86400                           # 24*60*60
  @@vertual_day = 1.0 * REAL_DAY / @@rate         # Q[P̌ł̕b
  @@vertual_h   = @@vertual_day / 24              # Q[PԂ̌ł̕b
  @@vertual_min = @@vertual_h / 60                # Q[P̌ł̕b
  @@vertual_sec = @@vertual_min / 60              # Q[Pb̌ł̕b
  @@offset_rtime = 0                              # ƂȂ錻
  @@offset_vtime = TIME.new(1, 1, 1, 0, 0, 0, 0)  # @@offset_rtimeł̃Q[

  # zx̐ݒ
  # new_rate:: Vzx
  # Return::   ݒ肵l
  def self.rate=(new_rate)
    @@rate = new_rate

    @@vertual_day = 1.0 * REAL_DAY / @@rate
    @@vertual_h   = @@vertual_day / 24
    @@vertual_min = @@vertual_h / 60
    @@vertual_sec = @@vertual_min / 60

    return @@rate
  end

  # zx̎擾
  # Return::   ݒ肳Ăl
  def self.rate
    return @@rate
  end

  # Q[ݎ̐ݒ
  #
  # GameTime.now(time)
  # @- time : GameTime::TIME\
  #
  # GameTime.now(year,month,day,week,hour,minute,second)
  # @- SĐœnƁB
  #
  # Return::   ݒ肵zԂ̍\
  def self.now=(*new_time)
    if new_time.size == 1
      if new_time[0].is_a?(self.TIME)
        @@offset_vtime = new_time[0]
        @@offset_rtime = Time.now.to_f
      end
    elsif new_time.size == 7
      buf = self.TIME.new
      buf.year   = new_time[0].to_i
      buf.month  = new_time[1].to_i
      buf.day    = new_time[2].to_i
      buf.week   = new_time[3].to_i
      buf.hour   = new_time[4].to_i
      buf.minute = new_time[5].to_i
      buf.second = new_time[6].to_i
      @@offset_vtime = buf
      @@offset_rtime = Time.now.to_f
    end
    return @@offset_vtime
  end

  # ݃Q[Ԃ̎擾
  # Return:: GameTime::TIME\
  def self.now
    real_now = Time.now.to_f
    real_now -= @@offset_rtime

    buf = self::TIME.new

    day = (real_now / @@vertual_day).floor
    buf.day   = day % self::DAY_PER_MONTH + 1
    buf.month = (day / self::DAY_PER_MONTH) % self::MONTH_PER_YEAR + 1
    buf.year  = day / self::DAY_PER_MONTH / self::MONTH_PER_YEAR
    buf.week  = day % self::WEEKDAY.size

    buf.hour   = (real_now / @@vertual_h % 24).floor
    buf.minute = (real_now / @@vertual_min % 60).floor
    buf.second = (real_now / @@vertual_sec % 60).floor

    return self.add_time_and_time(buf, @@offset_vtime)
  end

  # Ԃ̑Z
  # a::      (GameTime::TIME\)
  # b::      (GameTime::TIME\)
  # Return:: ab𑫂(GameTime::TIME\)
  def self.add_time_and_time(a, b)
    ret = self::TIME.new
    ret.second = (a.second + b.second) % 60
    upper      = (a.second + b.second) / 60
    ret.minute = (a.minute + b.minute + upper) % 60
    upper      = (a.minute + b.minute + upper) / 60
    ret.hour   = (a.hour   + b.hour   + upper) % 24
    upper      = (a.hour   + b.hour   + upper) / 24
    ret.week   = (a.week   + b.week   + upper) % self::WEEKDAY.size
    ret.day    = (a.day - 1 + b.day - 1 + upper) % self::DAY_PER_MONTH + 1
    upper      = (a.day - 1 + b.day - 1 + upper) / self::DAY_PER_MONTH
    ret.month  = (a.month + b.month - 2 + upper) % self::MONTH_PER_YEAR + 1
    upper      = (a.month + b.month - 2 + upper) / self::MONTH_PER_YEAR
    ret.year   =  a.year   + b.year   + upper
    return ret
  end
end
