#==============================================================================
#  Floating_Window
#------------------------------------------------------------------------------
# t[eBOEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# t[eBOEBhEJi쐬j
# window = open_floating_window(name,x,y,width,height)
#   name   EBhEʂ邽߂̖O
#   x,y    EBhËʒu
#   width  EBhEe̕
#   height EBhEe̍
#   EBhEIuWFNg(Floating_Window)ԋp܂
#   Floating_WindoẃABitmapNXŎgpł郁\bhg܂B
#
# t[eBOEBhE̎擾
# window = get_floating_window(name)
#   name   EBhEʂ邽߂̖O
#   EBhEIuWFNg(Floating_Window)ԋp܂
#
# t[eBOEBhEi폜j
# close_floating_window(name)
#   name   EBhEʂ邽߂̖O
#
#==============================================================================

module Floating_Window_Module

#------------------------------------------------------------------------------
# t[eBOEBhE
# Ȃ\bhcontents(Bitmap)Ŏs
#------------------------------------------------------------------------------
class Floating_Window < Window_Base
  def initialize(x, y, width, height)
    super(x, y, width+32, height+32)
    self.contents = Bitmap.new(width, height)
  end
  def method_missing(name,*args)
    if self.contents.class.method_defined?(name)
      self.contents.method(name).call(*args)
    else
      super
    end
  end
  def center
    self.x = 640 / 2 - self.width / 2
    self.y = 480 / 2 - self.height / 2
  end
end

module Event_Script
  #----------------------------------------------------------------------------
  # t[eBOEBhEJ
  #----------------------------------------------------------------------------
  def open_floating_window(name,x,y,w,h)
    window = get_floating_window(name)
    return window if not window.nil?
    window = Floating_Window.new(x,y,w,h)
    $scene.float_windows[name] = window
    return window
  end
  #----------------------------------------------------------------------------
  # t[eBOEBhE擾
  #----------------------------------------------------------------------------
  def get_floating_window(name)
    $scene.float_windows[name]
  end
  #----------------------------------------------------------------------------
  # t[eBOEBhE
  #----------------------------------------------------------------------------
  def close_floating_window(name)
    window = $scene.float_windows.delete name
    window.dispose if not window.nil?
  end
end

end # module Floating_Window_Module

#------------------------------------------------------------------------------
# C^v^[ɃW[gݍ
#------------------------------------------------------------------------------
class Interpreter
  include Floating_Window_Module::Event_Script
end

#------------------------------------------------------------------------------
# V[}bv̍Ē`
#------------------------------------------------------------------------------
class Scene_Map
  def float_windows
    @float_windows = {} if @float_windows.nil?
    return @float_windows
  end
  #----------------------------------------------------------------------------
  # t[eBOEBhEnbV̏ƌ㏈
  #----------------------------------------------------------------------------
  alias float_window_original_main main
  def main
    float_window_original_main
    self.float_windows.each_value do |window|
      window.dispose
    end
  end
  #----------------------------------------------------------------------------
  # t[eBOEBhE̍XV
  #----------------------------------------------------------------------------
  alias float_window_original_update update
  def update
    float_window_original_update
    self.float_windows.each_value do |window|
      window.update
    end
  end
end
