#==============================================================================
#  Window_Shop
#------------------------------------------------------------------------------
# ACe𔃂EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_Shop < Window_Menu
  include Window_Tree_Module

  def initialize(shop_goods)
    @price_rate = 100
    @shop_goods = shop_goods
    for goods_item in @shop_goods
      case goods_item[0]
      when 0
        item = $data_items[goods_item[1]]
      when 1
        item = $data_weapons[goods_item[1]]
      when 2
        item = $data_armors[goods_item[1]]
      end
      if not item.nil?
        add_menu(item,:select_item)
      end
    end
    @row_max = WINDOW_SHOP_BUY_ROW_MAX
    @index = 0
    super(nil)
    self.top = 16
    self.left = 16
    @window_gold = Window_Gold.new
    @window_gold.x = 640 - @window_gold.width - 16
    @window_gold.y = 16
    @window_gold.back_opacity = self.back_opacity
    add_child @window_gold

    @window_shop_status = Window_Shop_Actor_Status.new
    @window_shop_status.back_opacity = self.back_opacity
    @window_shop_status.set_item self.item
    add_child @window_shop_status
  end

  def price_rate=(rate)
    @price_rate = rate
    refresh
  end

  def item
    return get_menu
  end

  def select_item
    price = (item.price * (@price_rate.to_f / 100.0)).to_i
    if price > $game_party.gold
      buzzer_se
      return
    end
    decision_se
    dispose
  end

  def input_up
    super
    @window_shop_status.set_item self.item
  end

  def input_down
    super
    @window_shop_status.set_item self.item
  end

  def input_b
    if Input.trigger?(Input::B)
      @index = -1
    end
    super
  end

  #--------------------------------------------------------------------------
  # ڂ̕`
  #--------------------------------------------------------------------------
  def draw_menu_item(index,color,rect,item)
    # ivZ
    price = (item.price * (@price_rate.to_f / 100.0)).to_i
    # ȂꍇAFύX
    if price <= $game_party.gold
      self.contents.font.color = color
    else
      self.contents.font.color = disabled_color
    end

    self.contents.fill_rect(rect, Color.new(0, 0, 0, 0))
    bitmap = RPG::Cache.icon(item.icon_name)
    opacity = self.contents.font.color == normal_color ? 255 : 128
    self.contents.blt(rect.x, rect.y, bitmap, Rect.new(0, 0, 24, 24), opacity)
    rect.x += 24
    rect.width -= 24
    self.contents.draw_text(rect, item.name, 0)
    self.contents.draw_text(rect, price.to_s, 2)
  end

  #---------------------------------------------------------------------------
  # Rec̍쐬
  def _contents_width
    return _menu_width * @column_max
  end
  #---------------------------------------------------------------------------
  # j[̍쐬
  def _menu_width
    return WINDOW_SHOP_BUY_WIDTH
  end
end

end
