#==============================================================================
#  Event_Script_Shop
#------------------------------------------------------------------------------
# VbvpCxgXNvgiACej
# Copyright (C) 2005 fukuyama
#==============================================================================

module Event_Script
module Shop

  # CEBhE
  @@window = nil

  # wACe
  @@item = nil

  module_function

  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def buy
    n = 1
    actor = Event_Script::Buy_Actor_Select.actor
    if actor.nil?
      actor = $game_party
    end
    if item?
      Item_Facade.gain_item(@@item.id,n,actor)
    elsif weapon?
      Item_Facade.gain_weapon(@@item.id,n,actor)
    elsif armor?
      Item_Facade.gain_armor(@@item.id,n,actor)
    end
    $game_party.lose_gold( (@@item.price * (@@price_rate.to_f / 100.0)).to_i )
  end

  #----------------------------------------------------------------------------
  # 
  #----------------------------------------------------------------------------
  def sell
    item = Event_Script::Sell_Actor_Select.item
    item = Event_Script::Sell_Actor_Select.weapon if item.nil?
    item = Event_Script::Sell_Actor_Select.armor if item.nil?
    actor = Event_Script::Sell_Actor_Select.actor
    if actor.nil?
      actor = $game_party
    end
    Item_Facade.throw_item(item,actor)
    $game_party.gain_gold(item.sell_price)
  end

  #----------------------------------------------------------------------------
  # ̔i
  #----------------------------------------------------------------------------
  def price_rate=(rate)
    if not @@window.nil?
      @@window.price_rate = rate
      @@price_rate = rate
    end
  end

  #----------------------------------------------------------------------------
  # EBhEJ
  #----------------------------------------------------------------------------
  def open(shop_goods)
    if @@window.nil?
      @@window = DQ::Window_Shop.new(shop_goods)
      @@price_rate = 100
      @@window.visible = false
    end
    @@item = nil
  end

  #----------------------------------------------------------------------------
  # EBhE
  #----------------------------------------------------------------------------
  def close()
    if not @@window.disposed?
      @@window.dispose
    end
    @@window = nil
  end

  #----------------------------------------------------------------------------
  # EBhE̍XV
  #----------------------------------------------------------------------------
  def update(variable_id)
    result = @@window.disposed?
    if result
      if @@window.item.nil?
        $game_variables[variable_id] = -1
        @@item = nil
      else
        @@item = @@window.item
        $game_variables[variable_id] = @@item.id
      end
      close()
    else
      @@window.visible = true
      @@window.update
    end
    return result
  end

  def item?
    return @@item.is_a? RPG::Item
  end
  def weapon?
    return @@item.is_a? RPG::Weapon
  end
  def armor?
    return @@item.is_a? RPG::Armor
  end
  def item
    return nil if not item?
    return @@item
  end
  def weapon
    return nil if not weapon?
    return @@item
  end
  def armor
    return nil if not armor?
    return @@item
  end

end
end
