#==============================================================================
#  Window_Item
#------------------------------------------------------------------------------
# ACeEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Window_Item < Window_Item_Base
  include Window_Target_Module

  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(parent,actor)
    @actor = actor
    @index = 0
    @column_max = 2
    @row_max = 3

    super(parent)

    # EBhEʒu
    self.top  = top_window.top
    self.left = top_window.left

    # ACewvEBhE쐬
    x = self.left
    y = self.bottom
    w = self.width
    h = 32 + 32
    @window_help = Window_Markup_Text.new(x,y,w,h)
    @window_help.back_opacity = WINDOW_BACK_OPACITY

    # qEBhEɒǉ
    add_child @window_help
    @window_help.visible = false
  end
  #--------------------------------------------------------------------------
  # Cxgnh
  #--------------------------------------------------------------------------
  def input_b
    if Input.trigger?(Input::B)
      @index = -1
      cancel_se
      dispose
    end
  end
  def select_item
    if item.is_a? Game_Item
      window = get_window(Window_Actor_Command)
      window.item = item
      window.item_use = true
      if Item_Facade.get_use_item(item).nil?
        top_window.dispose
        return
      end
      next_window Item_Facade.get_use_item(item)
    else
      window = Window_Item_Menu.new(self)
      add_child window
      set_active_window(window.class)
    end
  end
  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    super
    if not @window_help.disposed?
      @window_help.visible = (self.active or child_window_active?)
    end
    if (not Input.press?(Input::UP)) and (not Input.press?(Input::DOWN))
      if @index != @refresh_help_index and @index >= 0
        refresh_help
        @refresh_help_index = @index
      end
    end
  end
  #--------------------------------------------------------------------------
  # ĕ`
  #--------------------------------------------------------------------------
  def refresh
    self.clear
    refresh_actor_items
    refresh_help
    super
  end
  def refresh_help
    if (not @window_help.nil?) and (not @window_help.disposed?)
      if not self.item.nil?
        @window_help.set_text self.item.description
      else
        @window_help.set_text ""
      end
    end
  end
end

end
end
