#==============================================================================
#  Markup_Replaces
#------------------------------------------------------------------------------
# 퓬p}[NAbv
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle
module Markup_Replaces

module Markup_Target_Battler
  module_function
  def query
    return /\\target\.([a-z_]+)/
  end
  def transfer(instance, text, match)
    if Markup_Battle.target.nil?
      text[query] = ''
    else
      name = match[1].to_s
      result = ''
      if name == 'damage' or name == 'damage_sp'
        damage = Markup_Battle.target.method(name).call
        if damage.is_a? Numeric
          result = damage.abs.to_s
        else
          result = damage
        end
      else
        result = Markup_Battle.target.method(name).call.to_s
      end
      text[query] = result
    end
  end
end

module Markup_Active_Battler
  module_function
  def query
    return /\\active_battler\.name/
  end
  def transfer(instance, text, match)
    if Markup_Battle.active_battler.nil?
      text[query] = ''
    else
      text[query] = Markup_Battle.active_battler.name
    end
  end
end

module Markup_Skill
  module_function
  def query
    return /\\skill\.name/
  end
  def transfer(instance, text, match)
    if Markup_Battle.skill.nil?
      text[query] = ''
    else
      text[query] = Markup_Battle.skill.name
    end
  end
end

module Markup_Item
  module_function
  def query
    return /\\item\.name/
  end
  def transfer(instance, text, match)
    if Markup_Battle.item.nil?
      text[query] = ''
    else
      text[query] = Markup_Battle.item.name
    end
  end
end

end
end
end
