#==============================================================================
#  Scene_Battle
#------------------------------------------------------------------------------
# ogʂ̏sNXłB
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
module Battle

class Scene_Battle < Scene_Base

  attr_accessor :phase

  attr_reader :spriteset

  attr_reader :status_window

  attr_reader :message_window

  attr_reader :shaker

  attr_reader :interpreter

  #--------------------------------------------------------------------------
  #  CO
  #--------------------------------------------------------------------------
  def main_start
    # 퓬p}[NAbv̏
    for name in Markup_Replaces.constants
      String_Replace_Module.add_markup Markup_Replaces.const_get(name)
    end

    # 퓬p̊eꎞf[^
    @judge_result = JUDGE_RESULT_LOSE
    $game_temp.in_battle = true
    $game_temp.battle_turn = 0
    $game_temp.battle_event_flags.clear
    $game_temp.battle_abort = false
    $game_temp.battle_main_phase = false
    $game_temp.battleback_name = $game_map.battleback_name
    $game_temp.forcing_battler = nil
    # ogCxgpC^v^
    $game_system.battle_interpreter.setup(nil, 0)
    # g[v
    @troop_id = $game_temp.battle_troop_id
    $game_troop.setup(@troop_id)
    # ̑̃EBhE쐬
    @message_window = Window_Message.new
    @message_window.battle_message_position = 2 # ɕ\
    @message_window.sprite_message.no_wait = true # bZ[WEFCgȂ
    @status_window = Window_Status.new
    # XvCgZbg쐬
    @spriteset = Spriteset_Battle.new
    # VFCNpIuWFNg쐬
    @shaker = Shake_Window.new
    # EFCgJEg
    @wait_count = 0
    # gWVs
    if $data_system.battle_transition == ""
      Graphics.transition(20)
    else
      Graphics.transition(40, "Graphics/Transitions/" +
        $data_system.battle_transition)
    end
    # ANVOpC^[v^[
    @interpreter = Interpreter.new(0,false)
    # vogtF[YJn
    @phase = Phase_Battle_Start.new
  end

  #--------------------------------------------------------------------------
  #  C㏈
  #--------------------------------------------------------------------------
  def main_end
    # 퓬p}[NAbv̍폜
    for name in Markup_Replaces.constants
      String_Replace_Module.delete_markup Markup_Replaces.const_get(name)
    end
    # C^[v^[
    $game_system.battle_interpreter.setup(nil, 0)
    # }bvtbV
    $game_map.refresh
    # gWV
    Graphics.freeze
    # EBhE
    @status_window.dispose
    @message_window.dispose
    if @skill_window != nil
      @skill_window.dispose
    end
    if @item_window != nil
      @item_window.dispose
    end
    if @result_window != nil
      @result_window.dispose
    end
    # XvCgZbg
    @spriteset.dispose
    # ^Cgʂɐ؂ւ̏ꍇ
    if $scene.is_a?(Scene_Title)
      # ʂtF[hAEg
      Graphics.transition
      Graphics.freeze
    end
    # 퓬eXgQ[I[o[ʈȊOɐ؂ւ̏ꍇ
    if $BTEST and not $scene.is_a?(Scene_Gameover)
      $scene = nil
    end
  end

  #--------------------------------------------------------------------------
  #  t[XV
  #--------------------------------------------------------------------------
  def update
    # ogCxgs̏ꍇ
    if $game_system.battle_interpreter.running?
      # C^v^XV
      $game_system.battle_interpreter.update
      # ANVĂog[݂Ȃꍇ
      if $game_temp.forcing_battler == nil
        # ogCxg̎sIꍇ
        unless $game_system.battle_interpreter.running?
          # 퓬p̏ꍇAogCxg̃ZbgAbvĎs
          unless judge
            setup_battle_event
          end
        end
        # At^[ogtF[YłȂ
        if @phase != 5
          if not $game_temp.message_window_showing
            # Xe[^XEBhEtbV
#            @status_window.refresh
          end
        end
      end
    else
      # ogCxgsł͂ȂāAANVOpCxgs̏ꍇ
      if @interpreter.running?
        @interpreter.update
      end
    end
    # VXe (^C}[)AʂXV
    $game_system.update
    $game_screen.update
    # ^C}[ 0 ɂȂꍇ
    if $game_system.timer_working and $game_system.timer == 0
      # ogf
      $game_temp.battle_abort = true
    end
    # EBhEXV
#    @status_window.update
    @message_window.update
    # XvCgZbgXV
    @spriteset.update
    # gWV̏ꍇ
    if $game_temp.transition_processing
      # gWVtONA
      $game_temp.transition_processing = false
      # gWVs
      if $game_temp.transition_name == ""
        Graphics.transition(20)
      else
        Graphics.transition(40, "Graphics/Transitions/" +
          $game_temp.transition_name)
      end
    end
    # bZ[WEBhE\̏ꍇ
    if $game_temp.message_window_showing
      return
    end
    # GtFNg\̏ꍇ
    if @spriteset.effect?
      return
    end
    # Q[I[o[̏ꍇ
    if $game_temp.gameover
      # Q[I[o[ʂɐ؂ւ
      $scene = Scene_Gameover.new
      return
    end
    # ^Cgʂɖ߂ꍇ
    if $game_temp.to_title
      # ^Cgʂɐ؂ւ
      $scene = Scene_Title.new
      return
    end
    # ogf̏ꍇ
    if $game_temp.battle_abort
      # ogJnO BGM ɖ߂
      $game_system.bgm_play($game_temp.map_bgm)
      # ogI
      battle_end(1)
      return
    end
    # EFCg̏ꍇ
    if @wait_count > 0
      # EFCgJEg炷
      @wait_count -= 1
      return
    end
    # ANVĂog[݂A
    # ogCxgs̏ꍇ
    if $game_temp.forcing_battler == nil and
       ($game_system.battle_interpreter.running? or @interpreter.running?)
      return
    end
    # tF[Y̍XV
    @phase.update
    if @phase.nil?
      return
    end
  end

  def win?
    return @judge_result == JUDGE_RESULT_WIN
  end
  JUDGE_RESULT_WIN = 0

  def lose?
    return @judge_result == JUDGE_RESULT_LOSE
  end
  JUDGE_RESULT_LOSE = 1

  #--------------------------------------------------------------------------
  #  s
  # ʂotrue
  #--------------------------------------------------------------------------
  def judge
    # SŔ肪^A܂̓p[eBl 0 l̏ꍇ
    if $game_party.all_dead? or $game_party.actors.size == 0
      # 
      @judge_result = JUDGE_RESULT_LOSE
      # true Ԃ
      return true
    end
    # Gl~[ 1 ̂ł݂ false Ԃ
    for enemy in $game_troop.enemies
      if enemy.exist?
        return false
      end
    end
    # 
    @judge_result = JUDGE_RESULT_WIN
    # true Ԃ
    return true
  end

  #--------------------------------------------------------------------------
  #  ogI
  #     result :  (0: 1:sk 2:)
  #--------------------------------------------------------------------------
  def battle_end(result)
    # 퓬tONA
    $game_temp.in_battle = false
    # p[eBS̃ANVNA
    $game_party.clear_actions
    # ogpXe[g
    for actor in $game_party.actors
      actor.remove_states_battle
    end
    # Gl~[NA
    $game_troop.enemies.clear
    # og R[obNĂ
    if $game_temp.battle_proc != nil
      $game_temp.battle_proc.call(result)
      $game_temp.battle_proc = nil
    end
    # }bvʂɐ؂ւ
    $scene = Scene_Map.new
  end

  #--------------------------------------------------------------------------
  #  ogCxg̃ZbgAbv
  #--------------------------------------------------------------------------
  def setup_battle_event
    # ogCxgs̏ꍇ
    if $game_system.battle_interpreter.running?
      return
    end
    # ogCxg̑Sy[W
    for index in 0...$data_troops[@troop_id].pages.size
      # Cxgy[W擾
      page = $data_troops[@troop_id].pages[index]
      # Cxg c ŎQƉ\
      c = page.condition
      # w肳ĂȂꍇ͎̃y[W
      unless c.turn_valid or c.enemy_valid or
             c.actor_valid or c.switch_valid
        next
      end
      # sς݂̏ꍇ͎̃y[W
      if $game_temp.battle_event_flags[index]
        next
      end
      # ^[ mF
      if c.turn_valid
        n = $game_temp.battle_turn
        a = c.turn_a
        b = c.turn_b
        if (b == 0 and n != a) or
           (b > 0 and (n < 1 or n < a or n % b != a % b))
          next
        end
      end
      # Gl~[ mF
      if c.enemy_valid
        enemy = $game_troop.enemies[c.enemy_index]
        if enemy == nil or enemy.hp * 100.0 / enemy.maxhp > c.enemy_hp
          next
        end
      end
      # AN^[ mF
      if c.actor_valid
        actor = $game_actors[c.actor_id]
        if actor == nil or actor.hp * 100.0 / actor.maxhp > c.actor_hp
          next
        end
      end
      # XCb` mF
      if c.switch_valid
        if $game_switches[c.switch_id] == false
          next
        end
      end
      # CxgZbgAbv
      $game_system.battle_interpreter.setup(page.list, 0)
      # ̃y[W̃Xp [og]  [^[] ̏ꍇ
      if page.span <= 1
        # sς݃tOZbg
        $game_temp.battle_event_flags[index] = true
      end
      return
    end
  end

end
end
end
