#==============================================================================
#  String_Replace_Module
#------------------------------------------------------------------------------
# u
# Copyright (C) 2005 fukuyama
#==============================================================================

module String_Replace_Module

  @@markup_replace_list = [] # up}[NAbvNXXg

  #--------------------------------------------------------------------------
  #  }[NAbvNXǉ
  #--------------------------------------------------------------------------
  def add_markup(klass)
    return if @@markup_replace_list.include?(klass)
    @@markup_replace_list.push klass
  end
  module_function :add_markup

  #--------------------------------------------------------------------------
  #  }[NAbvNX폜
  #--------------------------------------------------------------------------
  def delete_markup(klass)
    @@markup_replace_list.delete klass
  end
  module_function :delete_markup

  #--------------------------------------------------------------------------
  #  }[NAbvu
  #--------------------------------------------------------------------------
  def markup_replace(_text)
    text = _text.dup
    loop do
      replace = false
      @@markup_replace_list.each do |klass|
        if text =~ klass.query
          klass.transfer(self,text,$~)
          replace = true
        end
      end
      break if not replace
    end
    return text
  end
  module_function :markup_replace
end
