#==============================================================================
#  Window_InputArea
#------------------------------------------------------------------------------
# ͗pEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

class Window_InputArea < Window_Base
  #--------------------------------------------------------------------------
  # 
  #--------------------------------------------------------------------------
  def initialize(count)
    @char_width = 24
    @count = count
    @index = 0
    @text  = []
    w = @count * @char_width + 32
    h = 32 + 32
    x = 640 / 2 - w / 2
    y = 128 - h - 8
    super(x,y,w,h)
    self.contents = Bitmap.new(self.width - 32, self.height - 32)
    refresh
  end
  #--------------------------------------------------------------------------
  # ꕶǉ
  #--------------------------------------------------------------------------
  def add_char(char)
    if @count <= @index
      return
    end
    @text[@index] = char
    @index += 1
    refresh
  end
  #--------------------------------------------------------------------------
  # ꕶ폜
  #--------------------------------------------------------------------------
  def del_char
    if @index == 0
      return
    end
    @text.delete_at(-1)
    @index -= 1
    refresh
  end
  #--------------------------------------------------------------------------
  # ͂ꂽeLXg擾
  #--------------------------------------------------------------------------
  def text
    return @text.join
  end
  #--------------------------------------------------------------------------
  # 󂩂ǂ
  #--------------------------------------------------------------------------
  def empty?
    return @text.empty?
  end
  #--------------------------------------------------------------------------
  # ő傩ǂ
  #--------------------------------------------------------------------------
  def max?
    return (@count == @index)
  end
  #--------------------------------------------------------------------------
  # ĕ`
  #--------------------------------------------------------------------------
  def refresh
    self.contents.clear
    for i in 0 .. @count
      char = @text[i]
      if char.nil?
        char = ''
      end
      self.contents.draw_text(i * @char_width,0,@char_width,32,char,1)
    end
  end
  #--------------------------------------------------------------------------
  # J[\XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    if @count == @index
      self.cursor_rect.empty
      return
    end
    self.cursor_rect.set(@index * @char_width,0,@char_width,32)
  end
  #--------------------------------------------------------------------------
  # XV
  #--------------------------------------------------------------------------
  def update
    update_cursor_rect
    super
  end
end
