#==============================================================================
#  Window_Menu
#------------------------------------------------------------------------------
# Window_MenuJ[\XvCgΉɂ
# Copyright (C) 2005 fukuyama
#==============================================================================

class Window_Menu
  #--------------------------------------------------------------------------
  # J[\XvCg̎擾
  #--------------------------------------------------------------------------
  def sprite_cursor
    if @sprite_cursor.nil?
      @sprite_cursor = Sprite_Cursor.new(self.viewport)
      @sprite_cursor.z = self.z + 1
      @_sprite_cursor_prev_index = -1
    end
    return @sprite_cursor
  end
  #--------------------------------------------------------------------------
  # J[\XvCg̈ړ
  #--------------------------------------------------------------------------
  def move_cursor_sprite
    # ڂ̍WvZ
    if @index == @_sprite_cursor_prev_index
      return
    else
      @_sprite_cursor_prev_index = @index
    end
    return if page_item_max == 0
    page, i = @index.divmod page_item_max
    self.ox = page * _contents_width
    rect = menu_rect(i)

    tx = 4 + 16 / 2 - sprite_cursor.src_rect.width / 2
    ty = 16 + rect.height / 2 - sprite_cursor.src_rect.height / 2
    sprite_cursor.x = self.x + rect.x + tx
    sprite_cursor.y = self.y + rect.y + ty
    sprite_cursor.z = self.z + 1
  end
  #--------------------------------------------------------------------------
  # J[\XvCg̍XV
  #--------------------------------------------------------------------------
  def update_cursor_sprite
    sprite_cursor.visible = self.visible
    if self.active
      @sprite_cursor.white_blink_on
    else
      @sprite_cursor.white_blink_off
    end
    sprite_cursor.update
    move_cursor_sprite
  end
  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    return if self.disposed?
    return if self.contents.nil?
    # J[\ʒu 0 ̏ꍇ
    if @index < 0 || @menus.size == 0
      if not @sprite_cursor.nil?
        sprite_cursor.visible = false
      end
      self.cursor_rect.empty
      self.ox = 0
      return
    end

    if @sprite_cursor.nil?
      sprite_cursor.visible = false
      return
    end

    update_cursor_sprite
  end
  #--------------------------------------------------------------------------
  # EBhEƃJ[\̉Ԃ𓯊
  #--------------------------------------------------------------------------
  if not self.method_defined?('sprite_Cursor_Window_Menu_visible=')
    alias sprite_Cursor_Window_Menu_visible= visible=
  end
  def visible=(arg)
    self.sprite_Cursor_Window_Menu_visible=(arg)
    if not @sprite_cursor.nil?
      sprite_cursor.visible = self.visible
    end
  end
  #--------------------------------------------------------------------------
  # EBhE폜ɃJ[\
  #--------------------------------------------------------------------------
  if not self.method_defined?('sprite_Cursor_Window_Menu_dispose')
    alias sprite_Cursor_Window_Menu_dispose dispose
  end
  def dispose
    if not @sprite_cursor.nil?
      @sprite_cursor.dispose
    end
    self.sprite_Cursor_Window_Menu_dispose
  end
end
